/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.light.fixture;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.RenderTypes;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.patryk3211.powergrid.electricity.light.bulb.LightBulbState;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlock;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlockEntity;

public class LightFixtureRenderer
extends SafeBlockEntityRenderer<LightFixtureBlockEntity> {
    public LightFixtureRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(LightFixtureBlockEntity be, float partialTicks, PoseStack matrices, MultiBufferSource consumer, int light, int overlay) {
        LightBulbState bulbState = be.getBulbState();
        if (bulbState == null) {
            return;
        }
        BlockState state = be.m_58900_();
        VertexConsumer vb = consumer.m_6299_(RenderType.m_110463_());
        PartialModel model = bulbState.getModel();
        if (model == null) {
            return;
        }
        SuperByteBuffer buffer = CachedBuffers.partial((PartialModel)model, (BlockState)state);
        Direction facing = (Direction)state.m_61143_((Property)LightFixtureBlock.FACING);
        ((SuperByteBuffer)this.rotateToFacing(buffer, facing).translate(((LightFixtureBlock)state.m_60734_()).modelOffset)).light(light).renderInto(matrices, vb);
        if (bulbState.isBurned()) {
            return;
        }
        VertexConsumer vba = consumer.m_6299_(RenderTypes.additive());
        PartialModel lightModel = bulbState.getLightModel();
        SuperByteBuffer lightBuffer = CachedBuffers.partial((PartialModel)lightModel, (BlockState)state);
        int a = (int)(255.0f * bulbState.getAlpha());
        ((SuperByteBuffer)this.rotateToFacing(lightBuffer, facing).translate(((LightFixtureBlock)state.m_60734_()).modelOffset)).light(light).color(a, a, a, 255).renderInto(matrices, vba);
    }

    public SuperByteBuffer rotateToFacing(SuperByteBuffer buffer, Direction facing) {
        return switch (facing) {
            case Direction.UP -> buffer;
            case Direction.DOWN -> (SuperByteBuffer)buffer.rotateCentered((float)Math.PI, Direction.EAST);
            default -> {
                buffer.rotateCentered(1.5707964f, Direction.EAST);
                yield (SuperByteBuffer)buffer.rotateCentered((float)((double)(facing.m_122435_() / 180.0f) * Math.PI), Direction.SOUTH);
            }
        };
    }
}

