/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim;

import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;

public class SwitchedWire
extends ElectricWire {
    private boolean state;

    public SwitchedWire(float resistance, IElectricNode node1, IElectricNode node2) {
        super(resistance, node1, node2);
        this.state = true;
    }

    public SwitchedWire(float resistance, IElectricNode node1, IElectricNode node2, boolean initialState) {
        super(resistance, node1, node2);
        this.state = initialState;
    }

    public void setState(boolean state) {
        if (this.state != state) {
            this.state = state;
            if (this.network != null) {
                if (state) {
                    this.network.updateConductance(this, super.conductance() - 5.0E-9);
                } else {
                    this.network.updateConductance(this, -super.conductance() + 5.0E-9);
                }
            }
        }
    }

    public boolean getState() {
        return this.state;
    }

    @Override
    public void setResistance(double resistance) {
        if (this.state) {
            super.setResistance(resistance);
        } else {
            this.resistance = resistance;
        }
    }

    @Override
    public float current() {
        return this.state ? super.current() : 0.0f;
    }

    @Override
    public double conductance() {
        return this.state ? super.conductance() : 5.0E-9;
    }
}

