/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.special;

import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.solver.IOuterHook;
import org.patryk3211.powergrid.electricity.sim.solver.IResidualAdder;
import org.patryk3211.powergrid.electricity.sim.solver.IStaticResidual;

public class ColdCathodeRegulatorTubeWire
extends AbstractElectricWire
implements IOuterHook,
IStaticResidual {
    private final float breakdownVoltage;
    private final float holdingVoltage;
    private final float holdingCurrent;
    private final float dischargeConductance;
    private double conductance;
    public boolean lit = false;
    private double I;

    public ColdCathodeRegulatorTubeWire(float breakdownVoltage, float holdingVoltage, float holdingCurrent, float dischargeConductance, IElectricNode anode, IElectricNode cathode) {
        super(anode, cathode);
        this.breakdownVoltage = breakdownVoltage;
        this.holdingVoltage = holdingVoltage;
        this.holdingCurrent = holdingCurrent;
        this.dischargeConductance = dischargeConductance;
    }

    @Override
    public double conductance() {
        return this.conductance;
    }

    public void updateConductance(double conductance) {
        if (this.network != null) {
            this.network.updateConductance(this, conductance - this.conductance);
        }
        this.conductance = conductance;
    }

    @Override
    public void addStaticResidual(IResidualAdder residual) {
        if (this.lit) {
            this.I = this.holdingVoltage * this.dischargeConductance;
            residual.add(this.node1.getIndex(), this.I);
            residual.add(this.node2.getIndex(), -this.I);
        } else {
            this.I = 0.0;
        }
    }

    @Override
    public float current() {
        return (float)((double)super.current() - this.I);
    }

    @Override
    public void preSolve() {
        double V = this.potentialDifference();
        double I = this.current();
        if (!this.lit && V > (double)this.breakdownVoltage) {
            this.updateConductance(this.dischargeConductance);
            this.lit = true;
        } else if (this.lit && I < (double)this.holdingCurrent) {
            this.updateConductance(1.0E-8);
            this.lit = false;
        }
    }
}

