/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.special;

import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.solver.IResidualAdder;
import org.patryk3211.powergrid.electricity.sim.solver.IStaticResidual;

public class LRSeriesWire
extends AbstractElectricWire
implements IStaticResidual {
    private double inductance;
    private double resistance;
    private double I;
    private double currentInject;
    private double residualScale;

    public LRSeriesWire(double L, double R, IElectricNode node1, IElectricNode node2) {
        super(node1, node2);
        this.inductance = L;
        this.resistance = R;
        double R_Inductor = 2.0 * this.inductance / 0.05;
        double G_I = 1.0 / R_Inductor;
        this.residualScale = 1.0 - G_I / (1.0 / this.resistance + G_I);
    }

    @Override
    public double conductance() {
        return 1.0 / (this.resistance + 2.0 * this.inductance / 0.05);
    }

    @Override
    public float current() {
        return (float)((double)super.current() + this.I);
    }

    public void setCurrent(float current) {
        this.currentInject = current - this.current();
    }

    @Override
    public void addStaticResidual(IResidualAdder residual) {
        double R_Inductor = 2.0 * this.inductance / 0.05;
        double V_Inductor = (double)this.potentialDifference() * R_Inductor / (R_Inductor + this.resistance) - this.I * this.resistance;
        double G_I = 1.0 / R_Inductor;
        this.I = ((V_Inductor * G_I + (double)this.current()) * 0.99999 + this.currentInject) * this.residualScale;
        this.currentInject = 0.0;
        if (this.node1 != null) {
            residual.add(this.node1.getIndex(), -this.I);
        }
        if (this.node2 != null) {
            residual.add(this.node2.getIndex(), this.I);
        }
    }

    public void setLR(double L, double R) {
        double oldConductance = this.conductance();
        this.inductance = L;
        this.resistance = R;
        double R_Inductor = 2.0 * this.inductance / 0.05;
        double G_I = 1.0 / R_Inductor;
        this.residualScale = 1.0 - G_I / (1.0 / this.resistance + G_I);
        if (this.network != null) {
            this.network.updateConductance(this, this.conductance() - oldConductance);
        }
    }

    public void setInductance(double L) {
        this.setLR(L, this.resistance);
    }

    public void setResistance(double R) {
        this.setLR(this.inductance, R);
    }
}

