/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.special;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.createmod.ponder.api.level.PonderLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLinePart;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;

public class TransmissionLine
extends ElectricWire {
    public static final boolean ENABLE_VALIDATION = false;
    public final List<TransmissionLinePart> segments = new ArrayList<TransmissionLinePart>();
    private static int NEXT_ID = 0;
    private final int id;
    protected final WorldNetworks global;
    private IWireEndpoint endpoint1;
    private IWireEndpoint endpoint2;
    private boolean splitting = false;

    public TransmissionLine(double resistance, IWireEndpoint endpoint1, IWireEndpoint endpoint2, WorldNetworks global) {
        super(resistance, endpoint1.getNode(global.world), endpoint2.getNode(global.world));
        if (global.world.f_46443_ && !(global.world instanceof PonderLevel)) {
            PowerGrid.LOGGER.warn("This method probably shouldn't be used on client-side");
        }
        this.global = global;
        this.endpoint1 = endpoint1;
        this.endpoint2 = endpoint2;
        this.id = NEXT_ID++;
    }

    public TransmissionLine(int id, double resistance, OwnedFloatingNode node1, OwnedFloatingNode node2, WorldNetworks global) {
        super(resistance, node1, node2);
        if (!global.world.f_46443_) {
            PowerGrid.LOGGER.warn("This method probably shouldn't be used on server-side");
        }
        this.global = global;
        this.id = id;
    }

    private int validateEndpoints(TransmissionLinePart part, BaseWireEntity owner) {
        if (part.endpoint1.equals(owner.getEndpoint1())) {
            if (part.endpoint2.equals(owner.getEndpoint2())) {
                return 1;
            }
        } else if (part.endpoint2.equals(owner.getEndpoint1()) && part.endpoint1.equals(owner.getEndpoint2())) {
            return 2;
        }
        return 0;
    }

    public void validateLine() {
        PowerGrid.LOGGER.info("Validating {}", (Object)this);
        if (!this.segments.get((int)0).endpoint1.equals(this.endpoint1)) {
            PowerGrid.LOGGER.error("Line doesn't start where its first segment starts");
        }
        if (!this.segments.get((int)(this.segments.size() - 1)).endpoint2.equals(this.endpoint2)) {
            PowerGrid.LOGGER.error("Line doesn't end where its last segment ends");
        }
        IWireEndpoint prevEndpoint = this.endpoint1;
        for (TransmissionLinePart segment : this.segments) {
            if (!segment.endpoint1.equals(prevEndpoint)) {
                PowerGrid.LOGGER.error("Line not continuous, divergence between {} and {}", (Object)segment.endpoint1, (Object)prevEndpoint);
            }
            prevEndpoint = segment.endpoint2;
        }
    }

    public WorldNetworks global() {
        return this.global;
    }

    public void setNode1(@NotNull IWireEndpoint endpoint, OwnedFloatingNode node) {
        this.endpoint1 = endpoint;
        super.setNode1(node);
    }

    public void setNode2(@NotNull IWireEndpoint endpoint, OwnedFloatingNode node) {
        this.endpoint2 = endpoint;
        super.setNode2(node);
    }

    @Override
    public void setNode1(IElectricNode node1) {
        assert (node1 instanceof OwnedFloatingNode);
        super.setNode1(Objects.requireNonNull(node1));
        this.endpoint1 = ((OwnedFloatingNode)node1).endpoint;
    }

    @Override
    public void setNode2(IElectricNode node2) {
        assert (node2 instanceof OwnedFloatingNode);
        super.setNode2(Objects.requireNonNull(node2));
        this.endpoint2 = ((OwnedFloatingNode)node2).endpoint;
    }

    @Override
    public void flipNodes() {
        super.flipNodes();
        IWireEndpoint endpoint = this.endpoint1;
        this.endpoint1 = this.endpoint2;
        this.endpoint2 = endpoint;
    }

    @Override
    public OwnedFloatingNode getNode1() {
        return (OwnedFloatingNode)this.node1;
    }

    @Override
    public OwnedFloatingNode getNode2() {
        return (OwnedFloatingNode)this.node2;
    }

    public IWireEndpoint getEndpoint1() {
        return this.endpoint1;
    }

    public IWireEndpoint getEndpoint2() {
        return this.endpoint2;
    }

    public void grabPart(@NotNull BaseWireEntity owner, TransmissionLinePart part) {
        if (part.persistentOwnerId.equals(owner.m_20148_())) {
            int endpointArrangement = this.validateEndpoints(part, owner);
            if (endpointArrangement == 1 || endpointArrangement == 2) {
                OwnedFloatingNode node1 = part.endpoint1.getNode(owner.m_9236_());
                OwnedFloatingNode node2 = part.endpoint2.getNode(owner.m_9236_());
                this.global.movePartMap(part.getNode1(), node1, part);
                this.global.movePartMap(part.getNode2(), node2, part);
                part.setNode1(node1);
                part.setNode2(node2);
                if (endpointArrangement == 2) {
                    owner.flipEndpoints();
                }
            } else {
                PowerGrid.LOGGER.warn("Endpoint of wire and unloaded line segment do not match\n{}, {} vs {}, {}", new Object[]{part.endpoint1, part.endpoint2, owner.getEndpoint1(), owner.getEndpoint2()});
                this.remove();
                return;
            }
            if (part.getEndpoint1().equals(this.endpoint1) && this.endpoint1.getNode(this.global.world) != this.node1) {
                this.setNode1(this.endpoint1.getNode(this.global.world));
            }
            if (part.getEndpoint2().equals(this.endpoint2) && this.endpoint2.getNode(this.global.world) != this.node2) {
                this.setNode2(this.endpoint2.getNode(this.global.world));
            }
            if (part.getResistance() != (double)owner.getResistance()) {
                double diff = (double)owner.getResistance() - part.getResistance();
                part.setResistance(owner.getResistance());
                this.setResistance(this.getResistance() + diff);
            }
            if (part.getNode2() != this.node2) {
                this.global.assignTransmissionLine(part.getNode2(), this);
            }
            if (part.getNode1() != this.node1) {
                this.global.assignTransmissionLine(part.getNode1(), this);
            }
            if (ModdedConfigs.logsEnabled()) {
                PowerGrid.LOGGER.debug("{}: Grabbed unloaded part of line, owner={}, between=({}, {})", new Object[]{this, owner, part.getNode1(), part.getNode2()});
            }
        }
    }

    public void addLastSegment(TransmissionLinePart wire) {
        assert (wire.getNode1() == this.getNode2());
        wire.setLine(this);
        this.segments.add(wire);
        this.setResistance(this.resistance + wire.getResistance());
        OwnedFloatingNode oldNode = this.getNode2();
        this.global.assignTransmissionLine(this.getNode2(), this);
        this.setNode2(wire.endpoint2, wire.getNode2());
        this.global.assignTransmissionLine(this.getNode2(), null);
        this.network.removeNode(oldNode);
    }

    public void addFirstSegment(TransmissionLinePart wire) {
        assert (wire.getNode2() == this.getNode1());
        wire.setLine(this);
        this.segments.add(0, wire);
        this.setResistance(this.resistance + wire.getResistance());
        OwnedFloatingNode oldNode = this.getNode1();
        this.global.assignTransmissionLine(this.getNode1(), this);
        this.setNode1(wire.endpoint1, wire.getNode1());
        this.global.assignTransmissionLine(this.getNode1(), null);
        this.network.removeNode(oldNode);
    }

    public void merge(TransmissionLine line) {
        assert (this.getNode2() == line.getNode1());
        if (ModdedConfigs.logsEnabled()) {
            PowerGrid.LOGGER.debug("{}: Appending {}", (Object)this, (Object)line);
        }
        this.segments.addAll(line.segments);
        this.setResistance(this.resistance + line.getResistance());
        this.global.assignTransmissionLine(line.getNode1(), this);
        this.segments.forEach(part -> {
            this.global.assignTransmissionLine(part.getNode2(), this);
            if (part.owner == null || part.owner.m_213877_()) {
                this.global.bounty(part.persistentOwnerId, part.lastKnownChunk);
            }
            part.setLine(this);
        });
        this.global.assignTransmissionLine(line.getNode2(), null);
        line.segments.clear();
        this.setNode2(line.endpoint2, line.getNode2());
        line.remove();
    }

    @Nullable
    public TransmissionLine splitAt(OwnedFloatingNode atNode) {
        if (atNode == this.node1 || atNode == this.node2 || this.endpoint1.equals(atNode.endpoint) || this.endpoint2.equals(atNode.endpoint)) {
            return null;
        }
        if (this.segments.size() <= 1) {
            return null;
        }
        if (this.splitting) {
            PowerGrid.LOGGER.warn("Prevented a double split call", new Throwable());
            return null;
        }
        this.splitting = true;
        if (ModdedConfigs.logsEnabled()) {
            PowerGrid.LOGGER.debug("{}: Splitting transmission line between {} and {} at {}", new Object[]{this, this.node1, this.node2, atNode});
        }
        ElectricWire line2 = null;
        double R1 = 0.0;
        double R2 = 0.0;
        Iterator<TransmissionLinePart> iter = this.segments.iterator();
        while (iter.hasNext()) {
            TransmissionLinePart segment = iter.next();
            if (line2 == null) {
                R1 += segment.getResistance();
                OwnedFloatingNode splitNode = segment.getNode2();
                if (splitNode == atNode) {
                    line2 = new TransmissionLine(1.0, segment.endpoint2, this.endpoint2, this.global);
                    this.global.assignTransmissionLine(splitNode, null);
                    this.global.inNetwork(this.network, splitNode);
                    this.setNode2(segment.getEndpoint2(), splitNode);
                    continue;
                }
                if (!segment.getEndpoint2().equals(atNode.endpoint)) continue;
                line2 = new TransmissionLine(1.0, segment.endpoint2, this.endpoint2, this.global);
                OwnedFloatingNode newNode = atNode.endpoint.getNode(this.global.world);
                this.global.assignTransmissionLine(newNode, null);
                this.global.assignTransmissionLine(splitNode, null);
                this.global.assignTransmissionLine(atNode, null);
                this.global.inNetwork(this.network, newNode);
                this.setNode2(segment.getEndpoint2(), newNode);
                continue;
            }
            R2 += segment.getResistance();
            segment.setLine((TransmissionLine)line2);
            ((TransmissionLine)line2).segments.add(segment);
            this.global.assignTransmissionLine(segment.getNode2(), (TransmissionLine)line2);
            if (segment.owner == null || segment.owner.m_213877_()) {
                this.global.bounty(segment.persistentOwnerId, segment.lastKnownChunk);
            }
            iter.remove();
        }
        this.setResistance(R1);
        if (line2 != null && R2 > 0.0) {
            line2.setResistance(R2);
            this.global.assignTransmissionLine(((TransmissionLine)line2).getNode2(), null);
            ElectricalNetwork network = this.global.prepareForConnection(((TransmissionLine)line2).endpoint1, ((TransmissionLine)line2).endpoint2);
            if (network != null) {
                network.addWire(line2);
            }
        } else {
            this.splitting = false;
            throw new IllegalStateException("Splitting failed for " + String.valueOf(this));
        }
        this.splitting = false;
        return line2;
    }

    public void flip() {
        List<TransmissionLinePart> segmentsCopy = List.copyOf(this.segments);
        if (ModdedConfigs.logsEnabled()) {
            PowerGrid.LOGGER.debug("{}: Flipping transmission line between {} and {}", new Object[]{this, this.node1, this.node2});
        }
        this.segments.clear();
        for (TransmissionLinePart segment : segmentsCopy) {
            segment.flipNodes();
            this.segments.add(0, segment);
        }
        this.flipNodes();
    }

    @Override
    public void remove() {
        super.remove();
        if (ModdedConfigs.logsEnabled()) {
            PowerGrid.LOGGER.debug("{}: Removing transmission line between {} and {}", new Object[]{this, this.node1, this.node2});
        }
        for (TransmissionLinePart segment : this.segments) {
            this.global.assignTransmissionLine(segment.getNode1(), null);
            this.global.assignTransmissionLine(segment.getNode2(), null);
            this.global.unregisterPart(segment.persistentOwnerId, segment);
            segment.setLine(null);
        }
        this.optimizeNode(this.getNode1());
        this.optimizeNode(this.getNode2());
    }

    public void unresolve() {
        super.remove();
        if (ModdedConfigs.logsEnabled()) {
            PowerGrid.LOGGER.debug("{}: Unresolving transmission line between {} and {}", new Object[]{this, this.node1, this.node2});
        }
        for (TransmissionLinePart segment : this.segments) {
            this.global.assignTransmissionLine(segment.getNode1(), null);
            this.global.assignTransmissionLine(segment.getNode2(), null);
            segment.setLine(null);
        }
        this.optimizeNode(this.getNode1());
        this.optimizeNode(this.getNode2());
    }

    public boolean isPart(ElectricWire wire) {
        return this.segments.contains(wire);
    }

    private void optimizeNode(IElectricNode node) {
        if (this.global.world.f_46443_) {
            return;
        }
        if (this.global.globalGraph.connectionCount(node) == 2) {
            List<IElectricNode> nodes = this.global.globalGraph.getConnectedNodes(node);
            if (nodes.size() != 2) {
                return;
            }
            List<TransmissionLine> lines = nodes.stream().map(connected -> this.global.globalGraph.getFirstWire(node, (IElectricNode)connected)).filter(wire -> wire instanceof TransmissionLine).map(wire -> (TransmissionLine)wire).toList();
            if (lines.size() != 2) {
                return;
            }
            TransmissionLine line1 = lines.get(0);
            TransmissionLine line2 = lines.get(1);
            if (line1.getNetwork() != line2.getNetwork()) {
                return;
            }
            if (line1.getNode1() == line2.getNode2()) {
                line2.merge(line1);
            } else if (line1.getNode2() == line2.getNode1()) {
                line1.merge(line2);
            } else if (line1.getNode1() == line2.getNode1()) {
                line1.flip();
                line1.merge(line2);
            } else if (line1.getNode2() == line2.getNode2()) {
                line2.flip();
                line1.merge(line2);
            } else {
                PowerGrid.LOGGER.error("Unknown line optimization case");
            }
        }
    }

    public void remove(TransmissionLinePart wire) {
        if (this.segments.isEmpty()) {
            PowerGrid.LOGGER.error("Cannot remove segments from an empty transmission line. How is it even here?");
            this.remove();
            return;
        }
        if (!this.segments.contains(wire)) {
            PowerGrid.LOGGER.error("Wire is not part of this transmission line even though it thinks so");
            return;
        }
        if (wire.getNode1() == this.node1) {
            PowerGrid.LOGGER.debug("{}: Removing first segment of transmission line", (Object)this);
            TransmissionLinePart removed = this.segments.remove(0);
            assert (removed == wire);
            removed.setLine(null);
            if (this.segments.isEmpty()) {
                this.remove();
                return;
            }
            this.setResistance(this.resistance - removed.getResistance());
            OwnedFloatingNode node1 = wire.endpoint2.getNode(this.global.world);
            this.global.assignTransmissionLine(node1, null);
            this.global.inNetwork(this.network, node1);
            OwnedFloatingNode optiNode = this.getNode1();
            this.setNode1(wire.endpoint2, node1);
            this.optimizeNode(optiNode);
        } else if (wire.getNode2() == this.node2) {
            if (ModdedConfigs.logsEnabled()) {
                PowerGrid.LOGGER.debug("{}: Removing last segment of transmission line", (Object)this);
            }
            TransmissionLinePart removed = this.segments.remove(this.segments.size() - 1);
            assert (removed == wire);
            removed.setLine(null);
            if (this.segments.isEmpty()) {
                this.remove();
                return;
            }
            this.setResistance(this.resistance - removed.getResistance());
            OwnedFloatingNode node2 = wire.endpoint1.getNode(this.global.world);
            this.global.assignTransmissionLine(node2, null);
            this.global.inNetwork(this.network, node2);
            OwnedFloatingNode optiNode = this.getNode2();
            this.setNode2(wire.endpoint1, node2);
            this.optimizeNode(optiNode);
        } else {
            OwnedFloatingNode splitNode;
            TransmissionLine line2;
            if (ModdedConfigs.logsEnabled()) {
                PowerGrid.LOGGER.debug("{}: Removing middle segment of transmission line", (Object)this);
            }
            if ((line2 = this.splitAt(splitNode = wire.getNode2())) == null) {
                return;
            }
            TransmissionLinePart removed = this.segments.remove(this.segments.size() - 1);
            assert (removed == wire);
            removed.setLine(null);
            OwnedFloatingNode terminatingNode = wire.endpoint1.getNode(this.global.world);
            this.global.assignTransmissionLine(terminatingNode, null);
            if (this.segments.isEmpty()) {
                if (ModdedConfigs.logsEnabled()) {
                    PowerGrid.LOGGER.debug("{}: Split and remove resulted in an empty line", (Object)this);
                }
                this.remove();
                return;
            }
            this.setResistance(this.resistance - removed.getResistance());
            this.global.inNetwork(this.network, terminatingNode);
            this.setNode2(wire.endpoint1, terminatingNode);
        }
    }

    public String toString() {
        return String.format("TransmissionLine[id=%d]", this.id);
    }

    public int getId() {
        return this.id;
    }

    public float voltageFor(OwnedFloatingNode node) {
        if (node == this.node1 || node == this.node2) {
            return node.getVoltage();
        }
        float R = 0.0f;
        for (TransmissionLinePart segment : this.segments) {
            R = (float)((double)R + segment.getResistance());
            if (segment.getNode2() != node) continue;
            return this.node1.getVoltage() + R * this.current();
        }
        return this.node2.getVoltage();
    }
}

