/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sparkgap;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public class SparkGapValueBehaviour
extends ScrollValueBehaviour {
    public SparkGapValueBehaviour(Component label, SmartBlockEntity be, ValueBoxTransform slot) {
        super(label, be, slot);
        this.between(0, 18);
        this.withFormatter(this::getStringValue);
    }

    private String getStringValue(int i) {
        return Integer.toString(i * 500 + 1000);
    }

    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        ImmutableList rows = ImmutableList.of((Object)Unit.VOLTAGE.get().component());
        ValueSettingsFormatter formatter = new ValueSettingsFormatter(this::formatSettings);
        return new ValueSettingsBoard(this.label, 18, 9, (List)rows, formatter);
    }

    public MutableComponent formatSettings(ValueSettingsBehaviour.ValueSettings settings) {
        return Lang.text(this.getStringValue(settings.value())).component();
    }

    public int getVoltage() {
        return this.getValue() * 500 + 1000;
    }

    public float getCurrent() {
        return (float)this.getValue() * 0.25f + 0.5f;
    }
}

