/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireEntity;

public class JunctionWireEndpoint
implements IWireEndpoint {
    private static final Map<Level, WorldEntry> JUNCTION_NODES = new HashMap<Level, WorldEntry>();
    private UUID id;
    private Vec3 pos;

    public JunctionWireEndpoint() {
        this(null, null);
    }

    public JunctionWireEndpoint(Vec3 pos) {
        this(pos, UUID.randomUUID());
    }

    private JunctionWireEndpoint(Vec3 pos, UUID id) {
        this.pos = pos;
        this.id = id;
    }

    @Override
    public WireEndpointType type() {
        return WireEndpointType.JUNCTION;
    }

    @Override
    public void read(CompoundTag nbt) {
        this.pos = new Vec3((double)nbt.m_128457_("X"), (double)nbt.m_128457_("Y"), (double)nbt.m_128457_("Z"));
        this.id = nbt.m_128342_("Id");
    }

    @Override
    public void write(CompoundTag nbt) {
        nbt.m_128350_("X", (float)this.pos.f_82479_);
        nbt.m_128350_("Y", (float)this.pos.f_82480_);
        nbt.m_128350_("Z", (float)this.pos.f_82481_);
        nbt.m_128362_("Id", this.id);
    }

    @Override
    @NotNull
    public Vec3 getExactPosition(Level world) {
        return this.pos;
    }

    @Override
    public OwnedFloatingNode getNode(Level world) {
        return JunctionWireEndpoint.getNode((Level)world, (UUID)this.id, (boolean)false, (JunctionWireEndpoint)this).node;
    }

    @Override
    public void joinNetwork(Level world, ElectricalNetwork network) {
        OwnedFloatingNode node = this.getNode(world);
        if (node.getNetwork() == null) {
            network.addNode((INode)node);
        }
    }

    @Override
    public <T extends BaseWireEntity> boolean canAcceptType(Class<T> clazz) {
        return BlockWireEntity.class.isAssignableFrom(clazz);
    }

    @Override
    public void assignWireEntity(BaseWireEntity entity) {
        if (!(entity instanceof BlockWireEntity)) {
            throw new IllegalArgumentException("Wire junction must receive block wire entities");
        }
        NodeEntry entry = JunctionWireEndpoint.getNode(entity.m_9236_(), this.id, false, this);
        entry.holders.add(entity);
    }

    @Override
    public void removeWireEntity(BaseWireEntity entity) {
        NodeEntry entry = JunctionWireEndpoint.getNode(entity.m_9236_(), this.id, true, this);
        if (entry == null) {
            return;
        }
        entry.holders.remove(entity);
        if (entry.holders.size() == 2) {
            BaseWireEntity target;
            BaseWireEntity source;
            if (entity.m_9236_().f_46443_) {
                return;
            }
            BaseWireEntity wire1 = null;
            BlockWireEntity wire2 = null;
            for (BaseWireEntity holder : entry.holders) {
                if (wire1 == null) {
                    wire1 = (BlockWireEntity)holder;
                    continue;
                }
                wire2 = (BlockWireEntity)holder;
            }
            if (wire1 == null || wire2 == null) {
                throw new ConcurrentModificationException();
            }
            assert (wire1.getWireItem() == wire2.getWireItem());
            boolean wire1End = this.equals(wire1.getEndpoint2());
            boolean wire2End = this.equals(wire2.getEndpoint2());
            entry.holders.clear();
            boolean flipped = false;
            boolean targetFlipped = false;
            if (wire1End || !wire2End) {
                source = wire2;
                if (!wire1End) {
                    target = ((BlockWireEntity)wire1).flip();
                    targetFlipped = true;
                } else {
                    target = wire1;
                }
                if (wire2End) {
                    flipped = true;
                }
            } else {
                source = wire1;
                target = wire2;
            }
            int lastIndex = ((BlockWireEntity)target).segments.size() - 1;
            BlockWireEntity.Point last = ((BlockWireEntity)target).segments.get(lastIndex);
            if (!targetFlipped) {
                ((BlockWireEntity)target).segments.set(lastIndex, new BlockWireEntity.Point(last.direction, last.gridLength + 1));
            }
            if (flipped) {
                ArrayList<BlockWireEntity.Point> segments = new ArrayList<BlockWireEntity.Point>();
                for (BlockWireEntity.Point segment : ((BlockWireEntity)source).segments) {
                    segments.add(0, new BlockWireEntity.Point(segment.direction.m_122424_(), segment.gridLength));
                }
                ((WireEntity)source).dropWire();
                target.setEndpoint2(source.getEndpoint1());
                ((BlockWireEntity)target).extend(segments, source.getWireCount());
            } else {
                ((WireEntity)source).dropWire();
                target.setEndpoint2(source.getEndpoint2());
                ((BlockWireEntity)target).extend(((BlockWireEntity)source).segments, source.getWireCount());
            }
            source.m_146870_();
            JunctionWireEndpoint.removeEntry(entity.m_9236_(), this.id);
        } else if (entry.holders.size() == 1) {
            for (BaseWireEntity holder : entry.holders) {
                if (this.equals(holder.getEndpoint1())) {
                    holder.setEndpoint1(null);
                }
                if (!this.equals(holder.getEndpoint2())) continue;
                holder.setEndpoint2(null);
            }
        } else if (entry.holders.isEmpty()) {
            JunctionWireEndpoint.removeEntry(entity.m_9236_(), this.id);
        }
    }

    @Contract(value="_, _, false, _ -> !null")
    private static NodeEntry getNode(Level world, UUID id, boolean nullable, JunctionWireEndpoint endpoint) {
        if (!nullable) {
            WorldEntry worldNodeMap = JUNCTION_NODES.computeIfAbsent(world, k -> new WorldEntry());
            NodeEntry entry = worldNodeMap.nodes.get(id);
            if (entry == null) {
                entry = new NodeEntry(endpoint);
                worldNodeMap.nodes.put(id, entry);
                worldNodeMap.newNodes.add(entry.node);
            }
            return entry;
        }
        WorldEntry worldNodeMap = JUNCTION_NODES.get(world);
        if (worldNodeMap == null) {
            return null;
        }
        return worldNodeMap.nodes.get(id);
    }

    private static void removeEntry(Level world, UUID id) {
        WorldEntry worldNodeMap = JUNCTION_NODES.get(world);
        if (worldNodeMap == null) {
            return;
        }
        NodeEntry entry = worldNodeMap.nodes.remove(id);
        if (entry == null) {
            return;
        }
        if (!entry.holders.isEmpty()) {
            PowerGrid.LOGGER.error("Tried to remove junction endpoint entry for a junction with holders");
            return;
        }
        GlobalElectricNetworks.getWorldNetworks(world).nodeHolderRemoved(entry.node);
    }

    public static void processNewNodes(Level world) {
        WorldEntry worldNodeMap = JUNCTION_NODES.get(world);
        if (worldNodeMap != null && !worldNodeMap.newNodes.isEmpty()) {
            WorldNetworks global = GlobalElectricNetworks.getWorldNetworks(world);
            Set<OwnedFloatingNode> nodes = worldNodeMap.newNodes;
            worldNodeMap.newNodes = new HashSet<OwnedFloatingNode>();
            for (OwnedFloatingNode node : nodes) {
                global.nodeHolderAdded(node, false);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JunctionWireEndpoint) {
            JunctionWireEndpoint other = (JunctionWireEndpoint)obj;
            return this.id.equals(other.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return String.format("Junction(id=%s)", this.id);
    }

    private static class NodeEntry {
        public final OwnedFloatingNode node;
        public final Set<BaseWireEntity> holders = new HashSet<BaseWireEntity>();

        public NodeEntry(IWireEndpoint endpoint) {
            this.node = new OwnedFloatingNode(endpoint);
        }
    }

    private static class WorldEntry {
        public final Map<UUID, NodeEntry> nodes = new HashMap<UUID, NodeEntry>();
        public Set<OwnedFloatingNode> newNodes = new HashSet<OwnedFloatingNode>();

        private WorldEntry() {
        }
    }
}

