/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire.powercord;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ISocketElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.powercord.CordEntity;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordEndpoint;

public class SocketEndpoint
implements ICordEndpoint {
    private BlockPos pos;

    public SocketEndpoint() {
        this(null);
    }

    public SocketEndpoint(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public IWireEndpoint makeOffset(BlockPos offset) {
        return new SocketEndpoint(this.pos.m_121955_((Vec3i)offset));
    }

    @Override
    public WireEndpointType type() {
        return WireEndpointType.SOCKET;
    }

    @Nullable
    public ISocketElectric getSocketBlock(Level world) {
        if (!world.m_7232_(SectionPos.m_123171_((int)this.pos.m_123341_()), SectionPos.m_123171_((int)this.pos.m_123343_()))) {
            return null;
        }
        return ISocketElectric.getAt(world, this.pos);
    }

    @Nullable
    public ElectricBehaviour getElectricBehaviour(Level world) {
        if (!world.m_7232_(SectionPos.m_123171_((int)this.pos.m_123341_()), SectionPos.m_123171_((int)this.pos.m_123343_()))) {
            return null;
        }
        return (ElectricBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)this.pos, ElectricBehaviour.TYPE);
    }

    @NotNull
    public Direction getFacing(Level world) {
        BlockState state = world.m_8055_(this.pos);
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            return (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        }
        return Direction.NORTH;
    }

    @Override
    public void read(CompoundTag nbt) {
        this.pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Pos"));
    }

    @Override
    public void write(CompoundTag nbt) {
        nbt.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
    }

    @Override
    @NotNull
    public Vec3 getExactPosition(Level world) {
        ISocketElectric socketed = this.getSocketBlock(world);
        if (socketed == null) {
            return Vec3.m_82512_((Vec3i)this.pos);
        }
        ITerminalPlacement placement = socketed.socket(world.m_8055_(this.pos));
        Vec3 origin = placement.getOrigin();
        return new Vec3((double)this.pos.m_123341_() + origin.f_82479_, (double)this.pos.m_123342_() + origin.f_82480_, (double)this.pos.m_123343_() + origin.f_82481_).m_231075_(this.getFacing(world), -0.1875);
    }

    @Override
    public BlockWireEndpoint getEndpoint1() {
        return new BlockWireEndpoint(this.pos, 0);
    }

    @Override
    public BlockWireEndpoint getEndpoint2() {
        return new BlockWireEndpoint(this.pos, 1);
    }

    @Override
    public boolean isValid(Level world) {
        if (!world.m_7232_(SectionPos.m_123171_((int)this.pos.m_123341_()), SectionPos.m_123171_((int)this.pos.m_123343_()))) {
            return false;
        }
        ElectricBehaviour behaviour = this.getElectricBehaviour(world);
        if (behaviour == null) {
            return false;
        }
        return behaviour.hasTerminal(0) && behaviour.hasTerminal(1);
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    public boolean hasConnection(Level world) {
        ElectricBehaviour behaviour = this.getElectricBehaviour(world);
        if (behaviour == null) {
            return false;
        }
        Set<BaseWireEntity> connections1 = behaviour.getConnections().get(this.getEndpoint1());
        Set<BaseWireEntity> connections2 = behaviour.getConnections().get(this.getEndpoint2());
        if (connections1 == null || connections2 == null) {
            return false;
        }
        for (BaseWireEntity wire : connections2) {
            if (!(wire instanceof CordEntity) || !connections1.contains(wire) || !this.equals(wire.getEndpoint1()) && !this.equals(wire.getEndpoint2())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SocketEndpoint) {
            SocketEndpoint other = (SocketEndpoint)obj;
            return Objects.equals(this.pos, other.pos);
        }
        return false;
    }
}

