/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire.powercord;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordEndpoint;

public class SplitCordEndpoint
implements ICordEndpoint {
    private BlockWireEndpoint endpoint1;
    private BlockWireEndpoint endpoint2;

    public SplitCordEndpoint() {
        this.endpoint1 = null;
        this.endpoint2 = null;
    }

    public SplitCordEndpoint(BlockWireEndpoint endpoint1, BlockWireEndpoint endpoint2) {
        this.endpoint1 = endpoint1;
        this.endpoint2 = endpoint2;
    }

    @Override
    public IWireEndpoint makeOffset(BlockPos offset) {
        return new SplitCordEndpoint((BlockWireEndpoint)this.endpoint1.makeOffset(offset), (BlockWireEndpoint)this.endpoint2.makeOffset(offset));
    }

    @Override
    public WireEndpointType type() {
        return WireEndpointType.SPLIT_CORD;
    }

    @Override
    public void read(CompoundTag nbt) {
        if (nbt.m_128441_("Endpoint1")) {
            this.endpoint1 = new BlockWireEndpoint();
            this.endpoint1.read(nbt.m_128469_("Endpoint1"));
        } else {
            this.endpoint1 = null;
        }
        if (nbt.m_128441_("Endpoint2")) {
            this.endpoint2 = new BlockWireEndpoint();
            this.endpoint2.read(nbt.m_128469_("Endpoint2"));
        } else {
            this.endpoint2 = null;
        }
    }

    @Override
    public void write(CompoundTag nbt) {
        if (this.endpoint1 != null) {
            nbt.m_128365_("Endpoint1", (Tag)this.endpoint1.serialize());
        }
        if (this.endpoint2 != null) {
            nbt.m_128365_("Endpoint2", (Tag)this.endpoint2.serialize());
        }
    }

    @Override
    @NotNull
    public Vec3 getExactPosition(Level world) {
        if (this.endpoint1 != null && this.endpoint2 != null) {
            return this.endpoint1.getExactPosition(world).m_82549_(this.endpoint2.getExactPosition(world)).m_82490_(0.5);
        }
        return Vec3.f_82478_;
    }

    @Override
    public boolean isValid(Level world) {
        if (this.endpoint1 == null || this.endpoint2 == null) {
            return false;
        }
        return this.endpoint1.isValid(world) && this.endpoint2.isValid(world);
    }

    @Override
    public BlockWireEndpoint getEndpoint1() {
        return this.endpoint1;
    }

    @Override
    public BlockWireEndpoint getEndpoint2() {
        return this.endpoint2;
    }
}

