/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.rotor;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableObject;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorBehaviour;

@OnlyIn(value=Dist.CLIENT)
public class RotorSoundInstance
extends AbstractTickableSoundInstance {
    private final RotorBehaviour behaviour;

    protected RotorSoundInstance(RotorBehaviour behaviour) {
        super(ModdedSoundEvents.GENERATOR.getMainEvent(), SoundSource.AMBIENT, behaviour.getWorld().f_46441_);
        this.behaviour = behaviour;
        Vec3 pos = behaviour.getPos().m_252807_();
        this.f_119575_ = pos.f_82479_;
        this.f_119576_ = pos.f_82480_;
        this.f_119577_ = pos.f_82481_;
        this.f_119580_ = SoundInstance.Attenuation.LINEAR;
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119573_ = 0.0f;
    }

    public boolean m_7784_() {
        return true;
    }

    public void m_7788_() {
        if (this.behaviour.blockEntity.m_58901_() || !this.behaviour.isController()) {
            this.m_119609_();
        } else {
            MutableObject closest = new MutableObject();
            BlockPos playerPos = Minecraft.m_91087_().f_91074_.m_20183_();
            this.behaviour.forEachSegment(segment -> {
                if (closest.getValue() == null) {
                    closest.setValue((Object)segment.getPos());
                } else {
                    double dCurrent = ((BlockPos)closest.getValue()).m_123331_((Vec3i)playerPos);
                    double dNew = segment.getPos().m_123331_((Vec3i)playerPos);
                    if (dNew < dCurrent) {
                        closest.setValue((Object)segment.getPos());
                    }
                }
            });
            if (closest.getValue() != null) {
                Vec3 pos = ((BlockPos)closest.getValue()).m_252807_();
                this.f_119575_ = pos.f_82479_;
                this.f_119576_ = pos.f_82480_;
                this.f_119577_ = pos.f_82481_;
            }
            float velocity = Math.abs(this.behaviour.getAngularVelocity());
            RotorSoundInstance rotorSoundInstance = this;
            float pitch = velocity / ((float)rotorSoundInstance.behaviour.getMaxRotationSpeed() / 2.0f);
            if (velocity < 32.0f) {
                this.f_119573_ = 0.0f;
                this.m_119609_();
            } else {
                float volume = velocity / 128.0f;
                this.f_119573_ = Mth.m_14036_((float)volume, (float)0.0f, (float)1.0f) * 0.3f;
            }
            this.f_119574_ = Mth.m_14036_((float)pitch, (float)0.5f, (float)2.0f);
        }
    }
}

