/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.winding;

import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.patryk3211.powergrid.kinetics.generator.winding.WindingItem;
import org.patryk3211.powergrid.utility.PlacementOverlay;
import org.patryk3211.powergrid.utility.PlayerUtilities;

@OnlyIn(value=Dist.CLIENT)
public class WindingPreview {
    private static final Random r = new Random();

    @Nullable
    public static ItemStack getUsedWireStack(Player player) {
        ItemStack stack1 = player.m_21205_();
        ItemStack stack2 = player.m_21206_();
        if (stack1 != null && stack1.m_41720_() instanceof WindingItem && stack1.m_41782_()) {
            return stack1;
        }
        if (stack2 != null && stack2.m_41720_() instanceof WindingItem && stack2.m_41782_()) {
            return stack2;
        }
        return null;
    }

    public static void tick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (player == null || world == null) {
            return;
        }
        ItemStack stack = WindingPreview.getUsedWireStack((Player)player);
        if (stack == null) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        int[] posArray = tag.m_128465_("Position");
        if (posArray.length < 3) {
            return;
        }
        BlockPos firstPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        BlockState firstState = world.m_8055_(firstPos);
        if (!ShaftBlock.isShaft((BlockState)firstState)) {
            return;
        }
        HitResult rayTrace = Minecraft.m_91087_().f_91077_;
        if (!(rayTrace instanceof BlockHitResult)) {
            if (r.nextInt(50) == 0) {
                world.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.3f, 0.9f, 0.5f), 1.0f), (double)((float)firstPos.m_123341_() + 0.5f + WindingPreview.randomOffset(0.25f)), (double)((float)firstPos.m_123342_() + 0.5f + WindingPreview.randomOffset(0.25f)), (double)((float)firstPos.m_123343_() + 0.5f + WindingPreview.randomOffset(0.25f)), 0.0, 0.0, 0.0);
            }
            return;
        }
        BlockHitResult hit = (BlockHitResult)rayTrace;
        BlockPos selected = hit.m_82425_();
        BlockState selectedState = world.m_8055_(selected);
        if (!ShaftBlock.isShaft((BlockState)selectedState)) {
            selected = selected.m_121945_(hit.m_82434_());
        }
        boolean canConnect = ShaftBlock.isShaft((BlockState)selectedState) && firstState.m_61143_((Property)BlockStateProperties.f_61365_) == selectedState.m_61143_((Property)BlockStateProperties.f_61365_);
        Direction.Axis placementAxis = WindingItem.getPlacementAxis(selected, firstPos);
        if (placementAxis == firstState.m_61143_((Property)BlockStateProperties.f_61365_)) {
            canConnect = false;
        }
        int length = WindingItem.getPlacementDelta(selected, firstPos);
        if (canConnect) {
            if (length > 0) {
                for (i = 1; i < length; ++i) {
                    if (world.m_8055_(firstPos.m_5487_(placementAxis, i)).m_247087_()) continue;
                    canConnect = false;
                    break;
                }
            } else {
                for (i = -1; i > length; --i) {
                    if (world.m_8055_(firstPos.m_5487_(placementAxis, i)).m_247087_()) continue;
                    canConnect = false;
                    break;
                }
            }
        }
        if (!player.m_7500_()) {
            Item item = stack.m_41720_();
            int count = Math.abs(length) + 1;
            boolean hasItems = PlayerUtilities.hasEnoughItems((Player)player, item, count);
            PlacementOverlay.setItemRequirement(item, count, hasItems);
        }
        Vec3 start = Vec3.m_82528_((Vec3i)firstPos);
        Direction heading = Direction.m_122387_((Direction.Axis)placementAxis, (Direction.AxisDirection)(length > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
        for (float f = 0.0f; f < (float)Math.abs(length); f += 0.0625f) {
            Vec3 position = start.m_231075_(heading, (double)f);
            if (r.nextInt(10) != 0) continue;
            world.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(canConnect ? 0.3f : 0.9f, canConnect ? 0.9f : 0.3f, 0.5f), 1.0f), position.f_82479_ + 0.5, position.f_82480_ + 0.5, position.f_82481_ + 0.5, 0.0, 0.0, 0.0);
        }
    }

    private static float randomOffset(float range) {
        return (r.nextFloat() - 0.5f) * 2.0f * range;
    }
}

