/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.base.IMultiScreenHandlerFactory;
import org.patryk3211.powergrid.circuits.editor.CircuitDesignTableBlockEntity;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.ISchematicHolder;
import org.patryk3211.powergrid.network.SimplePacket;

public class SaveSchematicC2SPacket
implements SimplePacket {
    private final BlockPos pos;
    private CompoundTag nbt;
    @Nullable
    private String name;
    private boolean load;

    public <T extends BlockEntity> SaveSchematicC2SPacket(T be, boolean load) {
        this.pos = be.m_58899_();
        this.nbt = null;
        this.load = load;
    }

    public <T extends BlockEntity> SaveSchematicC2SPacket(T be, @Nullable String name, CircuitSchematic schematic) {
        this.pos = be.m_58899_();
        this.nbt = schematic.serializeNbt();
        this.name = name;
    }

    public SaveSchematicC2SPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        if (buf.readBoolean()) {
            this.nbt = buf.m_130260_();
            if (buf.readBoolean()) {
                this.name = buf.m_130277_();
            }
        } else {
            this.load = buf.readBoolean();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.nbt != null);
        if (this.nbt != null) {
            buf.m_130079_(this.nbt);
            buf.writeBoolean(this.name != null);
            if (this.name != null) {
                buf.m_130070_(this.name);
            }
        } else {
            buf.writeBoolean(this.load);
        }
    }

    @Override
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        NetworkManager.PacketContext ctx = context.get();
        ctx.queue(() -> {
            Level world = ctx.getPlayer().m_9236_();
            BlockEntity be = world.m_7702_(this.pos);
            if (be instanceof CircuitDesignTableBlockEntity) {
                CircuitDesignTableBlockEntity table = (CircuitDesignTableBlockEntity)be;
                if (this.nbt != null) {
                    table.getSchematic().deserializeNbt(this.nbt);
                    table.setSchematicName(this.name);
                    table.notifyUpdate();
                    IMultiScreenHandlerFactory.openScreen((ServerPlayer)ctx.getPlayer(), table, arg_0 -> ((CircuitDesignTableBlockEntity)table).sendToMenu(arg_0), 0);
                } else if (this.load) {
                    table.readFromItem();
                } else {
                    table.writeToItem(ctx.getPlayer().m_7500_());
                }
            } else if (be instanceof ISchematicHolder) {
                ISchematicHolder holder = (ISchematicHolder)be;
                if (ctx.getPlayer().m_7500_() && this.nbt != null) {
                    holder.setSchematic(CircuitSchematic.fromNbt(this.nbt));
                }
            }
        });
    }
}

