/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.patryk3211.powergrid.electricity.ClientElectricNetwork;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLine;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.network.SimplePacket;

public class TransmissionLineManagementS2CPacket
implements SimplePacket {
    private final IWireEndpoint endpoint;
    private final Entry[] entries;

    public TransmissionLineManagementS2CPacket(IWireEndpoint endpoint, Collection<TransmissionLine> lines) {
        this.endpoint = endpoint;
        this.entries = new Entry[lines.size()];
        int i = 0;
        for (TransmissionLine line : lines) {
            this.entries[i++] = Entry.of(line);
        }
    }

    public TransmissionLineManagementS2CPacket(FriendlyByteBuf buf) {
        this.endpoint = WireEndpointType.deserialize(buf.m_130260_());
        int count = buf.readByte();
        this.entries = new Entry[count];
        for (int i = 0; i < count; ++i) {
            this.entries[i] = new Entry(buf.readInt(), buf.readDouble(), WireEndpointType.deserialize(buf.m_130260_()), WireEndpointType.deserialize(buf.m_130260_()));
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        if (this.entries.length > 127) {
            throw new IllegalStateException("Too many lines for one packet");
        }
        buf.m_130079_(this.endpoint.serialize());
        buf.writeByte(this.entries.length);
        for (Entry entry : this.entries) {
            buf.writeInt(entry.id);
            buf.writeDouble(entry.resistance);
            buf.m_130079_(entry.endpoint1.serialize());
            buf.m_130079_(entry.endpoint2.serialize());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> ClientElectricNetwork.getWorldNetworks().lineManagement(this.endpoint, this.entries));
    }

    public record Entry(int id, double resistance, IWireEndpoint endpoint1, IWireEndpoint endpoint2) {
        public static Entry of(TransmissionLine line) {
            return new Entry(line.getId(), line.getResistance(), line.getNode1().endpoint, line.getNode2().endpoint);
        }
    }
}

