/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.utility.forge;

import java.util.Iterator;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class IterateItemHandler {
    public static Iterable<ItemStack> iterable(final IItemHandler handler) {
        return new Iterable<ItemStack>(){

            @Override
            @NotNull
            public Iterator<ItemStack> iterator() {
                return new ItemHandlerIterator(handler);
            }
        };
    }

    public static class ItemHandlerIterator
    implements Iterator<ItemStack> {
        private final IItemHandler handler;
        private int i;

        public ItemHandlerIterator(IItemHandler handler) {
            this.handler = handler;
            this.i = 0;
        }

        @Override
        public ItemStack next() {
            return this.handler.getStackInSlot(this.i++);
        }

        @Override
        public boolean hasNext() {
            return this.i < this.handler.getSlots();
        }
    }
}

