/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.gui;

import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSoundEvents;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.gui.TickableGuiEventListener;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.utility.Lang;

public class CircuitFileBox
extends EditBox
implements TickableGuiEventListener {
    private int tick;
    private final List<String> availableSchematics = new ArrayList<String>();
    private int selectedIndex = 0;
    private boolean soundPlayed = false;
    private final List<Component> toolTip = new ArrayList<Component>();
    private final Component title = Lang.translateDirect("gui.circuit_designer.files", new Object[0]);
    private final Component scrollToSelect = Lang.translateDirect("gui.circuit_designer.file_scroll", new Object[0]);

    public CircuitFileBox(Font font, int x, int y, int width, int height, Component message) {
        super(font, x, y, width, height, message);
        this.m_94202_(-1);
        this.m_94182_(false);
        this.m_94186_(true);
        this.refreshFiles();
        this.onChanged();
    }

    public void m_94120_() {
        super.m_94120_();
        if (this.tick++ >= 20) {
            this.refreshFiles();
            this.tick = 0;
        }
        this.soundPlayed = false;
    }

    private void refreshFiles() {
        try {
            Files.createDirectories(Paths.get("circuits", new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            PowerGrid.LOGGER.error("Failed to create a folder", (Throwable)e);
        }
        this.availableSchematics.clear();
        try {
            Files.list(Paths.get("circuits/", new String[0])).filter(f -> !Files.isDirectory(f, new LinkOption[0]) && f.getFileName().toString().endsWith(".nbt")).forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return;
                }
                this.availableSchematics.add(path.getFileName().toString());
            });
        }
        catch (NoSuchFileException e) {
        }
        catch (IOException e) {
            PowerGrid.LOGGER.error("Exception when loading circuit schematics", (Throwable)e);
        }
        this.availableSchematics.sort((aT, bT) -> {
            String a = aT;
            String b = bT;
            if (a.endsWith(".nbt")) {
                a = a.substring(0, a.length() - 4);
            }
            if (b.endsWith(".nbt")) {
                b = b.substring(0, b.length() - 4);
            }
            int aLength = a.length();
            int bLength = b.length();
            int minSize = Math.min(aLength, bLength);
            boolean asNumeric = false;
            int lastNumericCompare = 0;
            for (int i = 0; i < minSize; ++i) {
                boolean bNumber;
                char aChar = a.charAt(i);
                char bChar = b.charAt(i);
                boolean aNumber = aChar >= '0' && aChar <= '9';
                boolean bl = bNumber = bChar >= '0' && bChar <= '9';
                if (asNumeric) {
                    if (aNumber && bNumber) {
                        if (lastNumericCompare != 0) continue;
                        lastNumericCompare = aChar - bChar;
                        continue;
                    }
                    if (aNumber) {
                        return 1;
                    }
                    if (bNumber) {
                        return -1;
                    }
                    if (lastNumericCompare == 0) {
                        if (aChar != bChar) {
                            return aChar - bChar;
                        }
                        asNumeric = false;
                        continue;
                    }
                    return lastNumericCompare;
                }
                if (aNumber && bNumber) {
                    asNumeric = true;
                    if (lastNumericCompare != 0) continue;
                    lastNumericCompare = aChar - bChar;
                    continue;
                }
                if (aChar == bChar) continue;
                return aChar - bChar;
            }
            if (asNumeric) {
                if (aLength > bLength && a.charAt(bLength) >= '0' && a.charAt(bLength) <= '9') {
                    return 1;
                }
                if (bLength > aLength && b.charAt(aLength) >= '0' && b.charAt(aLength) <= '9') {
                    return -1;
                }
                if (lastNumericCompare == 0) {
                    return aLength - bLength;
                }
                return lastNumericCompare;
            }
            return aLength - bLength;
        });
        int prev = this.selectedIndex;
        this.clamp();
        if (prev != this.selectedIndex) {
            this.onChanged();
        }
        this.updateTooltip();
    }

    private void onChanged() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.availableSchematics.size()) {
            this.m_94144_(this.availableSchematics.get(this.selectedIndex));
        }
        this.updateTooltip();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int step = (int)(-Math.signum(delta)) * (AllKeys.shiftDown() ? 5 : 1);
        int priorState = this.selectedIndex;
        boolean shifted = AllKeys.shiftDown();
        this.selectedIndex += step;
        if (shifted) {
            this.selectedIndex -= this.selectedIndex % 5;
        }
        this.clamp();
        if (priorState != this.selectedIndex) {
            if (!this.soundPlayed) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)AllSoundEvents.SCROLL_VALUE.getMainEvent(), (float)(1.5f + 0.1f * (float)this.selectedIndex / (float)(this.availableSchematics.size() - 1))));
            }
            this.soundPlayed = true;
            this.onChanged();
        }
        return priorState != this.selectedIndex;
    }

    private void clamp() {
        if (this.selectedIndex < 0) {
            this.selectedIndex = 0;
        }
        if (this.selectedIndex >= this.availableSchematics.size()) {
            this.selectedIndex = this.availableSchematics.size() - 1;
        }
    }

    protected void updateTooltip() {
        this.toolTip.clear();
        this.toolTip.add((Component)this.title.m_6879_().m_130938_(s -> s.m_178520_(AbstractSimiWidget.HEADER_RGB.getRGB())));
        int min = Math.min(this.availableSchematics.size() - 16, this.selectedIndex - 7);
        int max = Math.max(16, this.selectedIndex + 8);
        min = Math.max(min, 0);
        max = Math.min(max, this.availableSchematics.size());
        if (1 == min) {
            --min;
        }
        if (min > 0) {
            this.toolTip.add((Component)Component.m_237113_((String)"> ...").m_130940_(ChatFormatting.GRAY));
        }
        if (this.availableSchematics.size() - 1 == max) {
            ++max;
        }
        for (int i = min; i < max; ++i) {
            if (i == this.selectedIndex) {
                this.toolTip.add((Component)Component.m_237119_().m_130946_("-> ").m_130946_(this.availableSchematics.get(i)).m_130940_(ChatFormatting.WHITE));
                continue;
            }
            this.toolTip.add((Component)Component.m_237119_().m_130946_("> ").m_130946_(this.availableSchematics.get(i)).m_130940_(ChatFormatting.GRAY));
        }
        if (max < this.availableSchematics.size()) {
            this.toolTip.add((Component)Component.m_237113_((String)"> ...").m_130940_(ChatFormatting.GRAY));
        }
        this.toolTip.add((Component)this.scrollToSelect.m_6879_().m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
    }

    public List<Component> getToolTip() {
        return this.toolTip;
    }
}

