/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordPlacementHandler;
import org.patryk3211.powergrid.electricity.wire.powercord.SocketEndpoint;
import org.patryk3211.powergrid.utility.Lang;

public interface ISocketElectric {
    public static ISocketElectric getAt(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof ISocketElectric) {
            ISocketElectric electric = (ISocketElectric)block;
            return electric;
        }
        return null;
    }

    public ITerminalPlacement socket(BlockState var1);

    public static class Handler
    implements ICordPlacementHandler {
        @Override
        @NotNull
        public InteractionResultHolder<ICordEndpoint> place(BlockState state, UseOnContext context) {
            ITerminalPlacement terminal;
            ISocketElectric socket = ISocketElectric.getAt(context.m_43725_(), context.m_8083_());
            if (socket != null && (terminal = socket.socket(state)).check(context.m_8083_(), context.m_43720_())) {
                SocketEndpoint endpoint = new SocketEndpoint(context.m_8083_());
                if (endpoint.hasConnection(context.m_43725_())) {
                    IElectric.sendMessage(context, (Component)Lang.translate("message.socket_taken", new Object[0]).style(ChatFormatting.RED).component());
                    return InteractionResultHolder.m_19100_(null);
                }
                return InteractionResultHolder.m_19090_((Object)endpoint);
            }
            return InteractionResultHolder.m_19098_(null);
        }

        @Override
        @Nullable
        public ITerminalPlacement terminal(BlockState state, Level level, BlockHitResult hit) {
            ITerminalPlacement terminal;
            ISocketElectric socket = ISocketElectric.getAt(level, hit.m_82425_());
            if (socket != null && (terminal = socket.socket(state)).check(hit.m_82425_(), hit.m_82450_())) {
                return terminal;
            }
            return null;
        }
    }
}

