/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base;

import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;

public class TerminalBoundingBox
implements ITerminalPlacement,
IDecoratedTerminal {
    private Vec3 min;
    private Vec3 max;
    private Vec3 origin;
    private double expand;
    private final Component name;
    private int color;

    private TerminalBoundingBox(Component name) {
        this.name = name;
        this.color = 0xAAAAAA;
    }

    private TerminalBoundingBox(TerminalBoundingBox other) {
        this.name = other.name;
        this.color = other.color;
        this.expand = other.expand;
        this.min = other.min;
        this.max = other.max;
        this.origin = other.origin;
    }

    public TerminalBoundingBox(Component name, double x1, double y1, double z1, double x2, double y2, double z2) {
        this(name, x1, y1, z1, x2, y2, z2, 0.1);
    }

    public TerminalBoundingBox(Component name, double x1, double y1, double z1, double x2, double y2, double z2, double expand) {
        this(name);
        this.min = new Vec3((x1 - expand) / 16.0, (y1 - expand) / 16.0, (z1 - expand) / 16.0);
        this.max = new Vec3((x2 + expand) / 16.0, (y2 + expand) / 16.0, (z2 + expand) / 16.0);
        this.origin = new Vec3((x1 + x2) * 0.03125, (y1 + y2) * 0.03125, (z1 + z2) * 0.03125);
        this.expand = expand / 16.0;
    }

    public TerminalBoundingBox(Component name, AABB boundingBox) {
        this(name, boundingBox.f_82288_ * 16.0, boundingBox.f_82289_ * 16.0, boundingBox.f_82290_ * 16.0, boundingBox.f_82291_ * 16.0, boundingBox.f_82292_ * 16.0, boundingBox.f_82293_ * 16.0, 0.1);
    }

    public VoxelShape getShape() {
        return Shapes.m_83048_((double)(this.min.f_82479_ + this.expand), (double)(this.min.f_82480_ + this.expand), (double)(this.min.f_82481_ + this.expand), (double)(this.max.f_82479_ - this.expand), (double)(this.max.f_82480_ - this.expand), (double)(this.max.f_82481_ - this.expand));
    }

    public TerminalBoundingBox offset(Vec3 offset) {
        return this.offset(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public TerminalBoundingBox offset(double x, double y, double z) {
        TerminalBoundingBox terminal = new TerminalBoundingBox(this);
        terminal.min = terminal.min.m_82520_(x, y, z);
        terminal.max = terminal.max.m_82520_(x, y, z);
        terminal.origin = terminal.origin.m_82520_(x, y, z);
        return terminal;
    }

    public TerminalBoundingBox rotateAroundX(Rotation rotation) {
        TerminalBoundingBox terminal = new TerminalBoundingBox(this);
        switch (rotation) {
            case NONE: {
                terminal.min = this.min;
                terminal.max = this.max;
                terminal.origin = this.origin;
                break;
            }
            case CLOCKWISE_90: {
                terminal.min = new Vec3(this.min.f_82479_, this.min.f_82481_, 1.0 - this.max.f_82480_);
                terminal.max = new Vec3(this.max.f_82479_, this.max.f_82481_, 1.0 - this.min.f_82480_);
                terminal.origin = new Vec3(this.origin.f_82479_, this.origin.f_82481_, 1.0 - this.origin.f_82480_);
                break;
            }
            case CLOCKWISE_180: {
                terminal.min = new Vec3(this.min.f_82479_, 1.0 - this.max.f_82480_, 1.0 - this.max.f_82481_);
                terminal.max = new Vec3(this.max.f_82479_, 1.0 - this.min.f_82480_, 1.0 - this.min.f_82481_);
                terminal.origin = new Vec3(this.origin.f_82479_, 1.0 - this.origin.f_82480_, 1.0 - this.origin.f_82481_);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                terminal.min = new Vec3(this.min.f_82479_, 1.0 - this.max.f_82481_, this.min.f_82480_);
                terminal.max = new Vec3(this.max.f_82479_, 1.0 - this.min.f_82481_, this.max.f_82480_);
                terminal.origin = new Vec3(this.origin.f_82479_, 1.0 - this.origin.f_82481_, this.origin.f_82480_);
            }
        }
        return terminal;
    }

    public TerminalBoundingBox rotateAroundY(Rotation rotation) {
        TerminalBoundingBox terminal = new TerminalBoundingBox(this);
        switch (rotation) {
            case NONE: {
                terminal.min = this.min;
                terminal.max = this.max;
                terminal.origin = this.origin;
                break;
            }
            case CLOCKWISE_90: {
                terminal.min = new Vec3(1.0 - this.max.f_82481_, this.min.f_82480_, this.min.f_82479_);
                terminal.max = new Vec3(1.0 - this.min.f_82481_, this.max.f_82480_, this.max.f_82479_);
                terminal.origin = new Vec3(1.0 - this.origin.f_82481_, this.origin.f_82480_, this.origin.f_82479_);
                break;
            }
            case CLOCKWISE_180: {
                terminal.min = new Vec3(1.0 - this.max.f_82479_, this.min.f_82480_, 1.0 - this.max.f_82481_);
                terminal.max = new Vec3(1.0 - this.min.f_82479_, this.max.f_82480_, 1.0 - this.min.f_82481_);
                terminal.origin = new Vec3(1.0 - this.origin.f_82479_, this.origin.f_82480_, 1.0 - this.origin.f_82481_);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                terminal.min = new Vec3(this.min.f_82481_, this.min.f_82480_, 1.0 - this.max.f_82479_);
                terminal.max = new Vec3(this.max.f_82481_, this.max.f_82480_, 1.0 - this.min.f_82479_);
                terminal.origin = new Vec3(this.origin.f_82481_, this.origin.f_82480_, 1.0 - this.origin.f_82479_);
            }
        }
        return terminal;
    }

    public TerminalBoundingBox rotateAroundZ(Rotation rotation) {
        TerminalBoundingBox terminal = new TerminalBoundingBox(this);
        switch (rotation) {
            case NONE: {
                terminal.min = this.min;
                terminal.max = this.max;
                terminal.origin = this.origin;
                break;
            }
            case CLOCKWISE_90: {
                terminal.min = new Vec3(this.min.f_82480_, 1.0 - this.max.f_82479_, this.min.f_82481_);
                terminal.max = new Vec3(this.max.f_82480_, 1.0 - this.min.f_82479_, this.max.f_82481_);
                terminal.origin = new Vec3(this.origin.f_82480_, 1.0 - this.origin.f_82479_, this.origin.f_82481_);
                break;
            }
            case CLOCKWISE_180: {
                terminal.min = new Vec3(1.0 - this.max.f_82479_, 1.0 - this.max.f_82480_, this.min.f_82481_);
                terminal.max = new Vec3(1.0 - this.min.f_82479_, 1.0 - this.min.f_82480_, this.max.f_82481_);
                terminal.origin = new Vec3(1.0 - this.origin.f_82479_, 1.0 - this.origin.f_82480_, this.origin.f_82481_);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                terminal.min = new Vec3(1.0 - this.max.f_82480_, this.min.f_82479_, this.min.f_82481_);
                terminal.max = new Vec3(1.0 - this.min.f_82480_, this.max.f_82479_, this.max.f_82481_);
                terminal.origin = new Vec3(1.0 - this.origin.f_82480_, this.origin.f_82479_, this.origin.f_82481_);
            }
        }
        return terminal;
    }

    public TerminalBoundingBox rotate(Direction.Axis axis, Rotation rotation) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> this.rotateAroundX(rotation);
            case Direction.Axis.Y -> this.rotateAroundY(rotation);
            case Direction.Axis.Z -> this.rotateAroundZ(rotation);
        };
    }

    public TerminalBoundingBox rotate(Direction.Axis axis, int angle) {
        return this.rotate(axis, TerminalBoundingBox.angleToRotation(angle));
    }

    public TerminalBoundingBox rotateAroundX(int angle) {
        return this.rotateAroundX(TerminalBoundingBox.angleToRotation(angle));
    }

    public TerminalBoundingBox rotateAroundY(int angle) {
        return this.rotateAroundY(TerminalBoundingBox.angleToRotation(angle));
    }

    public TerminalBoundingBox rotateAroundZ(int angle) {
        return this.rotateAroundZ(TerminalBoundingBox.angleToRotation(angle));
    }

    private static Rotation angleToRotation(int angle) {
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        return switch (angle) {
            case 0 -> Rotation.NONE;
            case 90 -> Rotation.CLOCKWISE_90;
            case 180 -> Rotation.CLOCKWISE_180;
            case 270 -> Rotation.COUNTERCLOCKWISE_90;
            default -> throw new IllegalArgumentException("Angle must be a multiple of 90 degrees");
        };
    }

    public TerminalBoundingBox withOrigin(Vec3 origin) {
        this.origin = origin.m_82490_(0.0625);
        return this;
    }

    public TerminalBoundingBox withOrigin(double x, double y, double z) {
        return this.withOrigin(new Vec3(x, y, z));
    }

    public TerminalBoundingBox withColor(int rgb) {
        this.color = rgb;
        return this;
    }

    @Override
    public boolean check(Vec3 position) {
        return position.f_82479_ >= this.min.f_82479_ && position.f_82480_ >= this.min.f_82480_ && position.f_82481_ >= this.min.f_82481_ && position.f_82479_ < this.max.f_82479_ && position.f_82480_ < this.max.f_82480_ && position.f_82481_ < this.max.f_82481_;
    }

    @Override
    public Vec3 getOrigin() {
        return this.origin;
    }

    @Override
    public Component getName() {
        return this.name;
    }

    @Override
    public AABB getOutline() {
        return new AABB(this.min, this.max);
    }

    @Override
    public int getColor() {
        return this.color;
    }
}

