/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.contactor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.contactor.ContactorBlock;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public class ContactorBlockEntity
extends ElectricBlockEntity {
    private ElectricWire coil;
    private SwitchedWire switch1;
    private SwitchedWire switch2;
    private boolean state;
    private final Set<ContactorBlockEntity> external = new HashSet<ContactorBlockEntity>();

    public ContactorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    private void checkPos(BlockPos pos, boolean newState, List<BlockPos> checkQueue) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_141902_(pos, (BlockEntityType)ModdedBlockEntities.CONTACTOR.get()).ifPresent(be -> {
            if (newState) {
                be.addExternal(this);
            } else {
                be.removeExternal(this);
            }
            checkQueue.add(pos);
        });
    }

    private void setState(boolean newState) {
        if (newState || this.external.isEmpty()) {
            this.switch1.setState(newState);
            this.switch2.setState(newState);
        }
        if (this.state != newState) {
            if (!this.f_58857_.f_46443_) {
                if (newState) {
                    ModdedSoundEvents.CONTACTOR_ON.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
                } else {
                    ModdedSoundEvents.CONTACTOR_OFF.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
                }
            }
            ArrayList<BlockPos> checkQueue = new ArrayList<BlockPos>();
            checkQueue.add(this.f_58858_);
            HashSet<BlockPos> checkedSet = new HashSet<BlockPos>();
            Direction.Axis axis = (Direction.Axis)this.m_58900_().m_61143_((Property)ContactorBlock.HORIZONTAL_AXIS);
            if (axis == Direction.Axis.X) {
                axis = Direction.Axis.Z;
            } else if (axis == Direction.Axis.Z) {
                axis = Direction.Axis.X;
            }
            while (!checkQueue.isEmpty()) {
                BlockPos checkPos = (BlockPos)checkQueue.remove(0);
                if (!checkedSet.add(checkPos)) continue;
                BlockPos pos1 = checkPos.m_5487_(axis, 1);
                this.checkPos(pos1, newState, checkQueue);
                BlockPos pos2 = checkPos.m_5487_(axis, -1);
                this.checkPos(pos2, newState, checkQueue);
            }
        }
        this.state = newState;
    }

    private void addExternal(ContactorBlockEntity be) {
        this.external.add(be);
        if (!this.state) {
            this.switch1.setState(true);
            this.switch2.setState(true);
        }
    }

    private void removeExternal(ContactorBlockEntity be) {
        this.external.remove(be);
        if (this.external.isEmpty() && !this.state) {
            this.switch1.setState(false);
            this.switch2.setState(false);
        }
    }

    public void tick() {
        this.applyPower(this.switch1);
        this.applyPower(this.switch2);
        this.applyPower(this.coil);
        super.tick();
        float I = Math.abs(this.coil.current());
        if (I > 2.0f) {
            this.setState(true);
        } else if (I < 2.0f * ModdedConfigs.server().electricity.holdingCurrentPercent.getF()) {
            this.setState(false);
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.setState(false);
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(6);
        this.coil = builder.connect(this.resistance("coil"), builder.terminalNode(0), builder.terminalNode(1));
        this.switch1 = builder.connectSwitch(this.resistance("switch"), builder.terminalNode(2), builder.terminalNode(3), this.state);
        this.switch2 = builder.connectSwitch(this.resistance("switch"), builder.terminalNode(4), builder.terminalNode(5), this.state);
    }
}

