/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.electricswitch;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.electricswitch.SurfaceSwitchBlock;
import org.patryk3211.powergrid.electricity.electricswitch.SwitchBlock;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;
import org.patryk3211.powergrid.utility.Lang;

public class SwitchBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    private SwitchedWire wire;
    private float maxVoltage;
    private boolean switchState;
    private Float overvoltResistance;
    private boolean isButton;
    private int buttonTimeout = 0;
    private boolean playEffect = false;

    public SwitchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.isButton = ((SwitchBlock)state.m_60734_()).isButton;
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    private void overvoltEffect() {
        Vec3 pos = this.f_58858_.m_252807_();
        Direction face = (Direction)this.m_58900_().m_61143_((Property)SurfaceSwitchBlock.FACING);
        SparkParticleData.explodeParticles(this.f_58857_, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_, face.m_122424_(), 7);
        ModdedSoundEvents.COMPONENT_EXPLODE.playAt(this.f_58857_, pos, 1.0f, 1.0f, true);
    }

    public void tick() {
        this.applyPower(this.wire);
        super.tick();
        if (this.wire.isConverged() && Math.abs(this.wire.potentialDifference()) > this.maxVoltage && this.overvoltResistance == null && !this.f_58857_.f_46443_) {
            this.wire.setState(true);
            this.overvoltResistance = Float.valueOf(this.f_58857_.f_46441_.m_188501_() * 1000.0f);
            this.wire.setResistance(this.overvoltResistance.floatValue());
            this.playEffect = true;
            this.notifyUpdate();
        }
        if (this.isButton && this.buttonTimeout > 0) {
            --this.buttonTimeout;
            if (this.buttonTimeout == 0) {
                SwitchBlock block = (SwitchBlock)this.m_58900_().m_60734_();
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SwitchBlock.OPEN, (Comparable)Boolean.valueOf(true)));
                block.useSound(this.f_58857_, this.f_58858_, true);
                this.setState(false);
            }
        }
    }

    public void setState(boolean state) {
        this.switchState = state;
        if (this.overvoltResistance == null) {
            this.wire.setState(state);
        }
        if (this.isButton && state) {
            this.buttonTimeout = 10;
        }
        this.notifyUpdate();
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (clientPacket) {
            this.switchState = tag.m_128471_("State");
            this.wire.setState(this.switchState);
        }
        if (tag.m_128441_("Overvolted")) {
            this.overvoltResistance = Float.valueOf(tag.m_128457_("Overvolted"));
            this.wire.setResistance(this.overvoltResistance.floatValue());
            this.wire.setState(true);
            if (tag.m_128471_("Effect")) {
                this.overvoltEffect();
            }
        }
        if (this.isButton) {
            this.buttonTimeout = tag.m_128445_("Timeout");
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (clientPacket) {
            tag.m_128379_("State", this.switchState);
        }
        if (this.overvoltResistance != null) {
            tag.m_128350_("Overvolted", this.overvoltResistance.floatValue());
            if (this.playEffect) {
                tag.m_128379_("Effect", true);
                this.playEffect = false;
            }
        }
        if (this.isButton) {
            tag.m_128344_("Timeout", (byte)this.buttonTimeout);
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        Block block = this.m_58900_().m_60734_();
        if (!(block instanceof SwitchBlock)) {
            throw new IllegalArgumentException("Blocks with SwitchBlockEntity must inherit from SwitchBlock");
        }
        SwitchBlock block2 = (SwitchBlock)block;
        this.maxVoltage = block2.getMaxVoltage();
        this.switchState = (Boolean)this.m_58900_().m_61143_((Property)SwitchBlock.OPEN) == false;
        this.wire = builder.connectSwitch(this.resistance(), builder.terminalNode(0), builder.terminalNode(1), this.switchState);
        if (this.overvoltResistance != null) {
            this.wire.setResistance(this.overvoltResistance.floatValue());
            this.wire.setState(true);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.overvoltResistance == null) {
            return false;
        }
        Lang.translate("gui.damage_header", new Object[0]).forGoggles(tooltip);
        Lang.translate("gui.switch.overvolted", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        return true;
    }
}

