/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.heater;

import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.heater.HeaterBlockEntity;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Power;
import org.patryk3211.powergrid.electricity.info.Resistance;
import org.patryk3211.powergrid.electricity.wire.powercord.IAcceptCord;

public class HeaterBlock
extends ElectricBlock
implements IBE<HeaterBlockEntity>,
IHaveElectricProperties,
IAcceptCord {
    private static final TerminalBoundingBox NORTH_TERMINAL1 = new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 12.0, 12.0, 7.0, 15.0, 15.0, 10.0);
    private static final TerminalBoundingBox NORTH_TERMINAL2 = new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 1.0, 12.0, 7.0, 4.0, 15.0, 10.0);
    private static final TerminalBoundingBox SOUTH_TERMINAL1 = NORTH_TERMINAL1.rotateAroundY(Rotation.CLOCKWISE_180);
    private static final TerminalBoundingBox SOUTH_TERMINAL2 = NORTH_TERMINAL2.rotateAroundY(Rotation.CLOCKWISE_180);
    private static final TerminalBoundingBox EAST_TERMINAL1 = NORTH_TERMINAL1.rotateAroundY(Rotation.CLOCKWISE_90);
    private static final TerminalBoundingBox EAST_TERMINAL2 = NORTH_TERMINAL2.rotateAroundY(Rotation.CLOCKWISE_90);
    private static final TerminalBoundingBox WEST_TERMINAL1 = NORTH_TERMINAL1.rotateAroundY(Rotation.COUNTERCLOCKWISE_90);
    private static final TerminalBoundingBox WEST_TERMINAL2 = NORTH_TERMINAL2.rotateAroundY(Rotation.COUNTERCLOCKWISE_90);
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83124_((VoxelShape)HeaterBlock.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0), (VoxelShape[])new VoxelShape[]{NORTH_TERMINAL1.getShape(), NORTH_TERMINAL2.getShape()});
    private static final VoxelShape SHAPE_SOUTH = Shapes.m_83124_((VoxelShape)HeaterBlock.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0), (VoxelShape[])new VoxelShape[]{SOUTH_TERMINAL1.getShape(), SOUTH_TERMINAL2.getShape()});
    private static final VoxelShape SHAPE_EAST = Shapes.m_83124_((VoxelShape)HeaterBlock.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{EAST_TERMINAL1.getShape(), EAST_TERMINAL2.getShape()});
    private static final VoxelShape SHAPE_WEST = Shapes.m_83124_((VoxelShape)HeaterBlock.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{WEST_TERMINAL1.getShape(), WEST_TERMINAL2.getShape()});

    public HeaterBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)ctx.m_8125_().m_122424_());
    }

    @Override
    public int terminalCount() {
        return 2;
    }

    @Override
    public ITerminalPlacement terminal(BlockState state, int index) {
        return switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
            case Direction.NORTH -> {
                switch (index) {
                    case 0: {
                        yield NORTH_TERMINAL1;
                    }
                    case 1: {
                        yield NORTH_TERMINAL2;
                    }
                }
                yield null;
            }
            case Direction.SOUTH -> {
                switch (index) {
                    case 0: {
                        yield SOUTH_TERMINAL1;
                    }
                    case 1: {
                        yield SOUTH_TERMINAL2;
                    }
                }
                yield null;
            }
            case Direction.EAST -> {
                switch (index) {
                    case 0: {
                        yield EAST_TERMINAL1;
                    }
                    case 1: {
                        yield EAST_TERMINAL2;
                    }
                }
                yield null;
            }
            case Direction.WEST -> {
                switch (index) {
                    case 0: {
                        yield WEST_TERMINAL1;
                    }
                    case 1: {
                        yield WEST_TERMINAL2;
                    }
                }
                yield null;
            }
            default -> null;
        };
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> throw new IllegalArgumentException("Invalid horizontal facing");
        };
    }

    public Class<HeaterBlockEntity> getBlockEntityClass() {
        return HeaterBlockEntity.class;
    }

    public BlockEntityType<? extends HeaterBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.HEATING_COIL.get();
    }

    @Override
    public void appendProperties(ItemStack stack, Player player, List<Component> tooltip) {
        Resistance.series(this.resistance(), player, tooltip);
        Power.max(stack, player, tooltip);
    }

    @Override
    public boolean renderPlug() {
        return true;
    }
}

