/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.light.bulb;

import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.electricity.light.bulb.ILightBulb;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlock;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlockEntity;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public abstract class LightBulbState {
    protected final Item item;
    protected final ILightBulb bulb;
    protected final LightFixtureBlockEntity fixture;
    protected final float thermalMass;
    protected final float dissipationFactor;
    protected final float overheatTemperature;
    protected float temperature;
    protected boolean burned;
    private int overheatTicks;
    private boolean playEffect;

    public <T extends Item> LightBulbState(T bulb, LightFixtureBlockEntity fixture) {
        this.item = bulb;
        this.bulb = (ILightBulb)bulb;
        this.fixture = fixture;
        ILightBulb.Properties properties = ((ILightBulb)bulb).thermalProperties();
        this.thermalMass = properties.thermalMass();
        this.dissipationFactor = properties.dissipationFactor();
        this.overheatTemperature = properties.overheatTemperature();
        this.burned = false;
    }

    protected void applyPower(float power) {
        if (this.burned) {
            return;
        }
        float energy = power / 20.0f;
        this.temperature += energy / this.thermalMass;
        if (energy < 0.0f && this.temperature < 22.0f) {
            this.temperature = 22.0f;
        }
    }

    protected void updatePowerLevel(int newLevel) {
        Level world = this.fixture.m_58904_();
        BlockState state = this.fixture.m_58900_();
        if (newLevel != (Integer)state.m_61143_((Property)LightFixtureBlock.POWER)) {
            world.m_46597_(this.fixture.m_58899_(), (BlockState)state.m_61124_((Property)LightFixtureBlock.POWER, (Comparable)Integer.valueOf(newLevel)));
        }
    }

    public int getPowerLevel() {
        return (Integer)this.fixture.m_58900_().m_61143_((Property)LightFixtureBlock.POWER);
    }

    private void burnEffect() {
        Level world = this.fixture.m_58904_();
        if (world.f_46443_) {
            Vec3 pos = this.fixture.m_58899_().m_252807_();
            world.m_7106_((ParticleOptions)ParticleTypes.f_123747_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public void tick() {
        if (this.burned) {
            return;
        }
        SwitchedWire filament = this.fixture.getFilament();
        float dissipatedPower = this.dissipationFactor * (this.temperature - 22.0f);
        if (filament.isConverged()) {
            this.applyPower(filament.power() - dissipatedPower);
        }
        if (!Float.isFinite(this.temperature)) {
            this.temperature = 22.0f;
        }
        filament.setResistance(this.bulb.resistanceFunction(this.temperature));
        Level world = this.fixture.m_58904_();
        if (!world.f_46443_) {
            if (this.isOverheated() && this.overheatTicks++ >= 4) {
                this.burned = true;
                this.playEffect = true;
                filament.setState(false);
                this.updatePowerLevel(0);
                this.fixture.notifyUpdate();
                return;
            }
            if (!this.isOverheated()) {
                this.overheatTicks = 0;
            }
            int powerLevel = 0;
            if (this.temperature > 1400.0f) {
                powerLevel = 2;
            } else if (this.temperature > 1200.0f) {
                powerLevel = 1;
            }
            this.updatePowerLevel(powerLevel);
        }
    }

    public boolean isOverheated() {
        return this.temperature >= this.overheatTemperature;
    }

    public boolean isBurned() {
        return this.burned;
    }

    public float resistance() {
        return this.bulb.resistanceFunction(this.temperature);
    }

    public ItemStack toStack() {
        return new ItemStack((ItemLike)this.item);
    }

    public boolean isOf(Item item) {
        return this.item == item;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract PartialModel getModel();

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public abstract PartialModel getLightModel();

    public float getAlpha() {
        float x = Mth.m_14036_((float)((this.temperature - 600.0f) / 800.0f), (float)0.0f, (float)1.0f);
        return x * x;
    }

    public void write(CompoundTag nbt) {
        nbt.m_128359_("Bulb", BuiltInRegistries.f_257033_.m_7981_((Object)this.item).toString());
        nbt.m_128350_("Temperature", this.temperature);
        if (this.burned) {
            nbt.m_128379_("Burned", true);
        }
        if (this.playEffect) {
            nbt.m_128379_("Effect", true);
            this.playEffect = false;
        }
    }

    public void read(CompoundTag nbt) {
        Item bulbItem = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(nbt.m_128461_("Bulb")));
        if (bulbItem != this.item) {
            PowerGrid.LOGGER.error("Bulb item validation failed");
            return;
        }
        this.temperature = nbt.m_128457_("Temperature");
        this.burned = nbt.m_128471_("Burned");
        this.fixture.getFilament().setState(!this.burned);
        if (nbt.m_128471_("Effect")) {
            this.burnEffect();
        }
    }

    public static Item getBulbItem(CompoundTag nbt) {
        if (!nbt.m_128441_("Bulb")) {
            return null;
        }
        Item bulbItem = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(nbt.m_128461_("Bulb")));
        if (!(bulbItem instanceof ILightBulb)) {
            PowerGrid.LOGGER.error("Tried to use a non light bulb item for light bulb state");
            return null;
        }
        return bulbItem;
    }

    public Item getItem() {
        return this.item;
    }
}

