/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.particle.ICustomParticleData;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.DustParticleOptionsBase;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import org.joml.Vector3f;
import org.patryk3211.powergrid.collections.ModdedParticles;
import org.patryk3211.powergrid.electricity.particles.ZapParticle;

public class ZapParticleData
implements ParticleOptions,
ICustomParticleData<ZapParticleData> {
    public static final ParticleOptions.Deserializer<ZapParticleData> FACTORY = new ParticleOptions.Deserializer<ZapParticleData>(){

        public ZapParticleData fromCommand(ParticleType<ZapParticleData> type, StringReader reader) throws CommandSyntaxException {
            return new ZapParticleData(DustParticleOptionsBase.m_252853_((StringReader)reader), true, 1, -1);
        }

        public ZapParticleData fromNetwork(ParticleType<ZapParticleData> type, FriendlyByteBuf buf) {
            return new ZapParticleData(buf.m_269394_(), buf.readBoolean(), buf.readInt(), buf.readInt());
        }
    };
    private static final Codec<ZapParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_252432_.fieldOf("end").forGetter(ZapParticleData::getEnd), (App)Codec.BOOL.fieldOf("anchor").forGetter(ZapParticleData::isAnchored), (App)Codec.INT.fieldOf("life").forGetter(ZapParticleData::getLife), (App)Codec.INT.fieldOf("segments").forGetter(ZapParticleData::getSegmentCount)).apply((Applicative)instance, ZapParticleData::new));
    private final Vector3f end;
    private final boolean anchor;
    private int life;
    private int segmentCount;

    public ZapParticleData() {
        this(null, false, 1);
    }

    public ZapParticleData(Vector3f end, boolean anchor, int life) {
        this(end, anchor, life, -1);
    }

    public ZapParticleData(Vector3f end, boolean anchor, int life, int segmentCount) {
        this.end = end;
        this.anchor = anchor;
        this.life = life;
        this.segmentCount = segmentCount;
    }

    public ZapParticleData(float x, float y, float z, boolean anchor) {
        this(new Vector3f(x, y, z), anchor, 1);
    }

    public ZapParticleData(double x, double y, double z, boolean anchor) {
        this(new Vector3f((float)x, (float)y, (float)z), anchor, 1);
    }

    public ZapParticleData withLife(int life) {
        this.life = life;
        return this;
    }

    public ZapParticleData withSegments(int count) {
        this.segmentCount = count;
        return this;
    }

    public Vector3f getEnd() {
        return this.end;
    }

    public boolean isAnchored() {
        return this.anchor;
    }

    public int getLife() {
        return this.life;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    public ParticleOptions.Deserializer<ZapParticleData> getDeserializer() {
        return FACTORY;
    }

    public Codec<ZapParticleData> getCodec(ParticleType<ZapParticleData> type) {
        return CODEC;
    }

    public ParticleProvider<ZapParticleData> getFactory() {
        return ZapParticle::new;
    }

    public ParticleType<?> m_6012_() {
        return ModdedParticles.ZAP;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.m_269582_(this.end);
        buf.writeBoolean(this.anchor);
        buf.writeInt(this.life);
        buf.writeInt(this.segmentCount);
    }

    public String m_5942_() {
        if (this.end == null) {
            return BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()).toString();
        }
        return String.format("%s (%f, %f, %f)", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.end.x), Float.valueOf(this.end.y), Float.valueOf(this.end.z));
    }
}

