/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.ICouplingNode;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLine;

public class NetworkGraph {
    private final Map<IElectricNode, Node> nodes = new HashMap<IElectricNode, Node>();
    public IGraphModifyHooks hooks = null;

    public NetworkGraph() {
        this.addNode(null);
    }

    public void addNode(IElectricNode node) {
        if (this.nodes.containsKey(node)) {
            return;
        }
        this.nodes.put(node, new Node(node));
        if (this.hooks != null) {
            this.hooks.addNode(node);
        }
    }

    public void removeNode(IElectricNode node) {
        Node object = this.nodes.get(node);
        if (object == null) {
            return;
        }
        if (object.isKept) {
            object.isKept = false;
            return;
        }
        this.nodes.remove(node);
        for (Node other : object.connections.keySet()) {
            other.connections.remove(object);
        }
        if (!object.couplings.isEmpty()) {
            ElectricalNetwork.LOGGER.warn("Electric node removed before it was fully decoupled, this can cause issues");
            for (ICouplingNode coupling : object.couplings) {
                ElectricalNetwork network = coupling.getNetwork();
                if (network == null) continue;
                network.removeNode(coupling);
            }
        }
        if (this.hooks != null) {
            this.hooks.removeNode(node);
        }
    }

    public void connect(IElectricNode node1, IElectricNode node2, @NotNull AbstractElectricWire wire) {
        List conns2;
        if (node1 != null && !this.nodes.containsKey(node1) || node2 != null && !this.nodes.containsKey(node2)) {
            return;
        }
        Node object1 = this.nodes.get(node1);
        Node object2 = this.nodes.get(node2);
        List conns1 = object1.connections.computeIfAbsent(object2, key -> new ArrayList());
        if (!conns1.contains(wire)) {
            conns1.add(wire);
        }
        if (!(conns2 = object2.connections.computeIfAbsent(object1, key -> new ArrayList())).contains(wire)) {
            conns2.add(wire);
        }
        if (this.hooks != null) {
            this.hooks.addWire(wire);
        }
        if (wire instanceof TransmissionLine) {
            TransmissionLine line = (TransmissionLine)wire;
            object1.connectedLines.add(line);
            object2.connectedLines.add(line);
            if (this.hooks != null) {
                this.hooks.lineConnected(line);
            }
        }
    }

    public void disconnect(IElectricNode node1, IElectricNode node2, @NotNull AbstractElectricWire wire) {
        List<AbstractElectricWire> conns2;
        if (node1 != null && !this.nodes.containsKey(node1) || node2 != null && !this.nodes.containsKey(node2)) {
            return;
        }
        Node object1 = this.nodes.get(node1);
        Node object2 = this.nodes.get(node2);
        List<AbstractElectricWire> conns1 = object1.connections.get(object2);
        if (conns1 != null) {
            conns1.remove(wire);
            if (conns1.isEmpty()) {
                object1.connections.remove(object2);
            }
        }
        if ((conns2 = object2.connections.get(object1)) != null) {
            conns2.remove(wire);
            if (conns2.isEmpty()) {
                object2.connections.remove(object1);
            }
        }
        if (this.hooks != null) {
            this.hooks.removeWire(wire);
        }
        if (wire instanceof TransmissionLine) {
            TransmissionLine line = (TransmissionLine)wire;
            object1.connectedLines.remove(line);
            object2.connectedLines.remove(line);
            if (this.hooks != null) {
                this.hooks.lineDisconnected(line);
            }
        }
    }

    public void couple(ICouplingNode coupling) {
        for (IElectricNode node : coupling.coupledNodes()) {
            Node object = this.nodes.get(node);
            if (object == null) continue;
            object.couplings.add(coupling);
        }
    }

    public void decouple(ICouplingNode coupling) {
        for (IElectricNode node : coupling.coupledNodes()) {
            Node object = this.nodes.get(node);
            if (object == null) continue;
            object.couplings.remove(coupling);
        }
    }

    @Nullable
    public AbstractElectricWire getFirstWire(IElectricNode node1, IElectricNode node2) {
        if (!this.nodes.containsKey(node1) || !this.nodes.containsKey(node2)) {
            return null;
        }
        Node object1 = this.nodes.get(node1);
        Node object2 = this.nodes.get(node2);
        List<AbstractElectricWire> conn = object1.connections.get(object2);
        return conn == null ? null : (conn.isEmpty() ? null : conn.get(0));
    }

    public Collection<AbstractElectricWire> getWires(IElectricNode node1, IElectricNode node2) {
        if (!this.nodes.containsKey(node1) || !this.nodes.containsKey(node2)) {
            return List.of();
        }
        Node object1 = this.nodes.get(node1);
        Node object2 = this.nodes.get(node2);
        List<AbstractElectricWire> conn = object1.connections.get(object2);
        return conn == null ? List.of() : conn;
    }

    @NotNull
    public List<IElectricNode> getConnectedNodes(IElectricNode node) {
        if (!this.nodes.containsKey(node)) {
            return List.of();
        }
        ArrayList<IElectricNode> eNodes = new ArrayList<IElectricNode>();
        Node object = this.nodes.get(node);
        for (Node otherNode : object.connections.keySet()) {
            if (eNodes.contains(otherNode.node)) continue;
            eNodes.add(otherNode.node);
        }
        for (ICouplingNode coupling : object.couplings) {
            for (IElectricNode otherNode : coupling.coupledNodes()) {
                if (otherNode == node || eNodes.contains(otherNode)) continue;
                eNodes.add(otherNode);
            }
        }
        return eNodes;
    }

    public int connectionCount(IElectricNode node) {
        if (!this.nodes.containsKey(node)) {
            return 0;
        }
        Node object = this.nodes.get(node);
        int size = object.couplings.size();
        for (List<AbstractElectricWire> list : object.connections.values()) {
            size += list.size();
        }
        return size;
    }

    public boolean hasComplexConnections(IElectricNode node) {
        if (!this.nodes.containsKey(node)) {
            return false;
        }
        Node object = this.nodes.get(node);
        if (!object.couplings.isEmpty()) {
            return true;
        }
        for (List<AbstractElectricWire> wires : object.connections.values()) {
            for (AbstractElectricWire wire : wires) {
                if (wire instanceof ElectricWire) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasCouplings(IElectricNode node) {
        if (!this.nodes.containsKey(node)) {
            return false;
        }
        Node object = this.nodes.get(node);
        return !object.couplings.isEmpty();
    }

    public boolean isLeafEliminating(IElectricNode node) {
        if (!this.nodes.containsKey(node)) {
            return false;
        }
        Node object = this.nodes.get(node);
        if (!object.couplings.isEmpty()) {
            return true;
        }
        for (List<AbstractElectricWire> wires : object.connections.values()) {
            for (AbstractElectricWire wire : wires) {
                if (wire.node1 != null && wire.node2 != null) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public Collection<TransmissionLine> getConnectedLines(IElectricNode node) {
        if (!this.nodes.containsKey(node)) {
            return List.of();
        }
        return this.nodes.get((Object)node).connectedLines;
    }

    @NotNull
    public Collection<IElectricNode> getTransmissionLineConnectedNodes(IElectricNode node) {
        if (!this.nodes.containsKey(node)) {
            return List.of();
        }
        Node object = this.nodes.get(node);
        HashSet<IElectricNode> connected = new HashSet<IElectricNode>();
        for (TransmissionLine line : object.connectedLines) {
            if (line.getNode1() == node) {
                connected.add(line.getNode2());
                continue;
            }
            if (line.getNode2() == node) {
                connected.add(line.getNode1());
                continue;
            }
            PowerGrid.LOGGER.warn("Neither end of line {} is connected to node {}", (Object)line, (Object)node);
        }
        return connected;
    }

    public int transmissionLineCount(IElectricNode node) {
        if (!this.nodes.containsKey(node)) {
            return 0;
        }
        Node object = this.nodes.get(node);
        return object.connectedLines.size();
    }

    public static interface IGraphModifyHooks {
        default public void addNode(IElectricNode node) {
        }

        default public void removeNode(IElectricNode node) {
        }

        default public void addWire(AbstractElectricWire wire) {
        }

        default public void removeWire(AbstractElectricWire wire) {
        }

        default public void lineConnected(TransmissionLine line) {
        }

        default public void lineDisconnected(TransmissionLine line) {
        }
    }

    private static class Node {
        public final IElectricNode node;
        public final Map<Node, List<AbstractElectricWire>> connections;
        public final Set<TransmissionLine> connectedLines;
        public final Set<ICouplingNode> couplings;
        public boolean isKept;

        public Node(IElectricNode node) {
            this.node = node;
            this.connections = new HashMap<Node, List<AbstractElectricWire>>();
            this.connectedLines = new HashSet<TransmissionLine>();
            this.couplings = new HashSet<ICouplingNode>();
            this.isKept = false;
        }
    }
}

