/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim;

import java.util.HashMap;
import java.util.Map;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.FloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.ICouplingNode;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.INode;

public class OptimizingElectricalNetwork
extends ElectricalNetwork {
    private int optimizerCounter;
    private final Map<INode, Integer> optimizerScores = new HashMap<INode, Integer>();
    private boolean lockScores = false;

    public OptimizingElectricalNetwork(boolean addGMin) {
        super(addGMin);
    }

    @Override
    public void calculate() {
        if (this.optimizerCounter++ >= 5) {
            this.optimizerCounter = 0;
            this.optimizerRoutine();
        }
        super.calculate();
    }

    @Override
    public void addNode(INode node) {
        super.addNode(node);
        if (node instanceof FloatingNode) {
            this.optimizerScores.put(node, 10);
        } else if (node instanceof ICouplingNode) {
            ICouplingNode coupling = (ICouplingNode)node;
            for (IElectricNode coupled : coupling.coupledNodes()) {
                this.unoptimizeNode(coupled);
                this.optimizerScores.remove(coupled);
            }
        }
    }

    @Override
    public void addWire(AbstractElectricWire wire) {
        super.addWire(wire);
        if (wire.getNode1() != null) {
            this.unoptimizeNode(wire.getNode1());
        }
        if (wire.getNode2() != null) {
            this.unoptimizeNode(wire.getNode2());
        }
    }

    @Override
    public void removeNode(INode node) {
        super.removeNode(node);
        this.optimizerScores.remove(node);
    }

    @Override
    public void makeLeaf(IElectricNode node, IElectricNode tracked) {
        super.makeLeaf(node, tracked);
        this.optimizerScores.remove(node);
    }

    @Override
    protected void jacobianAdd(int row, int column, double value) {
        super.jacobianAdd(row, column, value);
        if (this.lockScores) {
            return;
        }
        this.optimizerScores.computeIfPresent((INode)this.nodes.get(row), ($, score) -> Math.min(score + 1, 40));
        this.optimizerScores.computeIfPresent((INode)this.nodes.get(column), ($, score) -> Math.min(score + 1, 40));
    }

    @Override
    protected void residualAdd(int row, double value) {
        super.residualAdd(row, value);
        INode node = (INode)this.nodes.get(row);
        this.optimizerScores.remove(node);
        this.unoptimizeNode(node);
    }

    @Override
    protected void populateConductanceMatrix(boolean withEliminated) {
        this.lockScores = true;
        super.populateConductanceMatrix(withEliminated);
        this.lockScores = false;
    }

    protected boolean canOptimize(INode node) {
        return true;
    }

    private void optimizerRoutine() {
        for (Map.Entry<INode, Integer> entry : this.optimizerScores.entrySet()) {
            INode node = entry.getKey();
            if (!this.canOptimize(node)) {
                entry.setValue(20);
                this.unoptimizeNode(node);
                return;
            }
            Integer score = entry.getValue();
            if (score >= 10) {
                this.unoptimizeNode(node);
            } else if (score <= 0) {
                this.optimizeNode(node);
            }
            if (score <= 0) continue;
            entry.setValue(Math.max(score - 2, 0));
        }
    }

    @Override
    public void merge(ElectricalNetwork other) {
        other.nodes.forEach(node -> {
            if (node instanceof IElectricNode) {
                this.addNode((INode)node);
            }
        });
        other.leafNodes.forEach((node, tracked) -> {
            node.setNetwork(this);
            this.leafNodes.put(node, tracked);
        });
        other.nodes.forEach(node -> {
            if (node instanceof ICouplingNode) {
                this.addNode((INode)node);
            }
        });
        other.wires.forEach(this::addWire);
        other.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.optimizerScores.clear();
    }
}

