/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.solver;

import java.util.function.Function;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.interfaces.linsol.LinearSolverDense;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.ops.DConvertMatrixStruct;
import org.ejml.sparse.FillReducing;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.factory.LinearSolverFactory_DSCC;
import org.jetbrains.annotations.Nullable;

public class DynamicallyTypedMatrix {
    private static final int SPARSE_THRESHOLD = 6;
    private static final double G_THRESHOLD = 1.0000000000000001E-11;
    private LinearSolver<? extends DMatrix, DMatrixRMaj> solver;
    private DMatrix matrix;
    private boolean sparse;
    private boolean solverValid;
    private Solver solverType;

    public DynamicallyTypedMatrix(int rows, int cols) {
        this(rows, cols, Solver.CHOLESKY);
    }

    public DynamicallyTypedMatrix(int rows, int cols, Solver solverType) {
        this.matrix = new DMatrixRMaj(rows, cols);
        this.sparse = false;
        this.solver = null;
        this.solverType = solverType;
    }

    public void denseZero() {
        if (this.sparse) {
            this.matrix = new DMatrixRMaj(this.matrix.getNumRows(), this.matrix.getNumCols());
            this.sparse = false;
            this.solver = null;
        } else {
            this.matrix.zero();
        }
    }

    public void mult(DMatrixRMaj in, DMatrixRMaj out) {
        if (this.sparse) {
            CommonOps_DSCC.mult((DMatrixSparseCSC)((DMatrixSparseCSC)this.matrix), (DMatrixRMaj)in, (DMatrixRMaj)out);
        } else {
            CommonOps_DDRM.mult((DMatrix1Row)((DMatrixRMaj)this.matrix), (DMatrix1Row)in, (DMatrix1Row)out);
        }
    }

    public void mult(DynamicallyTypedMatrix in, DynamicallyTypedMatrix out) {
        if (this.sparse && in.sparse != out.sparse || !this.sparse && (in.sparse || out.sparse)) {
            throw new IllegalStateException("Sparsity of matrices doesn't match");
        }
        if (this.sparse) {
            if (in.sparse) {
                CommonOps_DSCC.mult((DMatrixSparseCSC)((DMatrixSparseCSC)this.matrix), (DMatrixSparseCSC)((DMatrixSparseCSC)in.matrix), (DMatrixSparseCSC)((DMatrixSparseCSC)out.matrix));
            } else {
                CommonOps_DSCC.mult((DMatrixSparseCSC)((DMatrixSparseCSC)this.matrix), (DMatrixRMaj)((DMatrixRMaj)in.matrix), (DMatrixRMaj)((DMatrixRMaj)out.matrix));
            }
        } else {
            CommonOps_DDRM.mult((DMatrix1Row)((DMatrixRMaj)this.matrix), (DMatrix1Row)((DMatrixRMaj)in.matrix), (DMatrix1Row)((DMatrixRMaj)out.matrix));
        }
    }

    public void set(int row, int col, double value) {
        this.matrix.set(row, col, value);
    }

    public double get(int row, int col) {
        return this.matrix.get(row, col);
    }

    public void add(int row, int col, double value) {
        if (!this.sparse) {
            ((DMatrixRMaj)this.matrix).add(row, col, value);
        } else {
            double current = this.matrix.get(row, col);
            this.matrix.set(row, col, current + value);
        }
    }

    public void setTo(DMatrixRMaj matrix) {
        if (matrix.getNumRows() > 6) {
            if (this.sparse) {
                DConvertMatrixStruct.convert((DMatrixRMaj)matrix, (DMatrixSparseCSC)((DMatrixSparseCSC)this.matrix), (double)1.0000000000000001E-11);
            } else {
                this.matrix = DConvertMatrixStruct.convert((DMatrixRMaj)matrix, (DMatrixSparseCSC)null, (double)1.0000000000000001E-11);
                this.solver = null;
            }
            this.sparse = true;
        } else {
            if (!this.sparse) {
                this.matrix.setTo((Matrix)matrix);
            } else {
                this.matrix = new DMatrixRMaj(matrix);
                this.solver = null;
            }
            this.sparse = false;
        }
    }

    public int getNumRows() {
        return this.matrix.getNumRows();
    }

    public void optimize() {
        if (this.matrix.getNumRows() > 6 || this.matrix.getNumCols() > 6) {
            this.convert(State.SPARSE);
        } else {
            this.convert(State.DENSE);
        }
    }

    public void convert(State to) {
        if (!this.sparse && to == State.SPARSE) {
            this.matrix = DConvertMatrixStruct.convert((DMatrixRMaj)((DMatrixRMaj)this.matrix), (DMatrixSparseCSC)null, (double)1.0000000000000001E-11);
            this.solver = null;
            this.sparse = true;
        } else if (this.sparse && to == State.DENSE) {
            this.matrix = new DMatrixRMaj(this.matrix);
            this.solver = null;
            this.sparse = false;
        }
    }

    private void makeSolver() {
        if (this.sparse) {
            LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> solver = this.solverType.sparseFactory.apply(FillReducing.NONE);
            DMatrixSparseCSC a = (DMatrixSparseCSC)this.matrix;
            if (solver.modifiesA()) {
                a = new DMatrixSparseCSC(a);
            }
            this.solverValid = solver.setA((Matrix)a);
            this.solver = solver;
        } else {
            LinearSolverDense<DMatrixRMaj> solver = this.solverType.denseFactory.apply(this.getNumRows());
            DMatrixRMaj a = (DMatrixRMaj)this.matrix;
            if (solver.modifiesA()) {
                a = new DMatrixRMaj(a);
            }
            this.solverValid = solver.setA((Matrix)a);
            this.solver = solver;
        }
    }

    public void refactorize() {
        if (this.solver != null) {
            if (this.sparse) {
                DMatrixSparseCSC a = (DMatrixSparseCSC)this.matrix;
                if (this.solver.modifiesA()) {
                    a = new DMatrixSparseCSC(a);
                }
                this.solverValid = ((LinearSolverSparse)this.solver).setA((Matrix)a);
            } else {
                DMatrixRMaj a = (DMatrixRMaj)this.matrix;
                if (this.solver.modifiesA()) {
                    a = new DMatrixRMaj(a);
                }
                this.solverValid = ((LinearSolverDense)this.solver).setA((Matrix)a);
            }
        } else {
            this.makeSolver();
        }
        if (!this.solverValid && this.solverType == Solver.CHOLESKY) {
            this.solverType = Solver.LU;
            this.makeSolver();
        }
    }

    public void solve(DMatrixRMaj b, DMatrixRMaj x) {
        if (this.solver == null) {
            this.refactorize();
        }
        if (!this.solverValid) {
            x.zero();
            return;
        }
        this.solver.solve((Matrix)b, (Matrix)x);
    }

    public void solve(DynamicallyTypedMatrix b, DynamicallyTypedMatrix x) {
        if (this.sparse && b.sparse != x.sparse || !this.sparse && (b.sparse || x.sparse)) {
            throw new IllegalStateException("Sparsity of matrices doesn't match");
        }
        if (this.solver == null) {
            this.refactorize();
        }
        if (!this.solverValid) {
            x.matrix.zero();
            return;
        }
        if (this.sparse && b.sparse) {
            LinearSolverSparse solver = (LinearSolverSparse)this.solver;
            solver.solveSparse((Matrix)((DMatrixSparseCSC)b.matrix), (Matrix)((DMatrixSparseCSC)x.matrix));
        } else {
            this.solver.solve((Matrix)((DMatrixRMaj)b.matrix), (Matrix)((DMatrixRMaj)x.matrix));
        }
    }

    public void reshapeTo(DynamicallyTypedMatrix target) {
        int n = target.getNumRows();
        if (target.sparse == this.sparse && n == this.getNumRows()) {
            return;
        }
        this.matrix = target.sparse ? new DMatrixSparseCSC(n, n) : new DMatrixRMaj(n, n);
        this.sparse = target.sparse;
        this.solver = null;
    }

    public void setTo(DynamicallyTypedMatrix target) {
        this.reshapeTo(target);
        this.matrix.setTo((Matrix)target.matrix);
    }

    public void multColumns(double[] values, @Nullable DynamicallyTypedMatrix output) {
        if (output != null) {
            output.setTo(this);
        } else {
            output = this;
        }
        if (this.sparse) {
            CommonOps_DSCC.multColumns((DMatrixSparseCSC)((DMatrixSparseCSC)output.matrix), (double[])values, (int)0);
        } else {
            CommonOps_DDRM.multCols((DMatrixRMaj)((DMatrixRMaj)output.matrix), (double[])values);
        }
    }

    public void multRows(double[] values, @Nullable DynamicallyTypedMatrix output) {
        if (output != null) {
            output.setTo(this);
        } else {
            output = this;
        }
        if (this.sparse) {
            CommonOps_DSCC.multRows((double[])values, (int)0, (DMatrixSparseCSC)((DMatrixSparseCSC)output.matrix));
        } else {
            CommonOps_DDRM.multRows((double[])values, (DMatrixRMaj)((DMatrixRMaj)output.matrix));
        }
    }

    public void subtract(DynamicallyTypedMatrix in, DynamicallyTypedMatrix out) {
        if (out.sparse != this.sparse) {
            out.reshapeTo(this);
        }
        if (in.sparse != this.sparse || out.sparse != this.sparse) {
            throw new IllegalStateException("Sparsity of matrices doesn't match");
        }
        if (this.sparse) {
            CommonOps_DSCC.add((double)1.0, (DMatrixSparseCSC)((DMatrixSparseCSC)this.matrix), (double)-1.0, (DMatrixSparseCSC)((DMatrixSparseCSC)in.matrix), (DMatrixSparseCSC)((DMatrixSparseCSC)out.matrix), null, null);
        } else {
            CommonOps_DDRM.subtract((DMatrixD1)((DMatrixRMaj)this.matrix), (DMatrixD1)((DMatrixRMaj)in.matrix), (DMatrixD1)((DMatrixRMaj)out.matrix));
        }
    }

    public DMatrixRMaj getDense() {
        if (this.sparse) {
            throw new IllegalStateException("Matrix is currently sparse");
        }
        return (DMatrixRMaj)this.matrix;
    }

    public State getState() {
        return this.sparse ? State.SPARSE : State.DENSE;
    }

    public static enum Solver {
        LU(LinearSolverFactory_DSCC::lu, LinearSolverFactory_DDRM::lu),
        CHOLESKY(LinearSolverFactory_DSCC::cholesky, LinearSolverFactory_DDRM::chol);

        public final Function<FillReducing, LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj>> sparseFactory;
        public final Function<Integer, LinearSolverDense<DMatrixRMaj>> denseFactory;

        private Solver(Function<FillReducing, LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj>> sparseFactory, Function<Integer, LinearSolverDense<DMatrixRMaj>> denseFactory) {
            this.sparseFactory = sparseFactory;
            this.denseFactory = denseFactory;
        }
    }

    public static enum State {
        DENSE,
        SPARSE;

    }
}

