/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.sim.special;

import java.util.List;
import net.minecraft.util.Mth;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.solver.IAdmittanceAdder;
import org.patryk3211.powergrid.electricity.sim.solver.IResidualAdder;
import org.patryk3211.powergrid.electricity.sim.solver.ISolverHook;
import org.patryk3211.powergrid.electricity.sim.special.CompoundWire;

public class ElectronTubeWire
extends CompoundWire
implements ISolverHook {
    private static final double GRID_CONDUCTANCE = 1.6666666666666666E-4;
    private final IElectricNode grid;
    private final float gain;
    private final float perveance;
    private float saturationCurrent;
    private double prevGrid;
    private double prevCathode;
    private double Ia;
    private float Itube;
    private float Ptube;
    private final CompoundWire.ConductanceWire gridCathode;
    private final GMStamp gmStamp;
    private final float alpha;

    public ElectronTubeWire(float gain, float perveance, float saturationCurrent, IElectricNode cathode, IElectricNode anode, IElectricNode grid) {
        super(cathode, anode);
        this.grid = grid;
        this.gridCathode = this.addDynamicWire(grid, cathode);
        this.gmStamp = this.addInternalWire(new GMStamp(cathode, anode, grid));
        this.gain = gain;
        this.perveance = perveance;
        this.saturationCurrent = saturationCurrent;
        this.alpha = Mth.m_14036_((float)(10.0f / gain), (float)0.4f, (float)0.9f);
    }

    public void setSaturationCurrent(float saturationCurrent) {
        this.saturationCurrent = saturationCurrent;
    }

    @Override
    public void startIteration() {
        double ids;
        double Gds;
        double vCathode = this.node1.getVoltage();
        double vGrid = this.grid.getVoltage();
        double vAnode = this.node2.getVoltage();
        vCathode = vCathode * (double)this.alpha + this.prevCathode * (double)(1.0f - this.alpha);
        vGrid = vGrid * (double)this.alpha + this.prevGrid * (double)(1.0f - this.alpha);
        this.prevCathode = vCathode;
        this.prevGrid = vGrid;
        double gm = 0.0;
        double ival = (vGrid -= vCathode) + (vAnode -= vCathode) / (double)this.gain;
        this.gridCathode.setConductance(vGrid > 0.01 ? 1.6666666666666666E-4 : 1.0E-8);
        if (ival < 0.0 || this.saturationCurrent == 0.0f) {
            Gds = 1.0E-8;
            ids = vAnode * Gds;
        } else {
            double q;
            ids = Math.sqrt(ival * ival * ival) * (double)this.perveance;
            double x = ids / (double)this.saturationCurrent;
            ids /= Math.sqrt(Math.sqrt(1.0 + x * x * x * x));
            Gds = q = 1.5 * Math.sqrt(ival) * (double)this.perveance;
            gm = q / (double)this.gain;
        }
        this.Ia = -ids + Gds * vAnode + gm * vGrid;
        double iGrid = vGrid > 0.01 ? 1.6666666666666666E-4 * vGrid : 0.0;
        this.Itube = (float)(ids + iGrid);
        this.Ptube = (float)(ids * vAnode + iGrid * vGrid);
        this.setConductance(Gds);
        this.gmStamp.setConductance(gm);
    }

    @Override
    public void addResidual(IResidualAdder residual) {
        residual.add(this.node1.getIndex(), this.Ia);
        residual.add(this.node2.getIndex(), -this.Ia);
    }

    @Override
    public float current() {
        return this.Itube;
    }

    @Override
    public float power() {
        return this.Ptube;
    }

    public static float calculatePerveance(float anodeVoltage, float gain, float anodeCurrent) {
        return (float)((double)anodeCurrent / Math.pow(anodeVoltage / gain, 1.5));
    }

    private static class GMStamp
    extends CompoundWire.ConductanceWire {
        private final IElectricNode node3;

        public GMStamp(IElectricNode node1, IElectricNode node2, IElectricNode node3) {
            super(node1, node2);
            this.node3 = node3;
        }

        @Override
        public void stamp(IAdmittanceAdder admittance, double change) {
            admittance.add(this.node2.getIndex(), this.node1.getIndex(), -change);
            admittance.add(this.node2.getIndex(), this.node3.getIndex(), change);
            admittance.add(this.node1.getIndex(), this.node1.getIndex(), change);
            admittance.add(this.node1.getIndex(), this.node3.getIndex(), -change);
        }

        public List<IElectricNode> coupledNodes() {
            return List.of(this.node1, this.node2, this.node3);
        }
    }
}

