/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.baton;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import org.patryk3211.powergrid.equipment.ZincToolMaterial;
import org.patryk3211.powergrid.equipment.portablebattery.BatteryUtils;

public class ElectroBatonItem
extends SwordItem {
    protected static final UUID ATTACK_KNOCKBACK_MODIFIER_ID = UUID.fromString("14d913a8-879e-45ed-ab47-b5883ebac880");
    private final Multimap<Attribute, AttributeModifier> modifiers;

    public ElectroBatonItem(Item.Properties settings) {
        super((Tier)ZincToolMaterial.INSTANCE, -1, -2.6f, settings.m_41503_(20));
        float attackDamage = this.m_43299_();
        float attackSpeed = -2.6f;
        float knockback = 1.0f;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(ATTACK_KNOCKBACK_MODIFIER_ID, "Weapon modifier", (double)knockback, AttributeModifier.Operation.ADDITION));
        this.modifiers = builder.build();
    }

    public static int fePerUse() {
        return 100;
    }

    public int m_142159_(ItemStack stack) {
        return BatteryUtils.getBarColor(stack, ElectroBatonItem.fePerUse());
    }

    public boolean m_142522_(ItemStack stack) {
        return BatteryUtils.isBarVisible(stack, ElectroBatonItem.fePerUse());
    }

    public int m_142158_(ItemStack stack) {
        return BatteryUtils.getBarWidth(stack, ElectroBatonItem.fePerUse());
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.modifiers : super.m_7167_(slot);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        if (attacker instanceof Player && BatteryUtils.drawEnergy(player = (Player)attacker, ElectroBatonItem.fePerUse())) {
            float health = target.m_21233_();
            int stunStrength = Mth.m_14045_((int)Math.round(30.0f - health), (int)0, (int)10);
            if (stunStrength > 0) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, stunStrength, false, false));
            }
            return true;
        }
        stack.m_41622_(1, attacker, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }
}

