/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.multimeter;

import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlock;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.electricity.ClientElectricNetwork;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.info.Current;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Voltage;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLine;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLinePart;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.CircuitBoardEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireEntity;
import org.patryk3211.powergrid.network.packets.MultimeterDataC2SPacket;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public class MultimeterItem
extends Item
implements IHaveElectricProperties {
    public static final float MAX_DISTANCE = 5.0f;

    public MultimeterItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            return super.m_6225_(context);
        }
        if (context.m_43724_() != InteractionHand.MAIN_HAND) {
            return super.m_6225_(context);
        }
        IElectric electric = IElectric.getAt(context.m_43725_(), context.m_8083_());
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_());
        if (electric != null) {
            BlockPos pos = context.m_8083_();
            int terminal = electric.terminalIndexAt(blockState, context.m_43720_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
            if (terminal >= 0) {
                return this.onTerminal(context.m_43725_(), new BlockWireEndpoint(pos, terminal), context.m_43722_());
            }
        }
        return context.m_43725_().m_141902_(context.m_8083_(), (BlockEntityType)ModdedBlockEntities.CIRCUIT_BOARD.get()).map(be -> {
            BlockPos pos = context.m_8083_();
            BlockState state = context.m_43725_().m_8055_(context.m_8083_());
            Vec3 hitLocalPos = context.m_43720_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            hitLocalPos = VecHelper.rotateCentered((Vec3)hitLocalPos, (double)(-CircuitBoardBlock.getAngleY(state)), (Direction.Axis)Direction.Axis.Y);
            hitLocalPos = VecHelper.rotateCentered((Vec3)hitLocalPos, (double)(-CircuitBoardBlock.getAngleX(state)), (Direction.Axis)Direction.Axis.X);
            if (hitLocalPos.f_82480_ >= 0.125 && hitLocalPos.f_82480_ <= 0.1875) {
                int x = (int)(hitLocalPos.f_82479_ * 16.0);
                int y = (int)(hitLocalPos.f_82481_ * 16.0);
                if (!be.getSchematic().getLayer(CircuitSchematic.Layer.FRONT, x, y)) {
                    return InteractionResult.FAIL;
                }
                return this.onTerminal(context.m_43725_(), new CircuitBoardEndpoint(pos, x, y), context.m_43722_());
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Vec3 getAttachmentPoint() {
        HitResult hit = Minecraft.m_91087_().f_91077_;
        if (hit == null || hit.m_6662_() != HitResult.Type.ENTITY) {
            return null;
        }
        EntityHitResult entityHit = (EntityHitResult)hit;
        return entityHit.m_82450_();
    }

    public InteractionResult useOnWire(Player player, ItemStack stack, InteractionHand hand, BaseWireEntity wireEntity) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (this.getMode(stack) != 1) {
            this.setMode(stack, 1);
        }
        if (player.m_9236_().f_46443_) {
            Vec3 point = MultimeterItem.getAttachmentPoint();
            CompoundTag data = this.getModeData(stack);
            data.m_128350_("X", (float)point.f_82479_);
            data.m_128350_("Y", (float)point.f_82480_);
            data.m_128350_("Z", (float)point.f_82481_);
            ModdedPackets.sendToServer(new MultimeterDataC2SPacket(point, wireEntity));
        }
        return InteractionResult.CONSUME;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        CompoundTag data = this.getModeData(stack);
        switch (this.getMode(stack)) {
            case 0: {
                float V;
                TransmissionLine line;
                OwnedFloatingNode node;
                Vec3 negPos;
                Player player;
                Vec3 posPos;
                IWireEndpoint pos = WireEndpointType.deserialize(data.m_128469_("Pos"));
                IWireEndpoint neg = WireEndpointType.deserialize(data.m_128469_("Neg"));
                if (pos != null && ((posPos = pos.getExactPosition(level)).m_82554_(entity.m_20182_()) > 5.0 || !pos.isValid(level))) {
                    if (entity instanceof Player) {
                        player = (Player)entity;
                        player.m_5661_((Component)Lang.translate("message.multimeter_disconnected", new Object[0]).style(ChatFormatting.GRAY).component(), true);
                    }
                    data.m_128473_("Pos");
                }
                if (neg != null && ((negPos = neg.getExactPosition(level)).m_82554_(entity.m_20182_()) > 5.0 || !neg.isValid(level))) {
                    if (entity instanceof Player) {
                        player = (Player)entity;
                        player.m_5661_((Component)Lang.translate("message.multimeter_disconnected", new Object[0]).style(ChatFormatting.GRAY).component(), true);
                    }
                    data.m_128473_("Neg");
                }
                if (level.f_46443_) break;
                boolean posRem = true;
                boolean negRem = true;
                if (pos != null && pos.type() == WireEndpointType.BLOCK && pos.isValid(level)) {
                    node = pos.getNode(level);
                    line = GlobalElectricNetworks.getWorldNetworks(level).findLineMiddle(node);
                    if (line != null) {
                        V = line.voltageFor(node);
                        data.m_128350_("PosV", V);
                        posRem = false;
                    }
                }
                if (neg != null && neg.type() == WireEndpointType.BLOCK && neg.isValid(level)) {
                    node = neg.getNode(level);
                    line = GlobalElectricNetworks.getWorldNetworks(level).findLineMiddle(node);
                    if (line != null) {
                        V = line.voltageFor(node);
                        data.m_128350_("NegV", V);
                        negRem = false;
                    }
                }
                if (posRem) {
                    data.m_128473_("PosV");
                }
                if (!negRem) break;
                data.m_128473_("NegV");
                break;
            }
            case 1: {
                Vec3 point;
                TransmissionLinePart part;
                WireEntity wireEntity;
                ElectricWire wire;
                Entity genericEntity;
                if (!level.f_46443_ && data.m_128441_("UUID") && (genericEntity = ((ServerLevel)level).m_8791_(data.m_128342_("UUID"))) instanceof WireEntity && (wire = (wireEntity = (WireEntity)genericEntity).getWire()) instanceof TransmissionLinePart && (part = (TransmissionLinePart)wire).getLine() != null) {
                    int lineId = part.getLine().getId();
                    if (data.m_128451_("LineId") != lineId) {
                        data.m_128405_("LineId", lineId);
                    }
                }
                if (!data.m_128441_("X") || !((point = new Vec3((double)data.m_128457_("X"), (double)data.m_128457_("Y"), (double)data.m_128457_("Z"))).m_82554_(entity.m_20182_()) > 5.0)) break;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Lang.translate("message.multimeter_disconnected", new Object[0]).style(ChatFormatting.GRAY).component(), true);
                }
                stack.m_41784_().m_128473_("ModeData");
            }
        }
    }

    public int getMode(ItemStack stack) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("Mode")) {
            return -1;
        }
        return stack.m_41784_().m_128451_("Mode");
    }

    public void setMode(ItemStack stack, int mode) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("Mode", mode);
        tag.m_128473_("ModeData");
    }

    public CompoundTag getModeData(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("ModeData")) {
            return tag.m_128469_("ModeData");
        }
        CompoundTag data = new CompoundTag();
        tag.m_128365_("ModeData", (Tag)data);
        return data;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (player.m_6144_() && usedHand == InteractionHand.MAIN_HAND) {
            player.m_21120_(usedHand).m_41751_(null);
            player.m_5661_((Component)Lang.translate("message.multimeter_disconnected", new Object[0]).style(ChatFormatting.GRAY).component(), true);
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(usedHand));
        }
        return super.m_7203_(level, player, usedHand);
    }

    private InteractionResult onTerminal(Level level, IWireEndpoint endpoint, ItemStack stack) {
        IWireEndpoint current;
        CompoundTag data;
        if (this.getMode(stack) != 0) {
            this.setMode(stack, 0);
        }
        if ((data = this.getModeData(stack)).m_128441_("Pos") && endpoint.equals(current = WireEndpointType.deserialize(data.m_128469_("Pos")))) {
            data.m_128473_("Pos");
            return InteractionResult.SUCCESS;
        }
        if (data.m_128441_("Neg") && endpoint.equals(current = WireEndpointType.deserialize(data.m_128469_("Neg")))) {
            data.m_128473_("Neg");
            return InteractionResult.SUCCESS;
        }
        if (data.m_128441_("Pos") && data.m_128441_("Neg")) {
            return InteractionResult.PASS;
        }
        if (data.m_128441_("Pos")) {
            data.m_128365_("Neg", (Tag)endpoint.serialize());
        } else {
            data.m_128365_("Pos", (Tag)endpoint.serialize());
        }
        return InteractionResult.CONSUME;
    }

    public float getMeasurement(Level level, ItemStack stack) {
        CompoundTag data = this.getModeData(stack);
        return switch (this.getMode(stack)) {
            case 0 -> {
                CircuitBoardEndpoint e;
                IWireEndpoint pos = WireEndpointType.deserialize(data.m_128469_("Pos"));
                IWireEndpoint neg = WireEndpointType.deserialize(data.m_128469_("Neg"));
                if (pos == null || neg == null) {
                    yield 0.0f;
                }
                if (!pos.isValid(level) || !neg.isValid(level)) {
                    yield 0.0f;
                }
                float posV = 0.0f;
                float negV = 0.0f;
                if (data.m_128441_("PosV")) {
                    posV = data.m_128457_("PosV");
                } else {
                    IElectricNode v1;
                    if (pos instanceof CircuitBoardEndpoint) {
                        e = (CircuitBoardEndpoint)pos;
                        v1 = e.getGenericNode(level);
                    } else {
                        v1 = pos.getNode(level);
                    }
                    OwnedFloatingNode posNode = v1;
                    posV = posNode.getVoltage();
                }
                if (data.m_128441_("NegV")) {
                    negV = data.m_128457_("NegV");
                } else {
                    IElectricNode v2;
                    if (neg instanceof CircuitBoardEndpoint) {
                        e = (CircuitBoardEndpoint)neg;
                        v2 = e.getGenericNode(level);
                    } else {
                        v2 = neg.getNode(level);
                    }
                    OwnedFloatingNode negNode = v2;
                    negV = negNode.getVoltage();
                }
                yield posV - negV;
            }
            case 1 -> {
                int lineId = data.m_128451_("LineId");
                yield ClientElectricNetwork.getWorldNetworks().tryGetCurrent(lineId);
            }
            default -> 0.0f;
        };
    }

    public Component getText(Level level, Player user, ItemStack stack) {
        float measurement = this.getMeasurement(level, stack);
        return switch (this.getMode(stack)) {
            case 0 -> {
                LangBuilder voltage = Unit.VOLTAGE.formatWithPrefixes(measurement);
                if (measurement > 500.0f) {
                    voltage = Lang.text(">500 ").add(Unit.VOLTAGE.get());
                } else if (measurement < -500.0f) {
                    voltage = Lang.text("<-500 ").add(Unit.VOLTAGE.get());
                }
                yield Lang.translate("tooltip.multimeter.voltage", new Object[0]).add(voltage.style(ChatFormatting.BLUE)).style(ChatFormatting.GRAY).component();
            }
            case 1 -> {
                LangBuilder current = Unit.CURRENT.formatWithPrefixes(measurement);
                if (measurement > 50.0f) {
                    current = Lang.text(">50 ").add(Unit.CURRENT.get());
                } else if (measurement < -50.0f) {
                    current = Lang.text("<-50 ").add(Unit.CURRENT.get());
                }
                yield Lang.translate("tooltip.multimeter.current", new Object[0]).add(current.style(ChatFormatting.YELLOW)).style(ChatFormatting.GRAY).component();
            }
            default -> null;
        };
    }

    public float getDial(Level level, ItemStack stack) {
        float measurement = this.getMeasurement(level, stack);
        float value = Math.abs(switch (this.getMode(stack)) {
            case 0 -> measurement / 500.0f;
            case 1 -> measurement / 50.0f;
            default -> 0.0f;
        });
        if (value > 1.0f) {
            return 1.0f + level.f_46441_.m_188501_() * 0.125f;
        }
        return value;
    }

    @Override
    public void appendProperties(ItemStack stack, Player player, List<Component> tooltip) {
        Voltage.max(500.0f, player, tooltip);
        Current.max(50.0f, player, tooltip);
    }
}

