/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.forge;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ChunkTicketLevelUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.wire.WireEntity;

public class ForgeEvents {
    @SubscribeEvent
    public static void entityUnloadEvent(EntityLeaveLevelEvent event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            WireEntity.entityUnload(event.getEntity(), world);
        }
    }

    @SubscribeEvent
    public static void chunkTicketUpdate(ChunkTicketLevelUpdatedEvent event) {
        block5: {
            LevelChunk chunk;
            block4: {
                if (event.getChunkHolder() == null) {
                    return;
                }
                chunk = event.getChunkHolder().m_140085_();
                if (chunk == null) {
                    return;
                }
                if (event.getNewTicketLevel() < 33 || event.getOldTicketLevel() > 32) break block4;
                for (BlockEntity be : chunk.m_62954_().values()) {
                    SmartBlockEntity smart;
                    ElectricBehaviour electric;
                    if (!(be instanceof SmartBlockEntity) || (electric = (ElectricBehaviour)(smart = (SmartBlockEntity)be).getBehaviour(ElectricBehaviour.TYPE)) == null) continue;
                    electric.pause();
                }
                break block5;
            }
            if (event.getNewTicketLevel() > 32) break block5;
            for (BlockEntity be : chunk.m_62954_().values()) {
                SmartBlockEntity smart;
                ElectricBehaviour electric;
                if (!(be instanceof SmartBlockEntity) || (electric = (ElectricBehaviour)(smart = (SmartBlockEntity)be).getBehaviour(ElectricBehaviour.TYPE)) == null) continue;
                electric.unpause();
            }
        }
    }

    @SubscribeEvent
    public static void chunkLoad(ChunkEvent.Load event) {
        LevelAccessor level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        WorldNetworks global = GlobalElectricNetworks.getWorldNetworks(level);
        if (global == null) {
            return;
        }
        global.chunkLoaded(event.getChunk().m_7697_());
    }
}

