/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.rheostat;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.resistor.ResistorValueBehaviour;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.kinetics.base.TunedBlockEntity;
import org.patryk3211.powergrid.kinetics.rheostat.RheostatBlock;
import org.patryk3211.powergrid.utility.Lang;

public class RheostatBlockEntity
extends TunedBlockEntity
implements IHaveGoggleInformation {
    protected ResistorValueBehaviour value;
    protected ElectricWire half1;
    protected ElectricWire half2;

    public RheostatBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.value = new ResistorValueBehaviour((Component)Lang.translateDirect("devices.resistor.resistance", new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new RheostatBox(), -2, 18);
        this.value.setValue(0);
        this.value.withCallback($ -> this.refreshParameters());
        behaviours.add((BlockEntityBehaviour)this.value);
        super.addBehaviours(behaviours);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig((SmartBlockEntity)this);
    }

    public float getRatio() {
        if (this.arm == null) {
            return 0.01f;
        }
        return this.arm.getValue() * 0.98f + 0.01f;
    }

    @Override
    public float resistance() {
        return this.value.getResistance();
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(3);
        float ratio = this.getRatio();
        this.half1 = builder.connect((1.0f - ratio) * this.resistance(), builder.terminalNode(0), builder.terminalNode(1));
        this.half2 = builder.connect(ratio * this.resistance(), builder.terminalNode(1), builder.terminalNode(2));
    }

    @Override
    public void refreshParameters() {
        float ratio = this.getRatio();
        this.half1.setResistance((1.0f - ratio) * this.resistance());
        this.half2.setResistance(ratio * this.resistance());
    }

    @Override
    public void tick() {
        this.applyPower(this.half1);
        this.applyPower(this.half2);
        super.tick();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!isPlayerSneaking) {
            return false;
        }
        Lang.builder().translate("gui.rheostat.info_header", new Object[0]).forGoggles(tooltip);
        Lang.builder().translate("gui.rheostat.ratio", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        float ratio = this.getRatio();
        LangBuilder ratioText = Lang.number(1.0f - ratio).add(Component.m_237113_((String)" : ")).add(Lang.number(ratio));
        ratioText.style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        return true;
    }

    public static class RheostatBox
    extends CenteredSideValueBoxTransform {
        public RheostatBox() {
            super((state, dir) -> dir != state.m_61143_((Property)RheostatBlock.HORIZONTAL_FACING) && dir.m_122434_() != Direction.Axis.Y);
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)6.0, (double)13.5);
        }
    }
}

