/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.patryk3211.powergrid.electricity.ClientElectricNetwork;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLine;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.network.SimplePacket;

public class TransmissionLineStateS2CPacket
implements SimplePacket {
    public final int lineId;
    public final IWireEndpoint endpoint1;
    public final IWireEndpoint endpoint2;
    public final float lineResistance;
    public final float node1Voltage;
    public final float node2Voltage;

    public TransmissionLineStateS2CPacket(TransmissionLine line) {
        this.lineId = line.getId();
        this.endpoint1 = line.getNode1().endpoint;
        this.endpoint2 = line.getNode2().endpoint;
        this.lineResistance = (float)line.getResistance();
        this.node1Voltage = line.getNode1().getVoltage();
        this.node2Voltage = line.getNode2().getVoltage();
    }

    public TransmissionLineStateS2CPacket(FriendlyByteBuf buf) {
        this.lineId = buf.readInt();
        this.endpoint1 = WireEndpointType.deserialize(buf.m_130260_());
        this.endpoint2 = WireEndpointType.deserialize(buf.m_130260_());
        this.lineResistance = buf.readFloat();
        this.node1Voltage = buf.readFloat();
        this.node2Voltage = buf.readFloat();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.lineId);
        buf.m_130079_(this.endpoint1.serialize());
        buf.m_130079_(this.endpoint2.serialize());
        buf.writeFloat(this.lineResistance);
        buf.writeFloat(this.node1Voltage);
        buf.writeFloat(this.node2Voltage);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> ClientElectricNetwork.partialTrackedLine(this));
    }
}

