/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.utility;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;

public class BlockTrace {
    public static BlockHitResult raycast(Level world, Vec3 start, Vec3 end, @Nullable ITerminalPlacement passThrough) {
        return (BlockHitResult)BlockGetter.m_151361_((Vec3)start, (Vec3)end, null, (innerContext, pos) -> {
            BlockState blockState = world.m_8055_(pos);
            VoxelShape voxelShape = blockState.m_60808_((BlockGetter)world, pos);
            BlockHitResult hit = world.m_45558_(start, end, pos, voxelShape, blockState);
            if (hit != null && passThrough != null && passThrough.check((BlockPos)pos, hit.m_82450_())) {
                return null;
            }
            return hit;
        }, innerContext -> {
            Vec3 heading = start.m_82546_(end);
            return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.m_122366_((double)heading.f_82479_, (double)heading.f_82480_, (double)heading.f_82481_), (BlockPos)BlockPos.m_274446_((Position)end));
        });
    }

    public static BlockHitResult raycast(Level world, Vec3 start, Vec3 end) {
        BlockPos ignore1 = BlockPos.m_274446_((Position)start);
        BlockPos ignore2 = BlockPos.m_274446_((Position)end);
        return (BlockHitResult)BlockGetter.m_151361_((Vec3)start, (Vec3)end, null, (innerContext, pos) -> {
            BlockState blockState = world.m_8055_(pos);
            VoxelShape voxelShape = blockState.m_60808_((BlockGetter)world, pos);
            BlockHitResult hit = world.m_45558_(start, end, pos, voxelShape, blockState);
            if (hit != null && (hit.m_82425_().equals((Object)ignore1) || hit.m_82425_().equals((Object)ignore2))) {
                return null;
            }
            return hit;
        }, innerContext -> {
            Vec3 heading = start.m_82546_(end);
            return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.m_122366_((double)heading.f_82479_, (double)heading.f_82480_, (double)heading.f_82481_), (BlockPos)BlockPos.m_274446_((Position)end));
        });
    }

    private static double clamp(double val, double min, double max) {
        return Math.max(Math.min(val, max), min);
    }

    public static Vec3 closestPoint(AABB box, Vec3 point) {
        return new Vec3(BlockTrace.clamp(point.f_82479_, box.f_82288_, box.f_82291_), BlockTrace.clamp(point.f_82480_, box.f_82289_, box.f_82292_), BlockTrace.clamp(point.f_82481_, box.f_82290_, box.f_82293_));
    }

    private static BlockWireEntity.Point makePoint(Vec3 start, Vec3 end) {
        double distX = end.f_82479_ - start.f_82479_;
        double distY = end.f_82480_ - start.f_82480_;
        double distZ = end.f_82481_ - start.f_82481_;
        double lenX = Math.abs(distX);
        double lenY = Math.abs(distY);
        double lenZ = Math.abs(distZ);
        if (lenX > lenY && lenX > lenZ) {
            return BlockWireEntity.Point.x((float)distX);
        }
        if (lenY > lenZ) {
            return BlockWireEntity.Point.y((float)distY);
        }
        return BlockWireEntity.Point.z((float)distZ);
    }

    public static Vec3 alignPosition(Vec3 position) {
        return new Vec3((double)((float)((int)Math.round(position.f_82479_ * 16.0)) / 16.0f), (double)((float)((int)Math.round(position.f_82480_ * 16.0)) / 16.0f), (double)((float)((int)Math.round(position.f_82481_ * 16.0)) / 16.0f));
    }

    public static TraceResult findPath(Level world, Vec3 start, Vec3 end, @Nullable ITerminalPlacement terminal, @Nullable Direction continueDirection) {
        Pair<TraceState, TraceResult> result = BlockTrace.findPathWithState(world, start, end, terminal, continueDirection);
        if (result == null) {
            return null;
        }
        return (TraceResult)result.getSecond();
    }

    private static TraceCell testDirection(@NotNull Direction direction, TraceCell cell, TraceState state, PriorityQueue<TraceCell> visitQueue, int scoreAdjust) {
        Vec3i neighborPos = state.findNextPosition(cell, direction);
        if (neighborPos == null) {
            return null;
        }
        TraceCell neighbor = state.getCell(neighborPos);
        int distance = cell.position.m_123333_(neighborPos);
        int newDistance = cell.originDistance + Math.max(distance + (neighbor.isSupported() ? scoreAdjust : 0), 1);
        if (newDistance >= neighbor.originDistance) {
            return null;
        }
        if (!neighbor.isSupported()) {
            int newUnsupportedDistance = cell.unsupportedDistance + distance;
            if (neighbor.unsupportedDistance != 0 && newUnsupportedDistance >= neighbor.unsupportedDistance) {
                return null;
            }
            neighbor.unsupportedDistance = newUnsupportedDistance;
        }
        if (neighbor.unsupportedDistance > 16) {
            return null;
        }
        neighbor.originDistance = newDistance;
        neighbor.backtrace = cell;
        visitQueue.add(neighbor);
        return neighbor;
    }

    public static Pair<TraceState, TraceResult> findPathWithState(Level world, Vec3 start, Vec3 end, @Nullable ITerminalPlacement terminal, @Nullable Direction continueDirection) {
        TraceState state = new TraceState(world, start, end, terminal);
        if (state.target.equals((Object)state.originCell.position) || !state.getCell(state.target).isSupported()) {
            return null;
        }
        PriorityQueue<TraceCell> visitQueue = new PriorityQueue<TraceCell>(Comparator.comparingInt(state::score));
        visitQueue.add(state.originCell);
        int bestScore = Integer.MAX_VALUE;
        TraceCell bestCell = null;
        while (!visitQueue.isEmpty()) {
            int neighborScore;
            TraceCell continuedNeighbor;
            TraceCell cell = visitQueue.poll();
            if (cell.originDistance > 160) continue;
            if (cell.position.equals((Object)state.target)) {
                return Pair.of((Object)state, (Object)new TraceResult(state.traceResult(cell), true));
            }
            if (state.states.size() > 150) break;
            Direction prevDirection = cell.cellDirection();
            if (prevDirection == null) {
                prevDirection = continueDirection;
            }
            if (prevDirection != null && (continuedNeighbor = BlockTrace.testDirection(prevDirection, cell, state, visitQueue, -1)) != null && (neighborScore = state.targetDistance(continuedNeighbor)) < bestScore) {
                bestScore = neighborScore;
                bestCell = continuedNeighbor;
            }
            for (Direction direction : Direction.values()) {
                int neighborScore2;
                TraceCell neighbor;
                if (direction == prevDirection || prevDirection != null && direction == prevDirection.m_122424_() || (neighbor = BlockTrace.testDirection(direction, cell, state, visitQueue, 0)) == null || (neighborScore2 = state.targetDistance(neighbor)) >= bestScore) continue;
                bestScore = neighborScore2;
                bestCell = neighbor;
            }
        }
        if (bestCell != null) {
            return Pair.of((Object)state, (Object)new TraceResult(state.traceResult(bestCell), false));
        }
        return Pair.of((Object)state, null);
    }

    public static class TraceState {
        public static final int GRID_SIZE = 16;
        public static final float UNIT_SIZE = 0.0625f;
        public static final float HALF_UNIT = 0.03125f;
        public final Map<Vec3i, TraceCell> states = new HashMap<Vec3i, TraceCell>();
        public final Level world;
        public final Vec3 origin;
        public final Vec3i target;
        public final TraceCell originCell;
        @Nullable
        public final ITerminalPlacement terminal;

        public TraceState(Level world, Vec3 origin, Vec3 target, @Nullable ITerminalPlacement terminal) {
            this.world = world;
            this.origin = new Vec3(Math.floor(origin.f_82479_), Math.floor(origin.f_82480_), Math.floor(origin.f_82481_));
            Vec3i originPos = this.transform(origin);
            this.originCell = this.createCell(originPos, 0);
            this.states.put(originPos, this.originCell);
            this.target = this.transform(target);
            this.terminal = terminal;
        }

        public Vec3i transform(Vec3 pos) {
            return new Vec3i((int)Math.floor((pos.f_82479_ - this.origin.f_82479_) * 16.0), (int)Math.floor((pos.f_82480_ - this.origin.f_82480_) * 16.0), (int)Math.floor((pos.f_82481_ - this.origin.f_82481_) * 16.0));
        }

        public Vec3 transform(Vec3i pos) {
            return new Vec3((double)((float)pos.m_123341_() * 0.0625f) + this.origin.f_82479_, (double)((float)pos.m_123342_() * 0.0625f) + this.origin.f_82480_, (double)((float)pos.m_123343_() * 0.0625f) + this.origin.f_82481_);
        }

        public Vec3 transform(TraceCell cell) {
            return this.transform(cell.position);
        }

        public boolean isSupport(Vec3i position) {
            Vec3 worldPos = this.transform(position);
            BlockPos blockPos = BlockPos.m_274446_((Position)worldPos);
            BlockState state = this.world.m_8055_(blockPos);
            return state.m_60796_((BlockGetter)this.world, blockPos);
        }

        @NotNull
        public TraceCell createCell(Vec3i position, int length) {
            boolean isSupported = false;
            for (Direction dir : Direction.values()) {
                if (!position.equals((Object)this.target) && !this.isSupport(position.m_121955_(dir.m_122436_()))) continue;
                isSupported = true;
                break;
            }
            TraceCell cell = new TraceCell(position, length, isSupported);
            this.states.put(position, cell);
            return cell;
        }

        public void writeCell(Vec3i position, Vec3 nudge) {
            if (!this.states.containsKey(position)) {
                TraceCell cell = this.createCell(position, Integer.MAX_VALUE);
                cell.nudge = nudge;
            }
        }

        @NotNull
        public TraceCell getCell(Vec3i cellPos) {
            if (!this.states.containsKey(cellPos)) {
                return this.createCell(cellPos, Integer.MAX_VALUE);
            }
            return this.states.get(cellPos);
        }

        public int score(TraceCell cell) {
            return cell.originDistance + this.targetDistance(cell);
        }

        public int targetDistance(TraceCell cell) {
            return cell.position.m_123333_(this.target);
        }

        public int offsetToFullBlock(int coordinate, Direction.AxisDirection direction) {
            int offset = 0;
            switch (direction) {
                case POSITIVE: {
                    if (coordinate >= 0) {
                        offset = 16 - coordinate % 16;
                        break;
                    }
                    offset = -(coordinate % 16);
                    break;
                }
                case NEGATIVE: {
                    offset = coordinate >= 0 ? -(coordinate % 16) : -(16 + coordinate % 16);
                }
            }
            return offset;
        }

        @Nullable
        public Vec3i raycastNextPosition(TraceCell currentCell, Direction dir) {
            Direction side;
            Vec3i retPos;
            Direction.Axis axis = dir.m_122434_();
            Vec3i currentPos = currentCell.position;
            int axialLength = Math.abs(this.target.m_123304_(axis) - currentPos.m_123304_(axis));
            BlockHitResult hit = null;
            for (Direction castOffsetDir : Direction.values()) {
                Vec3 castEnd;
                Vec3 castStart;
                if (castOffsetDir.m_122434_() != dir.m_122434_() && !(hit = BlockTrace.raycast(this.world, castStart = this.transform(currentCell).m_231075_(castOffsetDir, 0.03125), castEnd = castStart.m_231075_(dir, (double)((float)axialLength * 0.0625f)), this.terminal)).m_82436_()) break;
            }
            if (hit == null) {
                return null;
            }
            if (hit.m_82436_()) {
                int axisCoordinate = currentPos.m_123304_(axis);
                int offset = this.offsetToFullBlock(axisCoordinate, dir.m_122421_());
                if (Math.abs(offset) > 8) {
                    return null;
                }
                return currentPos.m_5487_(axis, offset);
            }
            Vec3i cellPos = this.transform(hit.m_82450_());
            switch (hit.m_6662_()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case MISS: {
                    Vec3i vec3i = cellPos;
                    break;
                }
                case ENTITY: {
                    Vec3i vec3i = null;
                    break;
                }
                case BLOCK: {
                    Vec3i vec3i = retPos = cellPos;
                }
            }
            if (retPos != null && (side = hit.m_82434_()).m_122421_() == Direction.AxisDirection.NEGATIVE) {
                this.writeCell(cellPos, Vec3.f_82478_.m_193103_(side.m_122434_(), -0.03125));
            }
            return retPos;
        }

        @Nullable
        public Vec3i findNextPosition(TraceCell currentCell, Direction dir) {
            Direction.Axis axis = dir.m_122434_();
            Vec3i currentPos = currentCell.position;
            Vec3i castPos = this.raycastNextPosition(currentCell, dir);
            if (castPos == null || currentPos.equals((Object)castPos)) {
                return null;
            }
            int axisCoordinate = currentPos.m_123304_(axis);
            int boundaryOffset = this.offsetToFullBlock(axisCoordinate, dir.m_122421_());
            if (boundaryOffset == 0) {
                boundaryOffset = -16;
            }
            int nextBoundary = axisCoordinate + boundaryOffset;
            int raycastBoundary = castPos.m_123304_(axis);
            if (Math.abs(nextBoundary - axisCoordinate) > Math.abs(raycastBoundary - axisCoordinate)) {
                return currentPos.m_5487_(axis, raycastBoundary - axisCoordinate);
            }
            return currentPos.m_5487_(axis, nextBoundary - axisCoordinate);
        }

        public List<Vec3i> traceback(TraceCell cell) {
            ArrayList<Vec3i> positions = new ArrayList<Vec3i>();
            Direction.Axis currentAxis = null;
            Vec3i lastPosition = cell.position;
            while (cell.backtrace != null) {
                cell = cell.backtrace;
                Direction.Axis axis = cell.position.m_123341_() != lastPosition.m_123341_() ? Direction.Axis.X : (cell.position.m_123342_() != lastPosition.m_123342_() ? Direction.Axis.Y : Direction.Axis.Z);
                if (axis != currentAxis) {
                    positions.add(0, lastPosition);
                    currentAxis = axis;
                }
                lastPosition = cell.position;
            }
            positions.add(0, lastPosition);
            return positions;
        }

        public List<BlockWireEntity.Point> traceResult(TraceCell cell) {
            ArrayList pathPoints = new ArrayList();
            this.traceback(cell).forEach(p -> pathPoints.add(this.transform((Vec3i)p)));
            ArrayList<BlockWireEntity.Point> result = new ArrayList<BlockWireEntity.Point>();
            Vec3 current = this.transform(this.originCell.position);
            for (Vec3 point : pathPoints) {
                BlockWireEntity.Point segment = BlockTrace.makePoint(current, point);
                if (segment.gridLength > 0) {
                    result.add(segment);
                }
                current = point;
            }
            return result;
        }
    }

    public record TraceResult(List<BlockWireEntity.Point> points, boolean reachedTarget) {
    }

    public static class TraceCell {
        public final Vec3i position;
        public int originDistance;
        public TraceCell backtrace;
        public boolean isSupported;
        public int unsupportedDistance;
        public boolean isInside;
        public Vec3 nudge = Vec3.f_82478_;

        public TraceCell(Vec3i position, int originDistance, boolean isSupported) {
            this.position = position;
            this.originDistance = originDistance;
            this.isSupported = isSupported;
            this.unsupportedDistance = 0;
        }

        public boolean isSupported() {
            return this.isSupported;
        }

        @Nullable
        public Direction cellDirection() {
            if (this.backtrace == null) {
                return null;
            }
            Vec3i p1 = this.backtrace.position;
            Vec3i p2 = this.position;
            return Direction.m_122378_((int)(p2.m_123341_() - p1.m_123341_()), (int)(p2.m_123342_() - p1.m_123342_()), (int)(p2.m_123343_() - p1.m_123343_()));
        }
    }
}

