/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.utility.forge;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import org.apache.logging.log4j.util.TriConsumer;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.base.CustomProperties;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlock;
import org.patryk3211.powergrid.circuits.editor.CircuitDesignTableBlock;
import org.patryk3211.powergrid.electricity.basinheater.BasinHeaterBlock;
import org.patryk3211.powergrid.electricity.electricswitch.HvSwitchBlock;
import org.patryk3211.powergrid.electricity.electricswitch.SwitchBlock;
import org.patryk3211.powergrid.electricity.fuse.FuseHolderBlock;
import org.patryk3211.powergrid.electricity.fuse.FuseState;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlock;
import org.patryk3211.powergrid.electricity.transformer.TransformerMediumBlock;
import org.patryk3211.powergrid.electricity.transformer.TransformerSmallBlock;
import org.patryk3211.powergrid.kinetics.generator.housing.GeneratorHousing;
import org.patryk3211.powergrid.kinetics.generator.inductionrotor.VerticalCommutatorBlock;
import org.patryk3211.powergrid.kinetics.generator.rotor.AbstractRotorBlock;
import org.patryk3211.powergrid.kinetics.generator.winding.WindingBlock;

public class DataProviderUtilityImpl {
    public static ModelFile.ExistingModelFile modModel(RegistrateBlockstateProvider prov, String name) {
        return prov.models().getExistingFile(prov.modLoc(name));
    }

    public static ModelFile.UncheckedModelFile unchecked(String name) {
        return new ModelFile.UncheckedModelFile(PowerGrid.asResource(name));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> horizontalBlock(String model) {
        return (ctx, prov) -> prov.horizontalBlock((Block)ctx.getEntry(), (ModelFile)DataProviderUtilityImpl.modModel(prov, model));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> horizontalBlock(Function<BlockState, String> model) {
        return (ctx, prov) -> prov.horizontalBlock((Block)ctx.getEntry(), state -> DataProviderUtilityImpl.modModel(prov, (String)model.apply((BlockState)state)));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> alternateDirectionalBlock(Function<BlockState, String> modelProvider) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, (String)modelProvider.apply((BlockState)state)));
            switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)) {
                case SOUTH: {
                    builder.rotationY(180);
                    break;
                }
                case EAST: {
                    builder.rotationY(90);
                    break;
                }
                case WEST: {
                    builder.rotationY(-90);
                    break;
                }
                case UP: {
                    builder.rotationX(-90);
                    break;
                }
                case DOWN: {
                    builder.rotationX(90);
                }
            }
            return builder.build();
        });
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> horizontalAxisBlock(String model) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, model));
            if (state.m_61143_((Property)BlockStateProperties.f_61364_) == Direction.Axis.X) {
                builder.rotationY(90);
            }
            return builder.build();
        });
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> surfaceSwitch(String baseName) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            String suffix = (Boolean)state.m_61143_((Property)SwitchBlock.OPEN) != false ? "_off" : "_on";
            DataProviderUtilityImpl.surfaceFacingTransforms(state, (TriConsumer<Integer, Integer, Boolean>)((TriConsumer)(x, y, vertical) -> {
                String suffix2 = vertical != false ? "_v" : "_h";
                builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, baseName + suffix + suffix2));
                builder.rotationX(x.intValue()).rotationY(y.intValue());
            }));
            return builder.build();
        });
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> surfaceBlock(String baseName) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            DataProviderUtilityImpl.surfaceFacingTransforms(state, (TriConsumer<Integer, Integer, Boolean>)((TriConsumer)(x, y, vertical) -> {
                String suffix = vertical != false ? "_v" : "_h";
                builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, baseName + suffix));
                builder.rotationX(x.intValue()).rotationY(y.intValue());
            }));
            return builder.build();
        });
    }

    public static NonNullBiConsumer<DataGenContext<Block, LightFixtureBlock>, RegistrateBlockstateProvider> lightFixture(String baseName) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            Boolean axis_along_first = (Boolean)state.m_61143_((Property)CustomProperties.ALONG_FIRST_AXIS);
            int x = 0;
            int y = 0;
            boolean vertical = false;
            switch (facing) {
                case UP: {
                    vertical = true;
                    break;
                }
                case DOWN: {
                    x = 180;
                    vertical = true;
                    break;
                }
                case EAST: {
                    y = 180;
                    break;
                }
                case NORTH: {
                    y = 90;
                    break;
                }
                case SOUTH: {
                    y = -90;
                }
            }
            if (!axis_along_first.booleanValue() && vertical) {
                y = 90;
            } else if (axis_along_first.booleanValue() && !vertical) {
                x = -90;
            }
            String suffix = vertical ? "_v" : "_h";
            builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, baseName + suffix));
            builder.rotationX(x).rotationY(y);
            return builder.build();
        });
    }

    public static void surfaceFacingTransforms(BlockState state, TriConsumer<Integer, Integer, Boolean> transformer) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        boolean axis_along_first = false;
        if (state.m_61138_((Property)CustomProperties.ALONG_FIRST_AXIS)) {
            axis_along_first = (Boolean)state.m_61143_((Property)CustomProperties.ALONG_FIRST_AXIS);
        } else if (state.m_61138_((Property)CustomProperties.ROTATION_4)) {
            axis_along_first = (Integer)state.m_61143_((Property)CustomProperties.ROTATION_4) % 2 == 1;
        }
        int x = 0;
        int y = 0;
        boolean verticalModel = false;
        switch (facing) {
            case UP: {
                x = 180;
                verticalModel = true;
                break;
            }
            case DOWN: {
                verticalModel = true;
                break;
            }
            case WEST: {
                y = 180;
                break;
            }
            case NORTH: {
                y = -90;
                break;
            }
            case SOUTH: {
                y = 90;
            }
        }
        if (!axis_along_first) {
            if (verticalModel) {
                y = 90;
            } else {
                x = -90;
            }
        }
        transformer.accept((Object)x, (Object)y, (Object)verticalModel);
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> housing(String name) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, name));
            int x = 0;
            int y = 0;
            Direction facing = (Direction)state.m_61143_(GeneratorHousing.HORIZONTAL_FACING);
            if (facing.m_122434_() == Direction.Axis.X) {
                y = -90;
            }
            if (facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
                x = -90;
            }
            if (((Boolean)state.m_61143_((Property)GeneratorHousing.UP)).booleanValue()) {
                x = 90 - x;
            }
            return builder.rotationX(x).rotationY(y).build();
        });
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> basinHeater(String baseName) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            Object model = switch ((BlazeBurnerBlock.HeatLevel)state.m_61143_(BasinHeaterBlock.HEAT_LEVEL)) {
                default -> throw new IncompatibleClassChangeError();
                case BlazeBurnerBlock.HeatLevel.NONE, BlazeBurnerBlock.HeatLevel.SMOULDERING -> baseName;
                case BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> baseName + "_on";
                case BlazeBurnerBlock.HeatLevel.SEETHING -> baseName + "_seething";
            };
            builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, (String)model));
            return builder.build();
        });
    }

    public static <T extends AbstractRotorBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> rotorModel(String name) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            int x = 90;
            int y = 0;
            ModelFile.ExistingModelFile model = DataProviderUtilityImpl.modModel(prov, name);
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)model);
            Direction.Axis axis = state.m_61138_((Property)BlockStateProperties.f_61365_) ? (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_) : (state.m_61138_((Property)BlockStateProperties.f_61364_) ? (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_) : Direction.Axis.Z);
            switch (axis) {
                case X: {
                    builder.rotationY(y - 90);
                    break;
                }
                case Z: {
                    builder.rotationY(y);
                    break;
                }
                case Y: {
                    builder.rotationX(x);
                }
            }
            return builder.build();
        });
    }

    public static <T extends VerticalCommutatorBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> verticalCommutator(String name) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            ModelFile.ExistingModelFile model = DataProviderUtilityImpl.modModel(prov, name);
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)model);
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61366_)).booleanValue()) {
                builder.rotationX(180);
            }
            builder.rotationY((int)(facing.m_122435_() - 180.0f));
            return builder.build();
        });
    }

    public static <T extends HvSwitchBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> hvSwitch(String baseName) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            Integer part = (Integer)state.m_61143_((Property)HvSwitchBlock.PART);
            if (part == 0) {
                builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, baseName + "_body"));
            } else {
                builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, baseName + "_receptacle"));
            }
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            builder.rotationY((int)facing.m_122435_());
            return builder.build();
        });
    }

    public static NonNullBiConsumer<DataGenContext<Block, TransformerSmallBlock>, RegistrateBlockstateProvider> transformerSmall() {
        return (ctx, prov) -> ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.getEntry()).part().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/transformer/small")).addModel()).condition(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).end().part().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/transformer/small_coil1")).addModel()).condition(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).condition((Property)TransformerSmallBlock.COILS, (Comparable[])new Integer[]{1, 2}).end().part().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/transformer/small_coil2")).addModel()).condition(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).condition((Property)TransformerSmallBlock.COILS, (Comparable[])new Integer[]{2}).end().part().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/transformer/small")).rotationY(90).addModel()).condition(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).end().part().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/transformer/small_coil1")).rotationY(90).addModel()).condition(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).condition((Property)TransformerSmallBlock.COILS, (Comparable[])new Integer[]{1, 2}).end().part().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/transformer/small_coil2")).rotationY(90).addModel()).condition(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).condition((Property)TransformerSmallBlock.COILS, (Comparable[])new Integer[]{2}).end();
    }

    public static NonNullBiConsumer<DataGenContext<Block, TransformerMediumBlock>, RegistrateBlockstateProvider> transformerMedium() {
        return (ctx, prov) -> {
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.getEntry());
            DataProviderUtilityImpl.transformerMedium(builder, prov, Direction.Axis.Z);
            DataProviderUtilityImpl.transformerMedium(builder, prov, Direction.Axis.X);
        };
    }

    public static void transformerMedium(MultiPartBlockStateBuilder builder, RegistrateBlockstateProvider prov, Direction.Axis axis) {
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_bottom", axis, 0, false).end();
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_bottom_1", axis, 1, false).end();
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_top", axis, 2, false).end();
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_top_1", axis, 3, false).end();
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_coil1", axis, 0, true).condition((Property)TransformerMediumBlock.COILS, (Comparable[])new Integer[]{1, 2}).end();
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_coil1", axis, 1, true).condition((Property)TransformerMediumBlock.COILS, (Comparable[])new Integer[]{1, 2}).end();
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_coil2", axis, 2, true).condition((Property)TransformerMediumBlock.COILS, (Comparable[])new Integer[]{2}).end();
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_coil2", axis, 3, true).condition((Property)TransformerMediumBlock.COILS, (Comparable[])new Integer[]{2}).end();
    }

    private static MultiPartBlockStateBuilder.PartBuilder transformerMediumPart(MultiPartBlockStateBuilder builder, RegistrateBlockstateProvider prov, String model, Direction.Axis axis, int part, boolean coil) {
        int y = 0;
        if (part % 2 == 1 && coil) {
            y = 180;
        }
        if (axis == Direction.Axis.X) {
            y -= 90;
        }
        return ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, model)).rotationY(y).addModel()).condition(TransformerMediumBlock.HORIZONTAL_AXIS, (Comparable[])new Direction.Axis[]{axis}).condition((Property)TransformerMediumBlock.PART, (Comparable[])new Integer[]{part});
    }

    public static <T extends WindingBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> windingModel() {
        return (ctx, prov) -> {
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.getEntry());
            for (Direction.Axis axis : Direction.Axis.values()) {
                for (int i = 0; i <= 2; ++i) {
                    DataProviderUtilityImpl.windingModel(axis, i, true, builder, prov);
                    DataProviderUtilityImpl.windingModel(axis, i, false, builder, prov);
                }
            }
        };
    }

    private static void windingModel(Direction.Axis axis, int part, boolean alongFirst, MultiPartBlockStateBuilder builder, RegistrateBlockstateProvider prov) {
        int x = 0;
        int y = 0;
        switch (axis) {
            case X: {
                y = -90;
                break;
            }
            case Y: {
                x = 90;
            }
        }
        if (part == 2) {
            if (axis == Direction.Axis.Y) {
                x += 180;
            } else {
                y += 180;
            }
        }
        ModelFile.ExistingModelFile model = switch (part) {
            case 0, 2 -> {
                Object base;
                Object v0 = base = alongFirst ? "block/winding/end_v" : "block/winding/end";
                if (part == 2 && !alongFirst && axis.m_122479_()) {
                    base = (String)base + "_1";
                }
                yield DataProviderUtilityImpl.modModel(prov, (String)base);
            }
            case 1 -> DataProviderUtilityImpl.modModel(prov, alongFirst ? "block/winding/middle_v" : "block/winding/middle");
            default -> throw new IllegalStateException();
        };
        Function<Boolean, ModelFile.ExistingModelFile> caseModel = half -> {
            boolean condition;
            boolean bl = condition = half == false;
            condition = axis == Direction.Axis.Z ? (condition ^= alongFirst && part == 2) : (axis == Direction.Axis.Y ? (condition ^= !alongFirst && part != 2) : (condition ^= alongFirst && part != 2));
            String halfStr = condition ? "p" : "n";
            return switch (part) {
                case 0, 2 -> DataProviderUtilityImpl.modModel(prov, "block/winding/end" + (alongFirst ? "_v" : "") + "_case_" + halfStr);
                case 1 -> DataProviderUtilityImpl.modModel(prov, "block/winding/middle" + (alongFirst ? "_v" : "") + "_case_" + halfStr);
                default -> throw new IllegalStateException();
            };
        };
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)caseModel.apply(false)).rotationX(x).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61365_, (Comparable[])new Direction.Axis[]{axis}).condition((Property)WindingBlock.PART, (Comparable[])new Integer[]{part}).condition((Property)CustomProperties.ALONG_FIRST_AXIS, (Comparable[])new Boolean[]{alongFirst}).condition((Property)WindingBlock.CASE_LEFT, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)caseModel.apply(true)).rotationX(x).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61365_, (Comparable[])new Direction.Axis[]{axis}).condition((Property)WindingBlock.PART, (Comparable[])new Integer[]{part}).condition((Property)CustomProperties.ALONG_FIRST_AXIS, (Comparable[])new Boolean[]{alongFirst}).condition((Property)WindingBlock.CASE_RIGHT, (Comparable[])new Boolean[]{true}).end();
        if (axis == Direction.Axis.Y && alongFirst && part == 0) {
            y = 180;
        } else if (axis == Direction.Axis.Y && alongFirst && part == 1) {
            y += 180;
        }
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationX(x).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61365_, (Comparable[])new Direction.Axis[]{axis}).condition((Property)WindingBlock.PART, (Comparable[])new Integer[]{part}).condition((Property)CustomProperties.ALONG_FIRST_AXIS, (Comparable[])new Boolean[]{alongFirst}).end();
    }

    public static void rotateDownFacingModel(ConfiguredModel.Builder<?> builder, Direction facing) {
        switch (facing) {
            case UP: {
                builder.rotationX(180);
                break;
            }
            case NORTH: {
                builder.rotationX(-90);
                break;
            }
            case SOUTH: {
                builder.rotationX(90);
                break;
            }
            case WEST: {
                builder.rotationX(90).rotationY(90);
                break;
            }
            case EAST: {
                builder.rotationX(90).rotationY(-90);
            }
        }
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> northFacing(String name) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, name));
            switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)) {
                case DOWN: {
                    builder.rotationX(90);
                    break;
                }
                case UP: {
                    builder.rotationX(-90);
                    break;
                }
                case SOUTH: {
                    builder.rotationY(180);
                    break;
                }
                case EAST: {
                    builder.rotationY(90);
                    break;
                }
                case WEST: {
                    builder.rotationY(-90);
                }
            }
            return builder.build();
        });
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> downFacing(String name) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, name));
            DataProviderUtilityImpl.rotateDownFacingModel(builder, (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_));
            return builder.build();
        });
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> upFacing(String name) {
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, name));
            switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)) {
                case DOWN: {
                    builder.rotationX(180);
                    break;
                }
                case NORTH: {
                    builder.rotationX(90);
                    break;
                }
                case SOUTH: {
                    builder.rotationX(-90);
                    break;
                }
                case EAST: {
                    builder.rotationX(90).rotationY(90);
                    break;
                }
                case WEST: {
                    builder.rotationX(90).rotationY(-90);
                }
            }
            return builder.build();
        });
    }

    public static NonNullBiConsumer<DataGenContext<Block, CircuitBoardBlock>, RegistrateBlockstateProvider> circuitBoard() {
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)DataProviderUtilityImpl.unchecked("circuit_board"));
    }

    public static NonNullBiConsumer<DataGenContext<Block, CircuitDesignTableBlock>, RegistrateBlockstateProvider> circuitDesignTable() {
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cubeBottomTop(ctx.getName(), prov.modLoc("block/circuit_design_table_side"), prov.mcLoc("block/spruce_planks"), prov.modLoc("block/circuit_design_table_top")));
    }

    public static NonNullBiConsumer<DataGenContext<Block, FuseHolderBlock>, RegistrateBlockstateProvider> fuseHolder() {
        return (ctx, prov) -> {
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.getEntry());
            for (Direction facing : BlockStateProperties.f_61372_.m_6908_()) {
                for (Boolean axis : CustomProperties.ALONG_FIRST_AXIS.m_6908_()) {
                    BlockState state = (BlockState)((BlockState)((FuseHolderBlock)ctx.getEntry()).m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing)).m_61124_((Property)CustomProperties.ALONG_FIRST_AXIS, (Comparable)axis);
                    DataProviderUtilityImpl.surfaceFacingTransforms(state, (TriConsumer<Integer, Integer, Boolean>)((TriConsumer)(x, y, vertical) -> {
                        ConfiguredModel.Builder part = builder.part();
                        if (vertical.booleanValue()) {
                            part.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/fuse_holder"));
                        } else {
                            part.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/fuse_holder_h"));
                        }
                        part.rotationX(x.intValue()).rotationY(y.intValue());
                        ((MultiPartBlockStateBuilder.PartBuilder)part.addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{facing}).condition((Property)CustomProperties.ALONG_FIRST_AXIS, (Comparable[])new Boolean[]{axis});
                    }));
                }
                ConfiguredModel.Builder part = builder.part();
                part.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/fuse"));
                DataProviderUtilityImpl.rotateDownFacingModel(part, facing);
                ((MultiPartBlockStateBuilder.PartBuilder)part.addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{facing}).condition(FuseHolderBlock.STATE, (Comparable[])new FuseState[]{FuseState.CLOSED});
                part = builder.part();
                part.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/fuse_blown"));
                DataProviderUtilityImpl.rotateDownFacingModel(part, facing);
                ((MultiPartBlockStateBuilder.PartBuilder)part.addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{facing}).condition(FuseHolderBlock.STATE, (Comparable[])new FuseState[]{FuseState.BLOWN});
            }
        };
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> cubeColumn(String side, String end) {
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cubeColumn(ctx.getName(), prov.modLoc(side), prov.modLoc(end)));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> cubeAllWithItem(String name) {
        return (ctx, prov) -> prov.simpleBlockWithItem((Block)ctx.getEntry(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc(name)));
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> simple(String model) {
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)DataProviderUtilityImpl.modModel(prov, model));
    }

    public static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> generated() {
        return (ctx, prov) -> prov.generated(ctx.lazy());
    }

    public static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> gauge(String model, String texture) {
        return (ctx, prov) -> ((ItemModelBuilder)prov.withExistingParent(ctx.getName(), prov.modLoc(model))).texture("2", prov.modLoc(texture));
    }

    public static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> itemWithParent(String parent) {
        return (ctx, prov) -> prov.withExistingParent(ctx.getName(), prov.modLoc(parent));
    }

    public static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> barrier() {
        return (ctx, prov) -> prov.withExistingParent(ctx.getName(), prov.mcLoc("item/barrier"));
    }
}

