/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.circuitboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5819;
import org.apache.commons.lang3.mutable.MutableInt;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlock;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.Component;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.circuits.thermal.ThermalBuilder;
import org.patryk3211.powergrid.circuits.thermal.ThermalUnit;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.FloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;

public class BakedCircuit {
    public final List<OwnedFloatingNode> externalNodes = new ArrayList<OwnedFloatingNode>();
    public final List<INode> internalNodes = new ArrayList<INode>();
    public final List<AbstractElectricWire> wires = new ArrayList<AbstractElectricWire>();
    public final List<TerminalBoundingBox> terminals = new ArrayList<TerminalBoundingBox>();
    public final List<ThermalUnit> thermalUnits = new ArrayList<ThermalUnit>();
    public final List<PlacedComponent> tickedComponents = new ArrayList<PlacedComponent>();
    private final Map<PlacedComponent, Function<Integer, FloatingNode>> padNodeProviderMap = new HashMap<PlacedComponent, Function<Integer, FloatingNode>>();
    private boolean isDamaged = false;
    private final CircuitBoardBlockEntity be;
    private boolean firstTick = true;

    protected BakedCircuit(CircuitBoardBlockEntity be) {
        this.be = be;
    }

    public FloatingNode getNode(CircuitSchematic.Node node) {
        return this.padNodeProviderMap.get(node.placed()).apply(node.pad());
    }

    private static void makePadNodes(BakedCircuit result, CircuitSchematic schematic, CircuitBoardBlockEntity be) {
        class_2338 pos = be.method_11016();
        class_243 offset = class_243.method_24954((class_2382)pos);
        for (PlacedComponent placed : schematic.components()) {
            HashSet<Integer> nodeIndexSet = new HashSet<Integer>();
            for (ComponentFootprint.PadData pad : placed.footprint().getPads().values()) {
                if (pad.nodeIndex() < 0) continue;
                nodeIndexSet.add(pad.nodeIndex());
            }
            boolean external = placed.component.emitExternalTerminals();
            int nodeOffset = external ? result.externalNodes.size() : result.internalNodes.size();
            for (int i = 0; i < nodeIndexSet.size(); ++i) {
                FloatingNode node;
                if (external) {
                    node = new OwnedFloatingNode(new BlockWireEndpoint(pos, nodeOffset + i));
                    result.externalNodes.add((OwnedFloatingNode)node);
                    continue;
                }
                node = new FloatingNode();
                result.internalNodes.add(node);
            }
            Function<Integer, FloatingNode> provider = external ? index -> result.externalNodes.get(index + nodeOffset) : index -> (FloatingNode)result.internalNodes.get(index + nodeOffset);
            result.padNodeProviderMap.put(placed, provider);
            ComponentCircuitBuilder builder = new ComponentCircuitBuilder(pos, provider, result.internalNodes, result.wires);
            placed.nodes.clear();
            placed.wires.clear();
            MutableInt thermalIndex = new MutableInt(0);
            ArrayList thermalBuilders = new ArrayList();
            ThermalBuilder.IEmitter thermalEmitter = () -> {
                ThermalBuilder thermalBuilder = new ThermalBuilder(placed.getUUID(), thermalIndex.getAndIncrement());
                thermalBuilders.add(thermalBuilder);
                return thermalBuilder;
            };
            placed.destroyed = false;
            placed.component.bake(placed, builder, thermalEmitter);
            ComponentFootprint footprint = placed.footprint();
            class_243 localPos = new class_243((double)(((float)placed.x + (float)footprint.getWidth() * 0.5f) / 16.0f), 0.125, (double)(((float)placed.y + (float)footprint.getHeight() * 0.5f) / 16.0f)).method_1023(0.5, 0.0, 0.5).method_1037((float)Math.PI * (float)CircuitBoardBlock.getAngleX(be.method_11010()) / 180.0f).method_1024((float)Math.PI * (float)CircuitBoardBlock.getAngleY(be.method_11010()) / 180.0f).method_1031(0.5, 0.0, 0.5).method_1019(offset);
            thermalBuilders.stream().map(b -> b.build().withPosition(localPos)).forEach(result.thermalUnits::add);
            result.tickedComponents.add(placed);
            if (!external) continue;
            List<TerminalBoundingBox> bbs = placed.component.terminals(placed);
            bbs.stream().map(bb -> bb.offset((float)placed.x / 16.0f, 0.125, (float)placed.y / 16.0f)).forEach(result.terminals::add);
        }
    }

    public static BakedCircuit from(CircuitSchematic schematic, CircuitBoardBlockEntity be) {
        BakedCircuit result = new BakedCircuit(be);
        BakedCircuit.makePadNodes(result, schematic, be);
        Collection<Collection<CircuitSchematic.Node>> bundles = schematic.findNodeBundles();
        for (Collection<CircuitSchematic.Node> bundle : bundles) {
            if (bundle.size() <= 1) continue;
            if (bundle.size() == 2) {
                Iterator<CircuitSchematic.Node> iter = bundle.iterator();
                CircuitSchematic.Node node1 = iter.next();
                CircuitSchematic.Node node2 = iter.next();
                float R = node1.getPadResistance() + node2.getPadResistance();
                ElectricWire wire = new ElectricWire(R, result.getNode(node1), result.getNode(node2));
                result.wires.add(wire);
                continue;
            }
            FloatingNode junctionNode = new FloatingNode();
            result.internalNodes.add(junctionNode);
            for (CircuitSchematic.Node node : bundle) {
                ElectricWire wire = new ElectricWire(node.getPadResistance(), result.getNode(node), junctionNode);
                result.wires.add(wire);
            }
        }
        return result;
    }

    public void write(class_2487 tag) {
        class_2487 thermalTag = new class_2487();
        for (ThermalUnit unit : this.thermalUnits) {
            unit.write(thermalTag);
        }
        tag.method_10566("Thermal", (class_2520)thermalTag);
    }

    public void read(class_2487 tag, boolean clientPacket) {
        if (tag.method_10545("Thermal")) {
            class_2487 thermalTag = tag.method_10562("Thermal");
            for (ThermalUnit unit : this.thermalUnits) {
                unit.read(thermalTag);
                if (!unit.hasOverheated()) continue;
                for (PlacedComponent placed : this.padNodeProviderMap.keySet()) {
                    if (!placed.uuid.equals(unit.getId())) continue;
                    placed.destroyed = true;
                    Component.modelChanged(this.be.method_11016());
                }
            }
        }
        this.isDamaged = false;
        if (!clientPacket) {
            return;
        }
        class_2487 schematic = tag.method_10562("Schematic");
        if (schematic.method_10545("Components")) {
            for (class_2520 generic : schematic.method_10554("Components", 10)) {
                class_2487 compound = (class_2487)generic;
                UUID id = compound.method_25926("UUID");
                for (PlacedComponent placed : this.tickedComponents) {
                    if (!placed.uuid.equals(id)) continue;
                    boolean changed = false;
                    class_2487 tagProperties = compound.method_10562("Properties");
                    for (ComponentProperty property : placed.component.getProperties()) {
                        class_2520 tagEntry = tagProperties.method_10580(property.id().toString());
                        Object readValue = property.read(tagEntry);
                        if (tagEntry == null || placed.get(property).equals(readValue)) continue;
                        placed.getEntry(property).setValueRaw(readValue);
                        changed = true;
                    }
                    if (!changed) continue;
                    placed.stateUpdated();
                }
            }
        }
    }

    public boolean isDamaged() {
        if (this.isDamaged) {
            return true;
        }
        for (ThermalUnit unit : this.thermalUnits) {
            if (!unit.hasOverheated()) continue;
            this.isDamaged = true;
            break;
        }
        return this.isDamaged;
    }

    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            return;
        }
        boolean client = this.be.method_10997().field_9236;
        if (ThermalBehaviour.shouldOverheat()) {
            for (ThermalUnit unit : this.thermalUnits) {
                boolean overheated = unit.hasOverheated();
                unit.tick(this.be.coolingFactorMultiplier);
                if (client) {
                    class_1937 world = this.be.method_10997();
                    class_5819 random = world.field_9229;
                    class_243 pos = unit.getPosition();
                    float x = (float)pos.method_10216() + (random.method_43057() - 0.5f) * 1.0f / 16.0f;
                    float y = (float)pos.method_10214() + (random.method_43057() - 0.5f) * 1.0f / 16.0f;
                    float z = (float)pos.method_10215() + (random.method_43057() - 0.5f) * 1.0f / 16.0f;
                    if (!unit.hasOverheated() && unit.getTemperature() >= unit.getOverheatTemperature() - 50.0f) {
                        float chance = (unit.getTemperature() - unit.getOverheatTemperature() + 100.0f) / 100.0f;
                        if (!(random.method_43057() < chance)) continue;
                        world.method_8406((class_2394)class_2398.field_11251, (double)x, (double)y, (double)z, 0.0, (double)0.05f, 0.0);
                        continue;
                    }
                    if (overheated || !unit.hasOverheated()) continue;
                    SparkParticleData.explodeParticles(world, x, y, z, class_2350.field_11036, 10);
                    ModdedSoundEvents.COMPONENT_EXPLODE.playAt(world, pos, 1.0f, random.method_43057() * 0.1f + 0.9f, true);
                    for (PlacedComponent placed2 : this.padNodeProviderMap.keySet()) {
                        if (!placed2.uuid.equals(unit.getId())) continue;
                        placed2.destroyed = true;
                        Component.modelChanged(this.be.method_11016());
                    }
                    continue;
                }
                if (overheated || !unit.hasOverheated()) continue;
                this.be.sendData();
            }
        }
        this.tickedComponents.removeIf(placed -> !placed.tick());
    }
}

