/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.circuitboard;

import com.simibubi.create.foundation.block.IBE;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.components.IInteractableComponent;
import org.patryk3211.powergrid.circuits.components.IRedstoneComponent;
import org.patryk3211.powergrid.circuits.components.properties.Orientation;
import org.patryk3211.powergrid.circuits.editor.CircuitBoardEditMenu;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.utility.Lang;

public class CircuitBoardBlock
extends ElectricBlock
implements IBE<CircuitBoardBlockEntity> {
    public static final class_2753 HORIZONTAL_FACING = class_2741.field_12481;
    public static final class_2758 ROTATION = class_2758.method_11867((String)"rotation", (int)0, (int)2);
    private static final class_265 SHAPE_PLATE = CircuitBoardBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public CircuitBoardBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{HORIZONTAL_FACING, ROTATION});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 face = ctx.method_8038();
        if (face.method_10166() == class_2350.class_2351.field_11052) {
            class_2350 player = ctx.method_8036() == null || !ctx.method_8036().method_5715() ? ctx.method_8042() : ctx.method_8042().method_10153();
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)HORIZONTAL_FACING, (Comparable)player)).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(face == class_2350.field_11036 ? 0 : 2));
        }
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(1))).method_11657((class_2769)HORIZONTAL_FACING, (Comparable)face.method_10153());
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        this.withBlockEntityDo((class_1922)world, pos, be -> {
            be.setSchematic(CircuitSchematic.fromStack(stack));
            be.setAdditionalData(stack.method_7969());
        });
        super.method_9567(world, pos, state, placer, stack);
    }

    private static class_265 rotate(class_265 shapeIn, float x, float y) {
        if (y == 0.0f && x == 0.0f) {
            return shapeIn;
        }
        MutableObject result = new MutableObject((Object)class_259.method_1073());
        class_243 center = new class_243(8.0, 8.0, 8.0);
        shapeIn.method_1089((x1, y1, z1, x2, y2, z2) -> {
            class_243 v1 = new class_243(x1, y1, z1).method_1021(16.0).method_1020(center);
            class_243 v2 = new class_243(x2, y2, z2).method_1021(16.0).method_1020(center);
            v1 = VecHelper.rotate((class_243)v1, (double)x, (class_2350.class_2351)class_2350.class_2351.field_11048);
            v1 = VecHelper.rotate((class_243)v1, (double)y, (class_2350.class_2351)class_2350.class_2351.field_11052).method_1019(center);
            v2 = VecHelper.rotate((class_243)v2, (double)x, (class_2350.class_2351)class_2350.class_2351.field_11048);
            v2 = VecHelper.rotate((class_243)v2, (double)y, (class_2350.class_2351)class_2350.class_2351.field_11052).method_1019(center);
            class_265 rotated = CircuitBoardBlock.method_9541((double)Math.min(v1.field_1352, v2.field_1352), (double)Math.min(v1.field_1351, v2.field_1351), (double)Math.min(v1.field_1350, v2.field_1350), (double)Math.max(v1.field_1352, v2.field_1352), (double)Math.max(v1.field_1351, v2.field_1351), (double)Math.max(v1.field_1350, v2.field_1350));
            result.setValue((Object)class_259.method_1084((class_265)((class_265)result.getValue()), (class_265)rotated));
        });
        return (class_265)result.getValue();
    }

    public static int getAngleX(class_2680 state) {
        if (!(state.method_26204() instanceof CircuitBoardBlock)) {
            return 0;
        }
        return (Integer)state.method_11654((class_2769)ROTATION) * 90;
    }

    public static int getAngleY(class_2680 state) {
        if (!(state.method_26204() instanceof CircuitBoardBlock)) {
            return 0;
        }
        int angle = switch ((class_2350)state.method_11654((class_2769)HORIZONTAL_FACING)) {
            case class_2350.field_11043 -> 0;
            case class_2350.field_11034 -> -90;
            case class_2350.field_11035 -> 180;
            case class_2350.field_11039 -> 90;
            default -> throw new IllegalStateException();
        };
        if ((Integer)state.method_11654((class_2769)ROTATION) == 2) {
            angle -= 180;
        }
        return angle;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        int x = CircuitBoardBlock.getAngleX(state);
        int y = CircuitBoardBlock.getAngleY(state);
        class_265[] shape = new class_265[]{CircuitBoardBlock.rotate(SHAPE_PLATE, x, y)};
        this.withBlockEntityDo(world, pos, be -> {
            class_265 shapeCopy = shape[0];
            for (int i = 0; i < be.terminalCount(); ++i) {
                ITerminalPlacement terminal = be.terminal(state, i);
                shapeCopy = class_259.method_1084((class_265)((TerminalBoundingBox)terminal).getShape(), (class_265)shapeCopy);
            }
            for (PlacedComponent placed : be.getComponents(IInteractableComponent.class)) {
                IInteractableComponent dynamic = (IInteractableComponent)((Object)placed.component);
                shapeCopy = class_259.method_1084((class_265)CircuitBoardBlock.rotate(dynamic.getShape(placed), x, y), (class_265)shapeCopy);
            }
            shape[0] = shapeCopy;
        });
        return shape[0];
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 stack = super.method_9574(world, pos, state);
        this.withBlockEntityDo(world, pos, be -> {
            class_2487 tag = new class_2487();
            tag.method_10566("Schematic", (class_2520)be.getSchematic().serializeNbt());
            stack.method_7980(tag);
        });
        return stack;
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        MutableInt output = new MutableInt();
        this.withBlockEntityDo(world, pos, be -> {
            for (PlacedComponent placed : be.getComponents(IRedstoneComponent.class)) {
                int level;
                IRedstoneComponent redstone = (IRedstoneComponent)((Object)placed.component);
                if (!redstone.isEmitter() || placed.has(Orientation.PROPERTY) && placed.get(Orientation.PROPERTY) != CircuitBoardBlock.getOrientation(state, direction.method_10153()) || (level = redstone.getEmittedLevel(placed)) <= output.getValue()) continue;
                output.setValue(level);
            }
        });
        return output.getValue();
    }

    @Nullable
    public static Orientation getOrientation(class_2680 state, class_2350 side) {
        Orientation orientation;
        class_2350 facing = (class_2350)state.method_11654((class_2769)HORIZONTAL_FACING);
        if ((Integer)state.method_11654((class_2769)ROTATION) == 1) {
            if (side == class_2350.field_11036) {
                return Orientation.UP;
            }
            if (side == class_2350.field_11033) {
                return Orientation.DOWN;
            }
            if (side == facing.method_10160()) {
                return Orientation.LEFT;
            }
            if (side == facing.method_10170()) {
                return Orientation.RIGHT;
            }
            return null;
        }
        if ((Integer)state.method_11654((class_2769)ROTATION) == 0) {
            orientation = switch (side) {
                case class_2350.field_11043 -> Orientation.UP;
                case class_2350.field_11034 -> Orientation.RIGHT;
                case class_2350.field_11035 -> Orientation.DOWN;
                case class_2350.field_11039 -> Orientation.LEFT;
                default -> null;
            };
        } else {
            switch (side) {
                case field_11043: {
                    Orientation orientation2 = Orientation.UP;
                    break;
                }
                case field_11034: {
                    Orientation orientation2 = Orientation.LEFT;
                    break;
                }
                case field_11035: {
                    Orientation orientation2 = Orientation.DOWN;
                    break;
                }
                case field_11039: {
                    Orientation orientation2 = Orientation.RIGHT;
                    break;
                }
                default: {
                    Orientation orientation2 = orientation = null;
                }
            }
        }
        if (orientation == null) {
            return null;
        }
        if ((Integer)state.method_11654((class_2769)ROTATION) == 0) {
            orientation = switch (facing) {
                case class_2350.field_11043 -> orientation;
                case class_2350.field_11035 -> orientation.getOpposite();
                case class_2350.field_11034 -> orientation.getCounterClockwise();
                case class_2350.field_11039 -> orientation.getClockwise();
                default -> throw new IllegalStateException();
            };
        } else {
            orientation = switch (facing) {
                case class_2350.field_11043 -> orientation;
                case class_2350.field_11035 -> orientation.getOpposite();
                case class_2350.field_11039 -> orientation.getCounterClockwise();
                case class_2350.field_11034 -> orientation.getClockwise();
                default -> throw new IllegalStateException();
            };
        }
        return orientation;
    }

    public static class_2350 getDirection(class_2680 state, Orientation orientation) {
        class_2350 dir;
        class_2350 facing = (class_2350)state.method_11654((class_2769)HORIZONTAL_FACING);
        if ((Integer)state.method_11654((class_2769)ROTATION) == 1) {
            if (orientation == Orientation.UP) {
                return class_2350.field_11036;
            }
            if (orientation == Orientation.DOWN) {
                return class_2350.field_11033;
            }
            if (orientation == Orientation.LEFT) {
                return facing.method_10160();
            }
            if (orientation == Orientation.RIGHT) {
                return facing.method_10170();
            }
            throw new IllegalStateException();
        }
        if ((Integer)state.method_11654((class_2769)ROTATION) == 0) {
            dir = switch (orientation) {
                default -> throw new IncompatibleClassChangeError();
                case Orientation.UP -> class_2350.field_11043;
                case Orientation.RIGHT -> class_2350.field_11034;
                case Orientation.DOWN -> class_2350.field_11035;
                case Orientation.LEFT -> class_2350.field_11039;
            };
            dir = switch ((class_2350)state.method_11654((class_2769)HORIZONTAL_FACING)) {
                case class_2350.field_11043 -> dir;
                case class_2350.field_11035 -> dir.method_10153();
                case class_2350.field_11034 -> dir.method_10170();
                case class_2350.field_11039 -> dir.method_10160();
                default -> throw new IllegalStateException();
            };
        } else {
            dir = switch (orientation) {
                default -> throw new IncompatibleClassChangeError();
                case Orientation.UP -> class_2350.field_11035;
                case Orientation.RIGHT -> class_2350.field_11034;
                case Orientation.DOWN -> class_2350.field_11043;
                case Orientation.LEFT -> class_2350.field_11039;
            };
            dir = switch ((class_2350)state.method_11654((class_2769)HORIZONTAL_FACING)) {
                case class_2350.field_11043 -> dir.method_10153();
                case class_2350.field_11035 -> dir;
                case class_2350.field_11034 -> dir.method_10160();
                case class_2350.field_11039 -> dir.method_10170();
                default -> throw new IllegalStateException();
            };
        }
        return dir;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        this.withBlockEntityDo((class_1922)world, pos, be -> {
            class_2338 dirVec = sourcePos.method_10059((class_2382)pos);
            class_2350 dir = class_2350.method_50026((int)dirVec.method_10263(), (int)dirVec.method_10264(), (int)dirVec.method_10260());
            if (dir == null) {
                return;
            }
            int power = world.method_49808(sourcePos, dir);
            for (PlacedComponent placed : be.getComponents(IRedstoneComponent.class)) {
                IRedstoneComponent redstone = (IRedstoneComponent)((Object)placed.component);
                if (!redstone.isReceiver()) continue;
                if (placed.has(Orientation.PROPERTY)) {
                    if (placed.get(Orientation.PROPERTY) != CircuitBoardBlock.getOrientation(state, dir)) continue;
                    redstone.receiveRedstone(placed, power);
                    continue;
                }
                redstone.receiveRedstone(placed, power);
            }
        });
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1269 beResult = this.onBlockEntityUse((class_1922)world, pos, be -> {
            class_243 hitLocalPos = hit.method_17784().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            hitLocalPos = VecHelper.rotateCentered((class_243)hitLocalPos, (double)(-CircuitBoardBlock.getAngleY(state)), (class_2350.class_2351)class_2350.class_2351.field_11052);
            hitLocalPos = VecHelper.rotateCentered((class_243)hitLocalPos, (double)(-CircuitBoardBlock.getAngleX(state)), (class_2350.class_2351)class_2350.class_2351.field_11048);
            Iterator<PlacedComponent> iterator = be.getComponents(IInteractableComponent.class).iterator();
            while (iterator.hasNext()) {
                PlacedComponent placed;
                IInteractableComponent dynamic = (IInteractableComponent)((Object)placed.component);
                placed = iterator.next();
                class_238 outline = dynamic.getShape(placed).method_1107().method_1014(0.03125);
                if (!outline.method_1006(hitLocalPos)) continue;
                return dynamic.use((CircuitBoardBlockEntity)be, placed, player);
            }
            if (player.method_7337() && player.method_5715()) {
                be.repairBroken();
                return class_1269.field_5812;
            }
            if (player.method_7337() && player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                if (player.method_6047().method_7960() && player.method_6079().method_7960()) {
                    MenuRegistry.openExtendedMenu((class_3222)sp, (class_3908)new class_3908(){
                        final /* synthetic */ CircuitBoardBlockEntity val$be;
                        {
                            this.val$be = circuitBoardBlockEntity;
                        }

                        public class_2561 method_5476() {
                            return class_2561.method_43470((String)"Circuit");
                        }

                        @Nullable
                        public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                            if (!player.method_7337()) {
                                return null;
                            }
                            return CircuitBoardEditMenu.create(i, inventory, this.val$be);
                        }
                    }, arg_0 -> ((CircuitBoardBlockEntity)be).sendToMenu(arg_0));
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5811;
        });
        if (beResult != class_1269.field_5811) {
            return beResult;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        CircuitSchematic schematic = CircuitSchematic.fromStack(stack);
        if (schematic != null && schematic.getName() != null) {
            tooltip.add((class_2561)Lang.translate("circuit_board.tooltip.schematic", new Object[0]).add(class_2561.method_43470((String)schematic.getName())).style(class_124.field_1080).component());
        }
        super.method_9568(stack, world, tooltip, options);
    }

    public Class<CircuitBoardBlockEntity> getBlockEntityClass() {
        return CircuitBoardBlockEntity.class;
    }

    public class_2591<? extends CircuitBoardBlockEntity> getBlockEntityType() {
        return (class_2591)ModdedBlockEntities.CIRCUIT_BOARD.get();
    }
}

