/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.circuitboard;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.circuits.circuitboard.BakedCircuit;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlock;
import org.patryk3211.powergrid.circuits.components.Component;
import org.patryk3211.powergrid.circuits.components.IComponentGoggleInformation;
import org.patryk3211.powergrid.circuits.components.ViaComponent;
import org.patryk3211.powergrid.circuits.components.properties.Orientation;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.ISchematicHolder;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.FloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.utility.ClientSideAccess;
import org.patryk3211.powergrid.utility.Lang;

public class CircuitBoardBlockEntity
extends ElectricBlockEntity
implements IElectric,
IHaveGoggleInformation,
ISchematicHolder {
    private CircuitSchematic schematic = new CircuitSchematic();
    private BakedCircuit baked;
    private final Map<Class<?>, Collection<PlacedComponent>> componentCache = new HashMap();
    private final Map<CircuitBoardBlockEntity, List<ElectricWire>> edgeViadWires = new HashMap<CircuitBoardBlockEntity, List<ElectricWire>>();
    private AirCurrent coolingAir;
    protected float coolingFactorMultiplier = 1.0f;

    public CircuitBoardBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void setSchematic(CircuitSchematic schematic) {
        if (this.field_11863.field_9236) {
            return;
        }
        if (schematic == null) {
            this.field_11863.method_22352(this.field_11867, false);
            return;
        }
        this.schematic = new CircuitSchematic(schematic);
        this.bakeCircuit();
        this.notifyUpdate();
    }

    public void setAdditionalData(class_2487 tag) {
        if (this.baked == null) {
            return;
        }
        this.baked.read(tag, false);
        this.notifyUpdate();
    }

    @Nullable
    private FloatingNode getViaAt(class_2350 sideIn, int edgePosition, Orientation edgeOut) {
        if (this.baked == null) {
            return null;
        }
        Orientation orientation = CircuitBoardBlock.getOrientation(this.method_11010(), sideIn);
        if (orientation == null) {
            return null;
        }
        if (edgeOut.positive() == orientation.positive()) {
            edgePosition = 15 - edgePosition;
        }
        for (PlacedComponent placed : this.getComponents(ViaComponent.class)) {
            boolean match;
            if (!(match = (switch (orientation) {
                default -> throw new IncompatibleClassChangeError();
                case Orientation.UP -> {
                    if (placed.x == edgePosition && placed.y == 0) {
                        yield true;
                    }
                    yield false;
                }
                case Orientation.DOWN -> {
                    if (placed.x == edgePosition && placed.y == 15) {
                        yield true;
                    }
                    yield false;
                }
                case Orientation.LEFT -> {
                    if (placed.x == 0 && placed.y == edgePosition) {
                        yield true;
                    }
                    yield false;
                }
                case Orientation.RIGHT -> placed.x == 15 && placed.y == edgePosition;
            }))) continue;
            return this.baked.getNode(new CircuitSchematic.Node(placed, 0));
        }
        return null;
    }

    private ElectricalNetwork unifyNetwork(ElectricBehaviour other) {
        ElectricalNetwork network;
        ElectricalNetwork net1 = this.electricBehaviour.getNetwork();
        ElectricalNetwork net2 = other.getNetwork();
        if (net1 == null && net2 == null) {
            network = GlobalElectricNetworks.getWorldNetworks(this.field_11863).newNetwork();
            this.electricBehaviour.joinNetwork(network);
            other.joinNetwork(network);
        } else if (net1 == null) {
            network = net2;
            this.electricBehaviour.joinNetwork(network);
        } else if (net2 == null) {
            network = net1;
            other.joinNetwork(network);
        } else if (net1 != net2) {
            if (net1.size() >= net2.size()) {
                network = net1;
                network.merge(net2);
            } else {
                network = net2;
                network.merge(net1);
            }
        } else {
            network = net1;
        }
        return network;
    }

    private ElectricWire makeWire(ElectricBehaviour eb2, IElectricNode node1, IElectricNode node2) {
        ElectricWire wire = new ElectricWire(0.002f, node1, node2);
        if (!this.electricBehaviour.isPaused() && !eb2.isPaused()) {
            ElectricalNetwork network = this.unifyNetwork(eb2);
            network.addWire(wire);
        }
        return wire;
    }

    private void processNeighbor(@NotNull CircuitBoardBlockEntity be, Orientation expectedOrientation) {
        for (PlacedComponent placed : this.getComponents(ViaComponent.class)) {
            int position;
            Orientation edge;
            if (placed.x == 0) {
                edge = Orientation.LEFT;
                position = placed.y;
            } else if (placed.y == 0) {
                edge = Orientation.UP;
                position = placed.x;
            } else if (placed.x == 15) {
                edge = Orientation.RIGHT;
                position = placed.y;
            } else {
                if (placed.y != 15) continue;
                edge = Orientation.DOWN;
                position = placed.x;
            }
            if (edge != expectedOrientation) continue;
            class_2350 dir = CircuitBoardBlock.getDirection(this.method_11010(), edge);
            FloatingNode viaNode = be.getViaAt(dir.method_10153(), position, edge);
            FloatingNode thisViaNode = this.baked.getNode(new CircuitSchematic.Node(placed, 0));
            if (viaNode == null || thisViaNode == null) continue;
            ElectricWire wire = this.makeWire(be.electricBehaviour, viaNode, thisViaNode);
            this.edgeViadWires.computeIfAbsent(be, $ -> new ArrayList()).add(wire);
            be.edgeViadWires.computeIfAbsent(this, $ -> new ArrayList()).add(wire);
        }
    }

    private void disconnectViad() {
        for (Map.Entry<CircuitBoardBlockEntity, List<ElectricWire>> entry : this.edgeViadWires.entrySet()) {
            entry.getKey().edgeViadWires.remove(this);
            entry.getValue().forEach(AbstractElectricWire::remove);
        }
        this.edgeViadWires.clear();
    }

    private void bakeCircuit() {
        this.componentCache.clear();
        this.disconnectViad();
        this.baked = BakedCircuit.from(this.schematic, this);
        for (PlacedComponent placed : this.schematic.components()) {
            placed.withWorld(() -> ((CircuitBoardBlockEntity)this).method_10997(), this.field_11867);
        }
        this.electricBehaviour.rebuildCircuit();
        if (this.field_11863 != null) {
            if (this.field_11863.field_9236) {
                Component.modelChanged(this.field_11867);
            }
            this.edgeConnect();
        }
    }

    private void edgeConnect() {
        this.disconnectViad();
        class_2680 state = this.method_11010();
        for (Orientation orientation : Orientation.values()) {
            class_2350 dir = CircuitBoardBlock.getDirection(state, orientation);
            Optional opt = this.field_11863.method_35230(this.field_11867.method_10093(dir), (class_2591)ModdedBlockEntities.CIRCUIT_BOARD.get());
            if (opt.isEmpty()) continue;
            CircuitBoardBlockEntity be = (CircuitBoardBlockEntity)opt.get();
            class_2680 neighborState = be.method_11010();
            if ((Integer)state.method_11654((class_2769)CircuitBoardBlock.ROTATION) == 1) {
                if ((Integer)neighborState.method_11654((class_2769)CircuitBoardBlock.ROTATION) != 1 || state.method_11654((class_2769)CircuitBoardBlock.HORIZONTAL_FACING) != neighborState.method_11654((class_2769)CircuitBoardBlock.HORIZONTAL_FACING)) continue;
                this.processNeighbor(be, orientation);
                continue;
            }
            if (!((Integer)state.method_11654((class_2769)CircuitBoardBlock.ROTATION)).equals(neighborState.method_11654((class_2769)CircuitBoardBlock.ROTATION))) continue;
            this.processNeighbor(be, orientation);
        }
    }

    public void initialize() {
        super.initialize();
        this.edgeConnect();
    }

    public void tick() {
        super.tick();
        if (this.coolingAir != null && (this.coolingAir.source.isSourceRemoved() || this.coolingAir.source.getSpeed() == 0.0f)) {
            this.noCooling();
        }
        if (this.baked != null) {
            this.baked.tick();
            if (!this.field_11863.field_9236) {
                this.method_5431();
            }
        }
    }

    @Override
    public void paused() {
        for (Map.Entry<CircuitBoardBlockEntity, List<ElectricWire>> entry : this.edgeViadWires.entrySet()) {
            ElectricBehaviour other = entry.getKey().electricBehaviour;
            if (other.isPaused()) continue;
            entry.getValue().forEach(AbstractElectricWire::remove);
        }
    }

    @Override
    public void unpaused() {
        for (Map.Entry<CircuitBoardBlockEntity, List<ElectricWire>> entry : this.edgeViadWires.entrySet()) {
            ElectricBehaviour other = entry.getKey().electricBehaviour;
            if (other.isPaused()) continue;
            ElectricalNetwork network = this.unifyNetwork(other);
            entry.getValue().forEach(network::addWire);
        }
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        tag.method_10566("Schematic", (class_2520)this.schematic.serializeNbt());
        if (this.baked != null) {
            this.baked.write(tag);
        }
        super.write(tag, clientPacket);
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        if (!tag.method_10545("Schematic")) {
            this.field_11863.method_22352(this.field_11867, false);
            return;
        }
        super.read(tag, clientPacket);
        if (!clientPacket || tag.method_10577("Rebuild") || this.baked == null) {
            this.schematic.deserializeNbt(tag.method_10562("Schematic"));
            this.bakeCircuit();
        }
        if (this.baked != null) {
            this.baked.read(tag, clientPacket);
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        if (this.baked != null) {
            builder.setTo(this.baked);
        }
    }

    @Override
    public int terminalCount() {
        return this.baked == null ? 0 : this.baked.externalNodes.size();
    }

    @Override
    public ITerminalPlacement terminal(class_2680 state, int index) {
        if (this.baked == null) {
            return null;
        }
        if (index < 0 || index >= this.baked.terminals.size()) {
            return null;
        }
        TerminalBoundingBox terminal = this.baked.terminals.get(index);
        return terminal.rotateAroundX(-CircuitBoardBlock.getAngleX(state)).rotateAroundY(-CircuitBoardBlock.getAngleY(state));
    }

    @Override
    public CircuitSchematic getSchematic() {
        return this.schematic;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        String name = this.schematic.getName();
        return name == null ? "missing" : name;
    }

    @Override
    public void setSchematicName(String name) {
        this.schematic.setName(name);
        this.notifyUpdate();
    }

    public <T> Collection<PlacedComponent> getComponents(Class<T> ofClass) {
        if (this.componentCache.containsKey(ofClass)) {
            return this.componentCache.get(ofClass);
        }
        ArrayList<PlacedComponent> components = new ArrayList<PlacedComponent>();
        for (PlacedComponent placed : this.schematic.components()) {
            if (!ofClass.isInstance(placed.component)) continue;
            components.add(placed);
        }
        this.componentCache.put(ofClass, components);
        return components;
    }

    @Override
    public void remove() {
        this.disconnectViad();
        super.remove();
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (this.baked == null) {
            return false;
        }
        MutableBoolean hasInfo = new MutableBoolean(false);
        if (this.baked.isDamaged()) {
            Lang.translate("gui.damage_header", new Object[0]).forGoggles(tooltip);
            Lang.translate("gui.circuit_board.damage_body", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
                class_1657 player = ClientSideAccess.player();
                if (!player.method_7337()) {
                    return;
                }
                Lang.translate("gui.circuit_board.damage_creative_repair", new Object[0]).style(class_124.field_1063).forGoggles(tooltip);
            });
            hasInfo.setTrue();
        }
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
            class_239 hit = ClientSideAccess.getHitResult();
            class_243 hitLocalPos = hit.method_17784().method_1023((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
            hitLocalPos = VecHelper.rotateCentered((class_243)hitLocalPos, (double)(-CircuitBoardBlock.getAngleY(this.method_11010())), (class_2350.class_2351)class_2350.class_2351.field_11052);
            hitLocalPos = VecHelper.rotateCentered((class_243)hitLocalPos, (double)(-CircuitBoardBlock.getAngleX(this.method_11010())), (class_2350.class_2351)class_2350.class_2351.field_11048);
            for (PlacedComponent placed : this.getComponents(IComponentGoggleInformation.class)) {
                IComponentGoggleInformation info;
                if (!(hitLocalPos.field_1352 * 16.0 >= (double)placed.x) || !(hitLocalPos.field_1350 * 16.0 >= (double)placed.y) || !(hitLocalPos.field_1352 * 16.0 < (double)(placed.x + placed.footprint().getWidth())) || !(hitLocalPos.field_1350 * 16.0 < (double)(placed.y + placed.footprint().getHeight())) || !(info = (IComponentGoggleInformation)((Object)placed.component)).addToGoggleTooltip(placed, tooltip, isPlayerSneaking)) continue;
                hasInfo.setTrue();
            }
        });
        return hasInfo.getValue();
    }

    public BakedCircuit getBaked() {
        return this.baked;
    }

    public void setCoolingMultiplier(AirCurrent current, float value) {
        this.coolingFactorMultiplier = value;
        this.coolingAir = current;
    }

    public void noCooling() {
        this.coolingFactorMultiplier = 1.0f;
        this.coolingAir = null;
    }

    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867);
    }

    public void repairBroken() {
        if (this.baked != null && this.baked.isDamaged()) {
            this.bakeCircuit();
            this.notifyUpdate();
        }
    }
}

