/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components.properties;

import net.minecraft.class_2494;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;

public class FloatProperty
extends ComponentProperty<Float> {
    private final float defaultValue;
    private final float min;
    private final float max;

    public FloatProperty(String namespace, String name, float defaultValue, float min, float max) {
        super(namespace, name);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
    }

    protected float limit(float value) {
        if (value < this.min) {
            return this.min;
        }
        if (value > this.max) {
            return this.max;
        }
        return value;
    }

    @Override
    public Float parse(String str) throws NumberFormatException {
        float value = Float.parseFloat(str);
        return Float.valueOf(this.limit(value));
    }

    @Override
    public String toString(Float value) {
        return Float.toString(value.floatValue());
    }

    @Override
    public Float read(@Nullable class_2520 element) {
        if (element == null) {
            return Float.valueOf(this.defaultValue);
        }
        if (element.method_10711() != 5) {
            return Float.valueOf(this.defaultValue);
        }
        float value = ((class_2494)element).method_10700();
        return Float.valueOf(this.limit(value));
    }

    @Override
    public class_2520 write(Float value) {
        return class_2494.method_23244((float)value.floatValue());
    }

    @Override
    public Float defaultValue() {
        return Float.valueOf(this.defaultValue);
    }
}

