/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.collections;

import com.simibubi.create.api.stress.BlockStressValues;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.createmod.catnip.config.ConfigBase;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.fabric.ModdedConfigsImpl;
import org.patryk3211.powergrid.config.CCommon;
import org.patryk3211.powergrid.config.CServer;
import org.patryk3211.powergrid.config.CStress;
import org.patryk3211.powergrid.config.ResistanceValues;
import org.patryk3211.powergrid.config.ThermalValues;
import org.patryk3211.powergrid.config.WireValues;

public class ModdedConfigs {
    public static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    private static CServer server;
    private static CCommon common;

    public static CServer server() {
        return server;
    }

    public static CCommon common() {
        return common;
    }

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll(builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerPlatform() {
        ModdedConfigsImpl.registerPlatform();
    }

    public static void register() {
        server = ModdedConfigs.register(CServer::new, ModConfig.Type.SERVER);
        common = ModdedConfigs.register(CCommon::new, ModConfig.Type.COMMON);
        ModdedConfigs.registerPlatform();
        CStress stress = ModdedConfigs.server().kinetics.stressValues;
        BlockStressValues.IMPACTS.registerProvider(stress::getImpact);
        BlockStressValues.CAPACITIES.registerProvider(stress::getCapacity);
        ResistanceValues.register(ModdedConfigs.server.electricity.resistance);
        ThermalValues.register(ModdedConfigs.server.electricity.thermal);
        WireValues.register(ModdedConfigs.server.electricity.wires);
    }

    public static void onLoad(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onReload();
        }
        if (modConfig.getType() == ModConfig.Type.SERVER) {
            PowerGrid.LOGGER.warn("Server config reloaded, this can cause unexpected behaviour if done during gameplay!");
        }
    }

    public static boolean logsEnabled() {
        return (Boolean)ModdedConfigs.common.lotsOfLogs.get();
    }
}

