/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.collections;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllSoundEvents;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;

public class ModdedSoundEvents {
    public static final Map<class_2960, AllSoundEvents.SoundEntry> ALL = new HashMap<class_2960, AllSoundEvents.SoundEntry>();
    public static final AllSoundEvents.SoundEntry LV_SWITCH_CLICK = ModdedSoundEvents.create("lv_switch_click").subtitle("Switch clicks").playExisting(class_3417.field_14962).category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry MV_SWITCH_CLICK = ModdedSoundEvents.create("mv_switch_click").subtitle("Switch clicks").playExisting(class_3417.field_15131).category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry HV_SWITCH_CONNECT = ModdedSoundEvents.create("hv_switch_connect").subtitle("Switch connected").playExisting(() -> ((AllSoundEvents.SoundEntry)AllSoundEvents.CONTRAPTION_DISASSEMBLE).getMainEvent(), 0.5f, 0.75f).category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry HV_SWITCH_DISCONNECT = ModdedSoundEvents.create("hv_switch_disconnect").subtitle("Switch disconnected").playExisting(() -> ((AllSoundEvents.SoundEntry)AllSoundEvents.CONTRAPTION_ASSEMBLE).getMainEvent(), 0.5f, 0.75f).category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry CONTACTOR_ON = ModdedSoundEvents.create("contactor_on").subtitle("Contactor connects").category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry CONTACTOR_OFF = ModdedSoundEvents.create("contactor_off").subtitle("Contactor disconnects").category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry WIRE_CUT = ModdedSoundEvents.create("wire_cut").subtitle("Wire cut").playExisting(class_3417.field_14975, 0.75f, 1.25f).category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry MAGNETIZING = ModdedSoundEvents.create("magnetizing").subtitle("Magnetizing").addVariant("magnetizing").category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry ELECTROZAPPER_SHOOT = ModdedSoundEvents.create("electrozapper_shoot").subtitle("Electro-Zapper bzzzts").category(class_3419.field_15248).build();
    public static final AllSoundEvents.SoundEntry UI_CLICK = ModdedSoundEvents.create("ui.click").noSubtitle().playExisting((class_6880)class_3417.field_15015).build();
    public static final AllSoundEvents.SoundEntry UI_COMPONENT_ROTATE = ModdedSoundEvents.create("ui.component_rotate").noSubtitle().playExisting(class_3417.field_15038, 0.75f, 0.75f).build();
    public static final AllSoundEvents.SoundEntry UI_PLACE_TRACE = ModdedSoundEvents.create("ui.place_trace").noSubtitle().playExisting(class_3417.field_15167, 0.75f, 1.75f).build();
    public static final AllSoundEvents.SoundEntry UI_DELETE_AREA = ModdedSoundEvents.create("ui.delete_area").noSubtitle().playExisting(class_3417.field_14770, 0.5f, 1.0f).build();
    public static final AllSoundEvents.SoundEntry UI_PLACE_COMPONENT = ModdedSoundEvents.create("ui.place_component").noSubtitle().playExisting(class_3417.field_14667, 0.5f, 1.0f).build();
    public static final AllSoundEvents.SoundEntry UI_FAIL = ModdedSoundEvents.create("ui.action.fail").noSubtitle().playExisting((class_3414)class_3417.field_14624.comp_349(), 1.0f, 0.5f).build();
    public static final AllSoundEvents.SoundEntry UI_SELECT_COMPONENT = ModdedSoundEvents.create("ui.select_component").noSubtitle().playExisting((class_3414)class_3417.field_15015.comp_349(), 1.0f, 1.0f).build();
    public static final AllSoundEvents.SoundEntry RELAY_CLICK = ModdedSoundEvents.create("relay_click").subtitle("Relay clicks").playExisting(class_3417.field_14962).category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry COMPONENT_EXPLODE = ModdedSoundEvents.create("component_explode").subtitle("Component pops").playExisting(class_3417.field_14917, 0.25f, 2.0f).category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry FUSE_POPS = ModdedSoundEvents.create("fuse_pops").subtitle("Fuse pops").playExisting(class_3417.field_14917, 0.5f, 1.6f).category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry MICROSWITCH_ON = ModdedSoundEvents.create("uswitch_on").subtitle("Switch clicks").playExisting(class_3417.field_14699, 1.0f, 2.0f).category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry MICROSWITCH_OFF = ModdedSoundEvents.create("uswitch_off").subtitle("Switch clicks").playExisting(class_3417.field_15105, 1.0f, 2.0f).category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry MICROBUTTON_ON = ModdedSoundEvents.create("ubutton_on").subtitle("Button clicks").playExisting(class_3417.field_14699, 0.75f, 2.0f).category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry MICROBUTTON_OFF = ModdedSoundEvents.create("ubutton_off").subtitle("Button clicks").playExisting(class_3417.field_15105, 0.75f, 2.0f).category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry TRANSFORMER_HUM = ModdedSoundEvents.create("transformer").subtitle("Transformer hum").category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry GENERATOR = ModdedSoundEvents.create("generator").subtitle("Generator spinning").category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry ALARM_BELL = ModdedSoundEvents.create("alarm_bell").subtitle("Alarm bell rings").category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry ALARM_BELL_END = ModdedSoundEvents.create("alarm_bell_end").noSubtitle().category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry FUSE_INSTALL = ModdedSoundEvents.create("fuse_install").subtitle("Fuse installed").playExisting(class_3417.field_14667, 0.8f, 0.7f).category(class_3419.field_15245).build();
    public static final AllSoundEvents.SoundEntry WIRE_BURNED = ModdedSoundEvents.create("wire_burned").subtitle("Wire burned").playExisting(class_3417.field_15102, 0.2f, 2.0f).category(class_3419.field_15254).build();

    private static SoundEntryBuilder create(String name) {
        return ModdedSoundEvents.create(PowerGrid.asResource(name));
    }

    public static SoundEntryBuilder create(class_2960 id) {
        return new SoundEntryBuilder(id);
    }

    public static void prepare() {
        for (AllSoundEvents.SoundEntry entry : ALL.values()) {
            entry.prepare();
        }
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (AllSoundEvents.SoundEntry entry : ALL.values()) {
            if (!entry.hasSubtitle()) continue;
            consumer.accept(entry.getSubtitleKey(), entry.getSubtitle());
        }
    }

    public static class_2405 provider(class_7784 output) {
        return new SoundEntryProvider(output);
    }

    public static class SoundEntryBuilder
    extends AllSoundEvents.SoundEntryBuilder {
        public SoundEntryBuilder(class_2960 id) {
            super(id);
        }

        public AllSoundEvents.SoundEntryBuilder addVariant(String name) {
            return this.addVariant(PowerGrid.asResource(name));
        }

        public AllSoundEvents.SoundEntry build() {
            AllSoundEvents.SoundEntry entry = super.build();
            ALL.put(entry.getId(), entry);
            return entry;
        }
    }

    private static class SoundEntryProvider
    implements class_2405 {
        private final class_7784 output;

        public SoundEntryProvider(class_7784 output) {
            this.output = output;
        }

        @NotNull
        public CompletableFuture<?> method_10319(@NotNull class_7403 cache) {
            return this.generate(this.output.method_45971(), cache);
        }

        @NotNull
        public String method_10321() {
            return "Power Grid's Custom Sounds";
        }

        public CompletableFuture<?> generate(Path path, class_7403 cache) {
            path = path.resolve("assets/powergrid");
            JsonObject json = new JsonObject();
            ALL.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((AllSoundEvents.SoundEntry)entry.getValue()).write(json));
            return class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
        }
    }
}

