/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedTags;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.electricity.wire.HangingWireEntity;
import org.patryk3211.powergrid.electricity.wire.IWire;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireItem;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.PlayerUtilities;

public interface IElectric
extends IWrenchable {
    default public int terminalIndexAt(class_2680 state, class_243 pos) {
        for (int i = 0; i < this.terminalCount(); ++i) {
            ITerminalPlacement terminal = this.terminal(state, i);
            if (terminal == null || !terminal.check(pos)) continue;
            return i;
        }
        return -1;
    }

    default public ITerminalPlacement terminalAt(class_2680 state, class_243 pos) {
        for (int i = 0; i < this.terminalCount(); ++i) {
            ITerminalPlacement terminal = this.terminal(state, i);
            if (terminal == null || !terminal.check(pos)) continue;
            return terminal;
        }
        return null;
    }

    public int terminalCount();

    default public boolean accepts(class_1799 wireStack) {
        return wireStack.method_31573(ModdedTags.Item.LIGHT_WIRES.tag);
    }

    public ITerminalPlacement terminal(class_2680 var1, int var2);

    default public class_1269 onWire(class_2680 state, class_1838 context) {
        class_1799 stack = context.method_8041();
        class_2338 pos = context.method_8037();
        int terminal = this.terminalIndexAt(state, context.method_17698().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
        if (terminal >= 0) {
            if (!this.accepts(context.method_8041())) {
                IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_incorrect_wire_type", new Object[0]).style(class_124.field_1061).component());
                return class_1269.field_5814;
            }
            if (stack.method_7985()) {
                IWireEndpoint endpoint = WireEndpointType.deserialize(stack.method_7969());
                if (endpoint == null) {
                    return class_1269.field_5814;
                }
                class_1269 result = IElectric.makeConnection(context.method_8045(), endpoint, new BlockWireEndpoint(pos, terminal), context);
                if (result.method_23665()) {
                    stack.method_7980(null);
                }
                return result;
            }
            BlockWireEndpoint endpoint = new BlockWireEndpoint(pos, terminal);
            class_2487 tag = endpoint.serialize();
            stack.method_7980(tag);
            IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_next", new Object[0]).style(class_124.field_1080).component());
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Nullable
    default public ElectricBehaviour getBehaviour(class_1937 world, class_2338 pos, class_2680 state) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof SmartBlockEntity) {
            SmartBlockEntity smartEntity = (SmartBlockEntity)blockEntity;
            return (ElectricBehaviour)smartEntity.getBehaviour(ElectricBehaviour.TYPE);
        }
        return null;
    }

    @Nullable
    public static IElectric getAt(class_1937 world, class_2338 pos) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof IElectric) {
            IElectric electric = (IElectric)be;
            return electric;
        }
        class_2680 state = world.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof IElectric) {
            IElectric electric = (IElectric)class_22482;
            return electric;
        }
        return null;
    }

    @NotNull
    public static class_243 getTerminalPos(class_1937 world, class_2338 position, int terminalIndex) {
        IElectric electric = IElectric.getAt(world, position);
        if (electric == null) {
            return position.method_46558();
        }
        class_2680 state = world.method_8320(position);
        ITerminalPlacement terminal = electric.terminal(state, terminalIndex);
        if (terminal == null) {
            return position.method_46558();
        }
        class_243 origin = terminal.getOrigin();
        return new class_243((double)position.method_10263() + origin.field_1352, (double)position.method_10264() + origin.field_1351, (double)position.method_10260() + origin.field_1350);
    }

    public static void sendMessage(class_1838 context, class_2561 text) {
        if (context.method_8036() != null) {
            context.method_8036().method_7353(text, true);
        }
    }

    public static class_1269 makeConnection(class_1937 world, IWireEndpoint endpoint1, IWireEndpoint endpoint2, class_1838 context) {
        if (endpoint1.type() == WireEndpointType.BLOCK && endpoint2.type() == WireEndpointType.BLOCK) {
            return IElectric.makeHangingWireConnection(world, (BlockWireEndpoint)endpoint1, (BlockWireEndpoint)endpoint2, context);
        }
        class_1271<BlockWireEntity> result = WireItem.connect(world, context.method_8041(), context.method_8036(), endpoint1, endpoint2);
        return result.method_5467();
    }

    public static class_1269 makeHangingWireConnection(class_1937 world, BlockWireEndpoint endpoint1, BlockWireEndpoint endpoint2, class_1838 context) {
        ElectricBehaviour behaviour1 = endpoint1.getElectricBehaviour(world);
        ElectricBehaviour behaviour2 = endpoint2.getElectricBehaviour(world);
        if (behaviour1 == null || behaviour2 == null) {
            IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_failed", new Object[0]).style(class_124.field_1061).component());
            PowerGrid.LOGGER.error("Connection failed, at least one behaviour is null");
            return class_1269.field_5814;
        }
        OwnedFloatingNode node1 = endpoint1.getNode(world);
        OwnedFloatingNode node2 = endpoint2.getNode(world);
        if (node1 == null || node2 == null || node1 == node2) {
            IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_failed", new Object[0]).style(class_124.field_1061).component());
            PowerGrid.LOGGER.error("Connection failed, nodes: ({}, {})", (Object)node1, (Object)node2);
            return class_1269.field_5814;
        }
        if (behaviour1.hasConnection(endpoint1, endpoint2) || behaviour2.hasConnection(endpoint2, endpoint1)) {
            IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_exists", new Object[0]).style(class_124.field_1061).component());
            return class_1269.field_5814;
        }
        class_243 terminal1Pos = endpoint1.getExactPosition(world);
        class_243 terminal2Pos = endpoint2.getExactPosition(world);
        class_1799 stack = context.method_8041();
        if (!1.$assertionsDisabled && !(stack.method_7909() instanceof IWire)) {
            throw new AssertionError();
        }
        IWire item = (IWire)stack.method_7909();
        class_2487 tag = stack.method_7969();
        if (!1.$assertionsDisabled && tag == null) {
            throw new AssertionError();
        }
        float distance = (float)terminal1Pos.method_1022(terminal2Pos);
        if (distance > item.getMaximumLength()) {
            IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_too_long", new Object[0]).style(class_124.field_1061).component());
            return class_1269.field_5814;
        }
        int requiredItemCount = Math.max(Math.round(distance), 1);
        if (!PlayerUtilities.hasEnoughItems(context.method_8036(), stack, requiredItemCount)) {
            IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_missing_items", new Object[0]).style(class_124.field_1061).component());
            return class_1269.field_5814;
        }
        if (!HangingWireEntity.checkClearance(world, endpoint1.getExactPosition(world), endpoint2.getExactPosition(world))) {
            return class_1269.field_5814;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_3218 serverWorld = (class_3218)world;
        HangingWireEntity entity = HangingWireEntity.create((class_1937)serverWorld, endpoint1, endpoint2, new class_1799(stack.method_41409(), requiredItemCount), null);
        if (context.method_8036() != null) {
            class_1792 class_17922;
            class_1799 offItem = context.method_8036().method_6079();
            if (item.canBeColored() && (class_17922 = offItem.method_7909()) instanceof class_1769) {
                class_1769 dye = (class_1769)class_17922;
                entity.setColor(dye.method_7802());
            }
        }
        if (!serverWorld.method_30736((class_1297)entity)) {
            PowerGrid.LOGGER.error("Failed to spawn new connection wire entity.");
            IElectric.sendMessage(context, (class_2561)Lang.translate("message.connection_failed", new Object[0]).style(class_124.field_1061).component());
            return class_1269.field_5814;
        }
        if (context.method_8036() == null || !context.method_8036().method_7337()) {
            stack.method_7934(requiredItemCount);
        }
        return class_1269.field_5812;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

