/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.basinheater;

import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.basinheater.BasinHeaterBlock;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;

public class BasinHeaterBlockEntity
extends ElectricBlockEntity {
    private ElectricWire coil;
    private BlazeBurnerBlock.HeatLevel state;

    public BasinHeaterBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.state = (BlazeBurnerBlock.HeatLevel)state.method_11654(BasinHeaterBlock.HEAT_LEVEL);
    }

    public void setState(BlazeBurnerBlock.HeatLevel newState) {
        assert (this.field_11863 != null);
        if (this.state != newState) {
            this.state = newState;
            this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657(BasinHeaterBlock.HEAT_LEVEL, (Comparable)this.state));
        }
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        Double I = (Double)ModdedConfigs.server().electricity.basinHeaterCurrent.get();
        double power = I * I * (double)this.resistance("idle");
        float factor = (float)(power / 578.0);
        return ThermalBehaviour.always(this, 2.0f, factor, 1400.0f);
    }

    public boolean mixerRunning() {
        class_2586 be = this.field_11863.method_8321(this.field_11867.method_10086(3));
        if (!(be instanceof MechanicalMixerBlockEntity)) {
            return false;
        }
        MechanicalMixerBlockEntity mixer = (MechanicalMixerBlockEntity)be;
        return mixer.running;
    }

    public void tick() {
        this.applyPower(this.coil);
        super.tick();
        if (this.thermalBehaviour == null) {
            PowerGrid.LOGGER.warn("Basin heater should always have a thermal behaviour");
            return;
        }
        this.coil.setResistance(this.mixerRunning() ? (double)this.resistance("mixing") : (double)this.resistance("idle"));
        float T = this.thermalBehaviour.getTemperature();
        float dissipation = 0.005625f * T - 1.625f;
        if (this.mixerRunning()) {
            double I = (Double)ModdedConfigs.server().electricity.basinHeaterCurrent.get() * 2.0;
            double power = I * I * (double)(this.resistance("idle") - this.resistance("mixing"));
            dissipation += (float)(power / 978.0);
        }
        this.thermalBehaviour.setDissipationFactor(dissipation);
        if (T < 600.0f) {
            this.setState(BlazeBurnerBlock.HeatLevel.NONE);
        } else if (T < 1000.0f) {
            this.setState(BlazeBurnerBlock.HeatLevel.KINDLED);
        } else {
            this.setState(BlazeBurnerBlock.HeatLevel.SEETHING);
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.coil = builder.connect(this.resistance("idle"), builder.terminalNode(0), builder.terminalNode(1));
    }
}

