/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.battery;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.battery.AbstractBatteryBlock;
import org.patryk3211.powergrid.electricity.battery.BatterySpec;
import org.patryk3211.powergrid.electricity.sim.node.VoltageSourceCoupling;

public class BatteryBlockEntity
extends ElectricBlockEntity {
    protected VoltageSourceCoupling sourceCoupling;
    protected final BatterySpec spec;
    protected double capacity;
    protected double energy;
    protected boolean refreshLinks;

    public BatteryBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.spec = ((AbstractBatteryBlock)state.method_26204()).getSpec();
        this.capacity = this.spec.getMaxCharge();
        this.energy = this.spec.getInitialCharge();
        this.updateParameters();
        this.setLazyTickRate(20);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    public void updateParameters() {
        if (this.energy <= 0.0) {
            return;
        }
        float chargeLevel = (float)(this.energy / this.capacity);
        this.sourceCoupling.setVoltage(this.spec.calculateVoltage(chargeLevel));
        this.sourceCoupling.setResistance(this.spec.calculateResistance(chargeLevel));
    }

    public float calculatePower() {
        return -this.sourceCoupling.getCurrent() * this.sourceCoupling.getVoltage();
    }

    public void tick() {
        if (this.sourceCoupling != null) {
            float I = this.sourceCoupling.getCurrent();
            if (this.thermalBehaviour != null && this.sourceCoupling.isConverged()) {
                this.thermalBehaviour.applyTickPower(I * I * this.sourceCoupling.getResistance());
            }
        }
        super.tick();
        if (this.sourceCoupling == null) {
            return;
        }
        float power = this.calculatePower();
        if (Math.abs(power) > 0.05f) {
            this.refreshLinks = true;
        }
        this.energy -= (double)(power * 0.05f);
        if (this.energy <= 0.0) {
            this.energy = 0.0;
            this.sourceCoupling.setVoltage(0.0f);
            return;
        }
        if (this.energy >= this.capacity) {
            this.energy = this.capacity;
        }
        this.method_5431();
        this.updateParameters();
    }

    public void lazyTick() {
        super.lazyTick();
        this.sendData();
        if (this.refreshLinks) {
            this.refreshLinks = false;
            DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, (class_2338)this.field_11867);
        }
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10549("Energy", this.energy);
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.energy = tag.method_10574("Energy");
        this.updateParameters();
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.sourceCoupling = builder.addInternalNode(VoltageSourceCoupling.class, builder.terminalNode(0), builder.terminalNode(1), Float.valueOf(0.5f));
    }

    public void setEnergy(double energy) {
        this.energy = energy;
        this.updateParameters();
        this.notifyUpdate();
    }

    public double getCapacity() {
        return this.capacity;
    }

    public double getEnergy() {
        return this.energy;
    }
}

