/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.creative;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import org.patryk3211.powergrid.collections.ModdedBlocks;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.creative.CreativeSourceValueBehaviour;
import org.patryk3211.powergrid.electricity.sim.node.CurrentSourceNode;
import org.patryk3211.powergrid.electricity.sim.node.FloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.VoltageSourceCoupling;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public class CreativeSourceBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    private ScrollValueBehaviour value;
    private CurrentSourceNode currentSourceNode;
    private VoltageSourceCoupling voltageSourceNode;
    private boolean overwrite = false;
    private boolean voltageSource;

    public CreativeSourceBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        float multiplier;
        super.addBehaviours(behaviours);
        class_5250 label = null;
        if (this.method_11010().method_27852((class_2248)ModdedBlocks.CREATIVE_VOLTAGE_SOURCE.get())) {
            label = Lang.translateDirect("devices.creative.voltage", new Object[0]);
            multiplier = 1.0f;
        } else if (this.method_11010().method_27852((class_2248)ModdedBlocks.CREATIVE_CURRENT_SOURCE.get())) {
            label = Lang.translateDirect("devices.creative.current", new Object[0]);
            multiplier = 0.1f;
        } else {
            multiplier = 0.0f;
        }
        this.value = new CreativeSourceValueBehaviour((class_2561)label, this, multiplier, (ValueBoxTransform)new CreativeSourceBoxTransform());
        this.value.withCallback(i -> {
            if (!this.overwrite) {
                this.setValue((float)i.intValue() * multiplier);
            }
        });
        behaviours.add((BlockEntityBehaviour)this.value);
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        FloatingNode positive = builder.terminalNode(0);
        FloatingNode negative = builder.terminalNode(1);
        if (this.method_11010().method_27852((class_2248)ModdedBlocks.CREATIVE_VOLTAGE_SOURCE.get())) {
            this.voltageSource = true;
            this.voltageSourceNode = builder.addInternalNode(VoltageSourceCoupling.class, positive, negative, Float.valueOf(1.0E-4f));
        } else if (this.method_11010().method_27852((class_2248)ModdedBlocks.CREATIVE_CURRENT_SOURCE.get())) {
            this.voltageSource = false;
            this.currentSourceNode = builder.addInternalNode(CurrentSourceNode.class, new Object[0]);
            builder.couple(1.0f, 1.0E-4f, (IElectricNode)this.currentSourceNode, (IElectricNode)positive, (IElectricNode)negative);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.method_10545("Overwrite")) {
            this.overwrite = tag.method_10577("Overwrite");
        }
        this.setValue(tag.method_10583("NodeValue"));
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.overwrite) {
            tag.method_10556("Overwrite", true);
        }
        tag.method_10548("NodeValue", this.getValue());
    }

    public void writeSafe(class_2487 tag) {
        super.writeSafe(tag);
        if (this.overwrite) {
            tag.method_10556("Overwrite", true);
        }
        tag.method_10548("NodeValue", this.getValue());
    }

    public void setValue(float value) {
        if (this.voltageSource) {
            this.voltageSourceNode.setVoltage(value);
        } else {
            this.currentSourceNode.setCurrent(value);
        }
    }

    public float getValue() {
        if (this.voltageSource) {
            return this.voltageSourceNode.getVoltage();
        }
        return this.currentSourceNode.getCurrent();
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        Lang.translate("gui.creative_source.info_header", new Object[0]).forGoggles(tooltip);
        Lang.builder().translate("gui.creative_source.voltage", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        float voltage = this.voltageSource ? this.voltageSourceNode.getVoltage() : this.currentSourceNode.getVoltage();
        String voltageText = String.format("%.2f", Float.valueOf(voltage));
        Lang.builder().text(voltageText).add(class_2561.method_30163((String)" ")).add(Unit.VOLTAGE.get()).style(class_124.field_1078).forGoggles(tooltip, 1);
        Lang.builder().translate("gui.creative_source.current", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        float current = this.voltageSource ? -this.voltageSourceNode.getCurrent() : this.currentSourceNode.getCurrent();
        String currentText = String.format("%.2f", Float.valueOf(current));
        Lang.builder().text(currentText).add(class_2561.method_30163((String)" ")).add(Unit.CURRENT.get()).style(class_124.field_1060).forGoggles(tooltip, 1);
        return true;
    }

    public static class CreativeSourceBoxTransform
    extends CenteredSideValueBoxTransform {
        public CreativeSourceBoxTransform() {
            super((state, dir) -> dir.method_10166() != class_2350.class_2351.field_11052);
        }

        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)14.5);
        }
    }
}

