/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.fan;

import com.simibubi.create.content.logistics.chute.AbstractChuteBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import net.createmod.catnip.levelWrappers.WrappedLevel;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.DirectionalElectricBlock;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.BlockStateTerminalCollection;
import org.patryk3211.powergrid.electricity.fan.ElectricFanBlockEntity;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Resistance;
import org.patryk3211.powergrid.electricity.info.Voltage;

public class ElectricFanBlock
extends DirectionalElectricBlock
implements IBE<ElectricFanBlockEntity>,
IHaveElectricProperties {
    private static final TerminalBoundingBox[] UP_TERMINALS = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.POSITIVE, 5.0, 6.0, 7.0, 6.0, 7.0, 9.0).withColor(0xFF3B3B), new TerminalBoundingBox(IDecoratedTerminal.NEGATIVE, 10.0, 6.0, 7.0, 11.0, 7.0, 9.0).withColor(3899647)};
    private static final class_265 SHAPE_UP = class_259.method_1084((class_265)ElectricFanBlock.method_9541((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (class_265)ElectricFanBlock.method_9541((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0));

    public ElectricFanBlock(class_4970.class_2251 settings) {
        super(settings.method_22488());
        VoxelShaper shaper = VoxelShaper.forDirectional((class_265)SHAPE_UP, (class_2350)class_2350.field_11036);
        this.setTerminalCollection(BlockStateTerminalCollection.builder(this).forAllStates(state -> BlockStateTerminalCollection.each(UP_TERMINALS, terminal -> switch ((class_2350)state.method_11654((class_2769)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11036 -> terminal;
            case class_2350.field_11033 -> terminal.rotateAroundX(180);
            case class_2350.field_11043 -> terminal.rotateAroundX(90);
            case class_2350.field_11035 -> terminal.rotateAroundX(-90);
            case class_2350.field_11034 -> terminal.rotateAroundX(90).rotateAroundY(90);
            case class_2350.field_11039 -> terminal.rotateAroundX(90).rotateAroundY(-90);
        })).withShapeMapper(state -> shaper.get((class_2350)state.method_11654((class_2769)FACING))).build());
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 face = context.method_8038();
        class_2680 placedOn = world.method_8320(pos.method_10093(face.method_10153()));
        class_2680 placedOnOpposite = world.method_8320(pos.method_10093(face));
        if (AbstractChuteBlock.isChute((class_2680)placedOn)) {
            return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)face.method_10153());
        }
        if (AbstractChuteBlock.isChute((class_2680)placedOnOpposite)) {
            return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)face);
        }
        class_2350 preferredFacing = context.method_7715();
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)(context.method_8036() != null && context.method_8036().method_5715() ? preferredFacing : preferredFacing.method_10153()));
    }

    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        super.method_9615(state, worldIn, pos, oldState, isMoving);
        this.blockUpdate(state, (class_1936)worldIn, pos);
    }

    public void method_9517(class_2680 stateIn, class_1936 worldIn, class_2338 pos, int flags, int count) {
        super.method_9517(stateIn, worldIn, pos, flags, count);
        this.blockUpdate(stateIn, worldIn, pos);
    }

    public void method_9612(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        this.blockUpdate(state, (class_1936)worldIn, pos);
    }

    protected void blockUpdate(class_2680 state, class_1936 worldIn, class_2338 pos) {
        if (worldIn instanceof WrappedLevel) {
            return;
        }
        this.notifyFanBlockEntity(worldIn, pos);
    }

    protected void notifyFanBlockEntity(class_1936 world, class_2338 pos) {
        this.withBlockEntityDo((class_1922)world, pos, ElectricFanBlockEntity::blockInFrontChanged);
    }

    public class_2680 updateAfterWrenched(class_2680 newState, class_1838 context) {
        this.blockUpdate(newState, (class_1936)context.method_8045(), context.method_8037());
        return newState;
    }

    public Class<ElectricFanBlockEntity> getBlockEntityClass() {
        return ElectricFanBlockEntity.class;
    }

    public class_2591<? extends ElectricFanBlockEntity> getBlockEntityType() {
        return (class_2591)ModdedBlockEntities.ELECTRIC_FAN.get();
    }

    @Override
    public void appendProperties(class_1799 stack, class_1657 player, List<class_2561> tooltip) {
        Resistance.series(this.resistance(), player, tooltip);
        Voltage.max(this.resistance() * 4.0f, player, tooltip);
    }
}

