/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.fan;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;

public class ElectricFanBlockEntity
extends ElectricBlockEntity
implements IAirCurrentSource {
    public AirCurrent airCurrent = new AirCurrent((IAirCurrentSource)this);
    protected int airCurrentUpdateCooldown;
    protected int entitySearchCooldown;
    protected boolean updateAirFlow = true;
    private ElectricWire motor;
    private float prevSpeed;

    public ElectricFanBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.FAN_PROCESSING});
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.airCurrent.rebuild();
        }
    }

    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
    }

    public AirCurrent getAirCurrent() {
        return this.airCurrent;
    }

    @Nullable
    public class_1937 getAirCurrentWorld() {
        return this.field_11863;
    }

    public class_2338 getAirCurrentPos() {
        return this.field_11867;
    }

    public float getSpeed() {
        float speed = this.motor.current() * 64.0f;
        if (Math.abs(speed) < 1.0f) {
            return 0.0f;
        }
        if (speed > 256.0f) {
            speed = 256.0f;
        } else if (speed < -256.0f) {
            speed = -256.0f;
        }
        return speed;
    }

    public class_2350 getAirflowOriginSide() {
        return (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
    }

    public class_2350 getAirFlowDirection() {
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            return null;
        }
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        return (speed = KineticBlockEntity.convertToDirection((float)speed, (class_2350)facing)) > 0.0f ? facing : facing.method_10153();
    }

    @Override
    public void remove() {
        super.remove();
        this.updateChute();
    }

    public boolean isSourceRemoved() {
        return this.field_11865;
    }

    public void onSpeedChanged() {
        this.updateAirFlow = true;
        this.updateChute();
    }

    public void updateChute() {
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        if (!direction.method_10166().method_10178()) {
            return;
        }
        class_2586 poweredChute = this.field_11863.method_8321(this.field_11867.method_10093(direction));
        if (!(poweredChute instanceof ChuteBlockEntity)) {
            return;
        }
        ChuteBlockEntity chuteBE = (ChuteBlockEntity)poweredChute;
        if (direction == class_2350.field_11033) {
            chuteBE.updatePull();
        } else {
            chuteBE.updatePush(1);
        }
    }

    public void blockInFrontChanged() {
        this.updateAirFlow = true;
    }

    public void tick() {
        super.tick();
        boolean server = !this.field_11863.field_9236 || this.isVirtual();
        float speed = this.getSpeed();
        if (speed != this.prevSpeed) {
            this.onSpeedChanged();
            this.prevSpeed = speed;
        }
        if (server && this.airCurrentUpdateCooldown-- <= 0) {
            this.airCurrentUpdateCooldown = (Integer)AllConfigs.server().kinetics.fanBlockCheckRate.get();
            this.updateAirFlow = true;
        }
        if (this.updateAirFlow) {
            this.updateAirFlow = false;
            this.airCurrent.rebuild();
            this.sendData();
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.entitySearchCooldown-- <= 0) {
            this.entitySearchCooldown = 5;
            this.airCurrent.findEntities();
        }
        this.airCurrent.tick();
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.motor = builder.connect(this.resistance(), builder.terminalNode(0), builder.terminalNode(1));
    }
}

