/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.gauge;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.gauge.GaugeBlockEntity;
import org.patryk3211.powergrid.electricity.gauge.GaugeValueBehaviour;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public class CurrentGaugeBlockEntity
extends GaugeBlockEntity {
    private static final float[] MAX_VALUES = new float[]{0.02f, 0.2f, 2.0f, 20.0f};
    private ElectricWire wire;

    public CurrentGaugeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.gaugeValue = new GaugeValueBehaviour((class_2561)class_2561.method_43471((String)"powergrid.devices.gauge.current"), (class_2561)Unit.CURRENT.get().component(), MAX_VALUES, this, (ValueBoxTransform)new GaugeBlockEntity.BoxTransform());
        this.gaugeValue.withCallback(i -> {
            this.maxValue = MAX_VALUES[i];
            this.sendData();
        });
        behaviours.add((BlockEntityBehaviour)this.gaugeValue);
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.maxValue = MAX_VALUES[this.gaugeValue.getValue()];
    }

    @Override
    public void tick() {
        float current = Math.abs(this.getValue());
        this.dialTarget = current > this.maxValue ? 1.125f : current / this.maxValue;
        this.applyPower(this.wire);
        super.tick();
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        float resistance = this.resistance();
        builder.setTerminalCount(2);
        this.wire = builder.connect(resistance, builder.terminalNode(0), builder.terminalNode(1));
    }

    @Override
    public float getValue() {
        return this.wire.current();
    }

    @Override
    public Unit getUnit() {
        return Unit.CURRENT;
    }

    public static class_124 measurementColor(float value, float maxValue) {
        if ((double)value < (double)maxValue * 0.01) {
            return class_124.field_1063;
        }
        if ((double)value < (double)maxValue * 0.5) {
            return class_124.field_1060;
        }
        if ((double)value < (double)maxValue * 0.75) {
            return class_124.field_1054;
        }
        return class_124.field_1061;
    }

    public static void addTooltip(List<class_2561> tooltip, float current, float maxValue, boolean useMillis) {
        String currentText;
        Lang.builder().translate("gui.current_meter.title", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        if (!useMillis) {
            current = (float)Math.round(current * 100.0f) / 100.0f;
            currentText = String.format("%.2f", Float.valueOf(current));
            if (Math.abs(current) > maxValue) {
                currentText = current > 0.0f ? String.format("> %.2f", Float.valueOf(maxValue)) : String.format("< %.2f", Float.valueOf(-maxValue));
            }
        } else {
            current = (float)Math.round(current * 100000.0f) / 100.0f;
            currentText = String.format("%.1f", Float.valueOf(current));
            if (Math.abs(current / 1000.0f) > maxValue) {
                currentText = current > 0.0f ? String.format("> %.1f", Float.valueOf(maxValue * 1000.0f)) : String.format("< %.1f", Float.valueOf(-maxValue * 1000.0f));
            }
            current /= 1000.0f;
        }
        Lang.builder().text(currentText).add(class_2561.method_30163((String)(useMillis ? " m" : " "))).add(Unit.CURRENT.get()).style(CurrentGaugeBlockEntity.measurementColor(Math.abs(current), maxValue)).forGoggles(tooltip, 1);
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        CurrentGaugeBlockEntity.addTooltip(tooltip, this.getValue(), this.maxValue, this.gaugeValue.getValue() <= 1);
        return true;
    }
}

