/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.grounding;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedDamageTypes;
import org.patryk3211.powergrid.collections.ModdedTags;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public class GroundingRodBlockEntity
extends ElectricBlockEntity {
    private static final float DANGER_POTENTIAL = 48.0f;
    private SwitchedWire wire;
    private int groundCount;
    private int conductiveCount;
    private int damageTickCounter;

    public GroundingRodBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
    }

    private static int minBlocks() {
        return (Integer)ModdedConfigs.server().electricity.groundingMinimumBlocks.get();
    }

    private void scan(class_2338 pos) {
        assert (this.field_11863 != null);
        HashSet<class_2338> scanned = new HashSet<class_2338>();
        ArrayList<class_2338> queue = new ArrayList<class_2338>();
        queue.add(pos);
        while (!queue.isEmpty()) {
            class_2338 checkPos = (class_2338)queue.remove(0);
            if (!scanned.add(checkPos)) continue;
            for (class_2350 dir : class_2350.values()) {
                class_2338 nextPos = checkPos.method_10093(dir);
                if (scanned.contains(nextPos)) continue;
                class_2680 state = this.field_11863.method_8320(nextPos);
                if (state.method_26164(ModdedTags.Block.CONDUCTIVE_GROUND.tag)) {
                    ++this.conductiveCount;
                } else if (this.groundCount >= GroundingRodBlockEntity.minBlocks() || state.method_26212((class_1922)this.field_11863, nextPos) && ++this.groundCount >= GroundingRodBlockEntity.minBlocks()) continue;
                if (nextPos.method_19455((class_2382)pos) >= 10) continue;
                queue.add(nextPos);
            }
            if (this.conductiveCount < (Integer)ModdedConfigs.server().electricity.groundingMaximumBlocks.get() || this.groundCount < GroundingRodBlockEntity.minBlocks()) continue;
            break;
        }
    }

    public void lazyTick() {
        assert (this.field_11863 != null);
        super.lazyTick();
        if (!this.field_11863.field_9236) {
            int prevConductiveCount = this.conductiveCount;
            this.groundCount = 1;
            this.conductiveCount = 0;
            this.scan(this.method_11016().method_10074());
            boolean prevState = this.wire.getState();
            if (this.groundCount < GroundingRodBlockEntity.minBlocks()) {
                this.wire.setState(false);
            } else {
                float highR = ModdedConfigs.server().electricity.groundingHighestResistance.getF();
                float lowR = ModdedConfigs.server().electricity.groundingLowestResistance.getF();
                int maxBlocks = (Integer)ModdedConfigs.server().electricity.groundingMaximumBlocks.get();
                float delta = (highR - lowR) / (float)maxBlocks;
                float resistance = highR - delta * (float)this.conductiveCount / (float)maxBlocks;
                this.wire.setResistance(resistance);
                this.wire.setState(true);
            }
            if (prevState != this.wire.getState() || prevConductiveCount != this.conductiveCount) {
                this.notifyUpdate();
            }
        }
    }

    public void tick() {
        assert (this.field_11863 != null);
        super.tick();
        if (!this.field_11863.field_9236 && this.damageTickCounter++ >= 10) {
            this.damageTickCounter = 0;
            double dangerRadius = Math.min(Math.abs(this.wire.getResistance() * (double)this.wire.current() / 301.59289474462014), 10.0);
            int blockRadius = (int)Math.round(dangerRadius);
            class_238 bb = new class_238(this.field_11867.method_10069(-blockRadius, -blockRadius, -blockRadius), this.field_11867.method_10069(blockRadius, blockRadius, blockRadius));
            double sqrDist = dangerRadius * dangerRadius;
            class_243 center = this.field_11867.method_46558();
            List entities = this.field_11863.method_8390(class_1309.class, bb, e -> e.method_19538().method_1025(center) <= sqrDist && e.method_24828());
            class_2378 registry = this.field_11863.method_30349().method_30530(class_7924.field_42534);
            class_1282 source = new class_1282((class_6880)registry.method_40264(ModdedDamageTypes.ZAP).get());
            for (class_1309 entity : entities) {
                entity.method_5643(source, 1.0f);
            }
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(1);
        this.wire = builder.connectSwitch(1.0f, builder.terminalNode(0), null, false);
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.method_10545("Resistance")) {
            this.wire.setResistance(tag.method_10583("Resistance"));
            this.wire.setState(true);
        } else {
            this.wire.setState(false);
        }
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.wire.getState()) {
            tag.method_10548("Resistance", (float)this.wire.getResistance());
        }
    }
}

