/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.light.fixture;

import com.simibubi.create.foundation.block.IBE;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_6328;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.base.CustomProperties;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.BlockStateTerminalCollection;
import org.patryk3211.powergrid.electricity.light.bulb.ILightBulb;
import org.patryk3211.powergrid.electricity.light.bulb.LightBulbState;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlockEntity;
import org.patryk3211.powergrid.electricity.wire.powercord.AutoCordEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.IAcceptCord;

@ParametersAreNonnullByDefault
@class_6328
public class LightFixtureBlock
extends ElectricBlock
implements IBE<LightFixtureBlockEntity>,
IAcceptCord {
    public static final class_2753 FACING = class_2741.field_12525;
    public static final class_2758 POWER = class_2758.method_11867((String)"power", (int)0, (int)2);
    public static final class_2746 ALONG_FIRST_AXIS = CustomProperties.ALONG_FIRST_AXIS;
    private static final TerminalBoundingBox[] UP_TERMINALS = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 2.5, 1.5, 6.5, 4.5, 3.5, 9.5), new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 11.5, 1.5, 6.5, 13.5, 3.5, 9.5)};
    private static final class_265 SHAPE_UP = LightFixtureBlock.method_9541((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)3.0, (double)12.5);
    class_243 modelOffset = class_243.field_1353;

    public LightFixtureBlock(class_4970.class_2251 settings) {
        super(settings.method_9631(state -> switch ((Integer)state.method_11654((class_2769)POWER)) {
            case 1 -> 10;
            case 2 -> 15;
            default -> 0;
        }));
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)POWER, (Comparable)Integer.valueOf(0)));
        VoxelShaper shaper = VoxelShaper.forDirectional((class_265)SHAPE_UP, (class_2350)class_2350.field_11036);
        this.setTerminalCollection(BlockStateTerminalCollection.builder(this).forAllStatesExcept(state -> BlockStateTerminalCollection.each(UP_TERMINALS, terminal -> {
            class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
            switch (facing) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case field_11036: {
                    TerminalBoundingBox terminalBoundingBox = terminal;
                    break;
                }
                case field_11033: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundX(class_2470.field_11464);
                    break;
                }
                case field_11043: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundX(class_2470.field_11463);
                    break;
                }
                case field_11035: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundX(class_2470.field_11465);
                    break;
                }
                case field_11034: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundX(class_2470.field_11463).rotateAroundY(class_2470.field_11463);
                    break;
                }
                case field_11039: {
                    TerminalBoundingBox terminalBoundingBox = terminal = terminal.rotateAroundX(class_2470.field_11463).rotateAroundY(class_2470.field_11465);
                }
            }
            if (!((Boolean)state.method_11654((class_2769)ALONG_FIRST_AXIS)).booleanValue()) {
                terminal = terminal.rotate(facing.method_10166(), class_2470.field_11463);
            }
            return terminal;
        }), new class_2769[]{POWER}).withShapeMapper(state -> shaper.get((class_2350)state.method_11654((class_2769)FACING))).build());
    }

    public static <B extends LightFixtureBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> setBulbModelOffset(class_243 modelOffset) {
        return b -> {
            EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> b.onRegister(block -> {
                block.modelOffset = modelOffset;
            }));
            return b;
        };
    }

    public static <B extends LightFixtureBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> setBulbModelOffset(float x, float y, float z) {
        return b -> {
            EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> b.onRegister(block -> {
                block.modelOffset = new class_243((double)x, (double)y, (double)z);
            }));
            return b;
        };
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, POWER, ALONG_FIRST_AXIS});
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        return LightFixtureBlock.method_20044((class_4538)world, (class_2338)pos.method_10079(facing, -1), (class_2350)facing);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        return direction == facing.method_10153() && !this.method_9558(state, (class_4538)world, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 player;
        class_2350 facing = ctx.method_8038();
        boolean along = true;
        if (facing.method_10166() == class_2350.class_2351.field_11052 && (player = ctx.method_8042()).method_10166() == class_2350.class_2351.field_11048) {
            along = false;
        }
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657((class_2769)ALONG_FIRST_AXIS, (Comparable)Boolean.valueOf(along));
    }

    @Override
    public int terminalCount() {
        return 2;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7960() || stack.method_7909() instanceof ILightBulb) {
            return this.onBlockEntityUse((class_1922)world, pos, be -> be.replaceBulb(player, hand, stack) ? class_1269.field_5812 : class_1269.field_5814);
        }
        return class_1269.field_5811;
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 params) {
        LightFixtureBlockEntity fixture;
        LightBulbState bulb;
        class_2586 be = (class_2586)params.method_51876(class_181.field_1228);
        if (be instanceof LightFixtureBlockEntity && (bulb = (fixture = (LightFixtureBlockEntity)be).getBulbState()) != null && !bulb.isBurned()) {
            ArrayList<class_1799> drops = new ArrayList<class_1799>(super.method_9560(state, params));
            drops.add(new class_1799((class_1935)fixture.getBulbState().getItem(), 1));
            return drops;
        }
        return super.method_9560(state, params);
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        super.method_9585(world, pos, state);
    }

    public Class<LightFixtureBlockEntity> getBlockEntityClass() {
        return LightFixtureBlockEntity.class;
    }

    public class_2591<? extends LightFixtureBlockEntity> getBlockEntityType() {
        return (class_2591)ModdedBlockEntities.LIGHT_FIXTURE.get();
    }

    @Override
    @Nullable
    public AutoCordEndpoint getEndpoint(class_1838 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = level.method_8320(pos);
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_243 center = class_243.method_24953((class_2382)pos);
        class_2382 normal = facing.method_10163();
        class_243 point = center.method_1031((double)normal.method_10263() * -0.40625, (double)normal.method_10264() * -0.40625, (double)normal.method_10260() * -0.40625);
        return new AutoCordEndpoint(context.method_8037(), 0, 1, point, this.renderPlug() ? context.method_8038() : null);
    }
}

