/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.light.fixture;

import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.light.bulb.ILightBulb;
import org.patryk3211.powergrid.electricity.light.bulb.LightBulbState;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlock;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public class LightFixtureBlockEntity
extends ElectricBlockEntity {
    private SwitchedWire filament;
    @Nullable
    private LightBulbState bulbState = null;

    public LightFixtureBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        if (this.bulbState != null) {
            this.bulbState.tick();
            this.method_5431();
        }
    }

    private void lightBulbChanged() {
        if (this.bulbState == null) {
            this.filament.setState(false);
        } else {
            this.filament.setResistance(this.bulbState.resistance());
            this.filament.setState(!this.bulbState.isBurned());
        }
        this.notifyUpdate();
    }

    @Nullable
    public LightBulbState getBulbState() {
        return this.bulbState;
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.bulbState != null) {
            this.bulbState.write(tag);
        }
    }

    public void writeSafe(class_2487 tag) {
        super.writeSafe(tag);
        if (this.bulbState != null) {
            this.bulbState.write(tag);
        }
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        class_1792 currentItem = this.bulbState != null ? this.bulbState.getItem() : null;
        class_1792 nbtItem = LightBulbState.getBulbItem(tag);
        if (currentItem != nbtItem) {
            this.bulbState = nbtItem == null ? null : ((ILightBulb)nbtItem).createState(this);
        }
        if (this.bulbState != null) {
            this.bulbState.read(tag);
        }
        this.lightBulbChanged();
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.filament = builder.connectSwitch(1.0f, builder.terminalNode(0), builder.terminalNode(1), false);
    }

    public boolean replaceBulb(class_1657 player, class_1268 hand, class_1799 usedStack) {
        assert (this.field_11863 != null);
        boolean result = this.replaceBulbInternal(player, hand, usedStack);
        if (result) {
            this.lightBulbChanged();
            if (!this.field_11863.field_9236 && this.bulbState == null) {
                this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)LightFixtureBlock.POWER, (Comparable)Integer.valueOf(0)), 3);
            }
        }
        return result;
    }

    private boolean replaceBulbInternal(class_1657 player, class_1268 hand, class_1799 usedStack) {
        assert (this.field_11863 != null);
        if (usedStack == null || usedStack.method_7960()) {
            if (this.bulbState == null) {
                return false;
            }
            if (!this.field_11863.field_9236) {
                if (!this.bulbState.isBurned()) {
                    player.method_6122(hand, this.bulbState.toStack());
                }
                this.bulbState = null;
            }
            return true;
        }
        if (this.bulbState == null) {
            class_1792 item;
            if (!this.field_11863.field_9236 && (item = usedStack.method_7909()) instanceof ILightBulb) {
                ILightBulb bulb = (ILightBulb)item;
                this.bulbState = bulb.createState(this);
                if (!player.method_7337()) {
                    usedStack.method_7934(1);
                }
            }
            return true;
        }
        if (this.bulbState.isBurned()) {
            if (!this.field_11863.field_9236) {
                this.bulbState = null;
            }
            return true;
        }
        if (this.bulbState.isOf(usedStack.method_7909()) && usedStack.method_7947() < usedStack.method_7914()) {
            if (!this.field_11863.field_9236) {
                if (!player.method_7337()) {
                    usedStack.method_7933(1);
                }
                this.bulbState = null;
            }
            return true;
        }
        if (player.method_7337()) {
            this.bulbState = null;
            return true;
        }
        return false;
    }

    public SwitchedWire getFilament() {
        return this.filament;
    }

    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867);
    }

    public ItemRequirement getRequiredItems(class_2680 state) {
        if (this.bulbState != null) {
            return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.bulbState.getItem());
        }
        return ItemRequirement.NONE;
    }
}

