/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.transformer;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_8567;
import org.patryk3211.powergrid.collections.ModdedBlocks;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.transformer.TransformerBlockEntity;
import org.patryk3211.powergrid.electricity.transformer.TransformerCoilParameters;
import org.patryk3211.powergrid.electricity.transformer.TransformerCoreBlock;
import org.patryk3211.powergrid.electricity.transformer.TransformerWindingScreen;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.PlayerUtilities;

public abstract class TransformerBlock
extends ElectricBlock {
    public static final class_2758 COILS = class_2758.method_11867((String)"coils", (int)0, (int)2);
    private final int maxTurns;

    public TransformerBlock(class_4970.class_2251 settings, int maxTurns) {
        super(settings);
        this.maxTurns = maxTurns;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return ((TransformerCoreBlock)((Object)ModdedBlocks.TRANSFORMER_CORE.get())).method_9574(world, pos, state);
    }

    public abstract Optional<TransformerBlockEntity> getBlockEntity(class_1937 var1, class_2338 var2, class_2680 var3);

    protected abstract boolean isInitiator(class_2338 var1, class_2680 var2, class_2338 var3);

    @Override
    public ElectricBehaviour getBehaviour(class_1937 world, class_2338 pos, class_2680 state) {
        Optional<TransformerBlockEntity> be = this.getBlockEntity(world, pos, state);
        return be.map(ElectricBlockEntity::getElectricBehaviour).orElse(null);
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 params) {
        class_2586 be = (class_2586)params.method_51876(class_181.field_1228);
        if (!(be instanceof TransformerBlockEntity)) {
            return super.method_9560(state, params);
        }
        TransformerBlockEntity tbe = (TransformerBlockEntity)be;
        ArrayList<class_1799> drops = new ArrayList<class_1799>(super.method_9560(state, params));
        int turns = 0;
        if (tbe.getSecondary() != null) {
            turns += tbe.getSecondary().getTurns();
        }
        if (tbe.getPrimary() != null) {
            turns += tbe.getPrimary().getTurns();
        }
        while (turns > 0) {
            class_1799 stack = ModdedItems.WIRE.asStack(Math.min(turns, 64));
            drops.add(stack);
            turns -= 64;
        }
        return drops;
    }

    public class_1269 onWinding(class_2680 state, class_1838 context) {
        class_2338 pos = context.method_8037();
        int terminal = this.terminalIndexAt(state, context.method_17698().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
        class_1799 stack = context.method_8041();
        class_2487 nbt = stack.method_7969();
        int turns = nbt.method_10550("Turns");
        return this.getBlockEntity(context.method_8045(), context.method_8037(), state).map(be -> {
            if (terminal >= 0) {
                int firstTerminal = nbt.method_10550("Terminal");
                if (terminal == firstTerminal) {
                    IElectric.sendMessage(context, (class_2561)Lang.translate("message.coil_same_terminal", new Object[0]).style(class_124.field_1061).component());
                    return class_1269.field_5814;
                }
                class_1657 player = context.method_8036();
                if (!PlayerUtilities.hasEnoughItems(player, stack, turns)) {
                    IElectric.sendMessage(context, (class_2561)Lang.translate("message.coil_missing_items", new Object[0]).style(class_124.field_1061).component());
                    return class_1269.field_5814;
                }
                if (be.hasPrimary()) {
                    if (turns + be.getPrimary().getTurns() > this.maxTurns) {
                        IElectric.sendMessage(context, (class_2561)Lang.translate("message.coil_max_turns", new Object[0]).style(class_124.field_1061).component());
                        return class_1269.field_5814;
                    }
                } else if (turns > this.maxTurns) {
                    IElectric.sendMessage(context, (class_2561)Lang.translate("message.coil_max_turns", new Object[0]).style(class_124.field_1061).component());
                    return class_1269.field_5814;
                }
                if (!context.method_8045().field_9236) {
                    if (be.hasPrimary()) {
                        be.makeSecondary(firstTerminal, terminal, turns, stack.method_7909());
                    } else {
                        be.makePrimary(firstTerminal, terminal, turns, stack.method_7909());
                    }
                    PlayerUtilities.removeItems(player, stack, turns);
                    stack.method_7980(null);
                }
                return class_1269.field_5812;
            }
            if (context.method_8045().field_9236) {
                int cap = be.hasPrimary() ? be.getPrimary().getTurns() : 0;
                boolean b = TransformerWindingScreen.beginInteraction(() -> new TransformerWindingScreen(this, context.method_20287(), turns, cap));
                return b ? class_1269.field_5812 : class_1269.field_21466;
            }
            return class_1269.field_5812;
        }).orElse(class_1269.field_5814);
    }

    @Override
    public class_1269 onWire(class_2680 state, class_1838 context) {
        class_2487 nbt;
        class_1799 stack = context.method_8041();
        if (stack.method_7985() && (nbt = stack.method_7969()).method_10545("Turns")) {
            int[] posArray = nbt.method_10561("Initiator");
            class_2338 initiatorPosition = new class_2338(posArray[0], posArray[1], posArray[2]);
            if (this.isInitiator(context.method_8037(), state, initiatorPosition)) {
                return this.onWinding(state, context);
            }
            return class_1269.field_5814;
        }
        class_1269 result = super.onWire(state, context);
        if (result == class_1269.field_5811 && stack.method_7985()) {
            if (!stack.method_31574((class_1792)ModdedItems.WIRE.get())) {
                return class_1269.field_5814;
            }
            return this.getBlockEntity(context.method_8045(), context.method_8037(), state).map(be -> {
                class_2487 nbt = stack.method_7969();
                IWireEndpoint endpoint = WireEndpointType.deserialize(nbt);
                if (endpoint.type() != WireEndpointType.BLOCK) {
                    return class_1269.field_5814;
                }
                BlockWireEndpoint blockEndpoint = (BlockWireEndpoint)endpoint;
                if (be.isTerminalUsed(blockEndpoint.getTerminal())) {
                    IElectric.sendMessage(context, (class_2561)Lang.translate("message.coil_exists", new Object[0]).style(class_124.field_1061).component());
                    return class_1269.field_5814;
                }
                if (this.isInitiator(context.method_8037(), state, blockEndpoint.getPos())) {
                    if (context.method_8045().field_9236) {
                        int cap = be.hasPrimary() ? be.getPrimary().getTurns() : 0;
                        boolean b = TransformerWindingScreen.beginInteraction(() -> new TransformerWindingScreen(this, context.method_20287(), 1, cap));
                        return b ? class_1269.field_5812 : class_1269.field_21466;
                    }
                    return class_1269.field_5812;
                }
                return class_1269.field_5811;
            }).orElse(class_1269.field_5814);
        }
        return result;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31574((class_1792)ModdedItems.WIRE_CUTTER.get()) && !world.field_9236) {
            Optional<TransformerBlockEntity> be = this.getBlockEntity(world, pos, state);
            if (be.isEmpty()) {
                return class_1269.field_5814;
            }
            if (be.get().hasSecondary()) {
                if (!player.method_7337()) {
                    int count;
                    TransformerCoilParameters coil = be.get().getSecondary();
                    class_1792 item = coil.getItem();
                    for (int items = count = coil.getTurns(); items > 0; items -= 64) {
                        player.method_7270(new class_1799((class_1935)item, Math.min(64, items)));
                    }
                }
                be.get().removeSecondary();
                return class_1269.field_5812;
            }
            if (be.get().hasPrimary()) {
                if (!player.method_7337()) {
                    int count;
                    TransformerCoilParameters coil = be.get().getPrimary();
                    class_1792 item = coil.getItem();
                    for (int items = count = coil.getTurns(); items > 0; items -= 64) {
                        player.method_7270(new class_1799((class_1935)item, Math.min(64, items)));
                    }
                }
                be.get().removePrimary();
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public int getMaxTurns() {
        return this.maxTurns;
    }
}

